<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresaleDescriptor StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PresaleDescriptor
 * @subpackage Structs
 */
class PresaleDescriptor extends AbstractStructBase
{
    /**
     * The AccessCodeMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AccessCodeMode;
    /**
     * The AccessCodeTexts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $AccessCodeTexts;
    /**
     * The AccessCreditCardTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AccessCreditCardTypeIds;
    /**
     * The AccessCreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCreditCompanyId;
    /**
     * The AllocationTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AllocationTypeIds;
    /**
     * The AllowAdvertisingOnSeatGeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowAdvertisingOnSeatGeek;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ClientTypeIds;
    /**
     * The DisplayDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayDescription;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayName;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IconUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconUrl;
    /**
     * The IsCodeTextSecret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCodeTextSecret;
    /**
     * The MaxTicketsPerAccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerAccessCode;
    /**
     * The MaxTicketsPerCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerCustomer;
    /**
     * The MaxTransactionsPerAccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $MaxTransactionsPerAccessCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OverrideId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OverrideId;
    /**
     * The PaymentCorrelation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentCorrelation;
    /**
     * The PaymentCreditCardTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PaymentCreditCardTypeIds;
    /**
     * The PaymentCreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentCreditCompanyId;
    /**
     * The PaymentMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentMode;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PriceTypeIds;
    /**
     * The RankWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RankWeight;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The TestClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TestClientTypeId;
    /**
     * The VisibilityStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelativeTime
     */
    public $VisibilityStart;
    /**
     * The WrongCardMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WrongCardMessage;
    /**
     * Constructor method for PresaleDescriptor
     * @uses PresaleDescriptor::setAccessCodeMode()
     * @uses PresaleDescriptor::setAccessCodeTexts()
     * @uses PresaleDescriptor::setAccessCreditCardTypeIds()
     * @uses PresaleDescriptor::setAccessCreditCompanyId()
     * @uses PresaleDescriptor::setAllocationTypeIds()
     * @uses PresaleDescriptor::setAllowAdvertisingOnSeatGeek()
     * @uses PresaleDescriptor::setClientTypeIds()
     * @uses PresaleDescriptor::setDisplayDescription()
     * @uses PresaleDescriptor::setDisplayName()
     * @uses PresaleDescriptor::setEndDate()
     * @uses PresaleDescriptor::setEventId()
     * @uses PresaleDescriptor::setIconUrl()
     * @uses PresaleDescriptor::setIsCodeTextSecret()
     * @uses PresaleDescriptor::setMaxTicketsPerAccessCode()
     * @uses PresaleDescriptor::setMaxTicketsPerCustomer()
     * @uses PresaleDescriptor::setMaxTransactionsPerAccessCode()
     * @uses PresaleDescriptor::setName()
     * @uses PresaleDescriptor::setOverrideId()
     * @uses PresaleDescriptor::setPaymentCorrelation()
     * @uses PresaleDescriptor::setPaymentCreditCardTypeIds()
     * @uses PresaleDescriptor::setPaymentCreditCompanyId()
     * @uses PresaleDescriptor::setPaymentMode()
     * @uses PresaleDescriptor::setPriceTypeIds()
     * @uses PresaleDescriptor::setRankWeight()
     * @uses PresaleDescriptor::setSeriesId()
     * @uses PresaleDescriptor::setShowId()
     * @uses PresaleDescriptor::setShowTypeId()
     * @uses PresaleDescriptor::setStartDate()
     * @uses PresaleDescriptor::setTestClientTypeId()
     * @uses PresaleDescriptor::setVisibilityStart()
     * @uses PresaleDescriptor::setWrongCardMessage()
     * @param string[] $accessCodeMode
     * @param \patest\ArrayType\ArrayOfstring $accessCodeTexts
     * @param \patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds
     * @param string $accessCreditCompanyId
     * @param \patest\ArrayType\ArrayOfguid $allocationTypeIds
     * @param bool $allowAdvertisingOnSeatGeek
     * @param \patest\ArrayType\ArrayOfguid $clientTypeIds
     * @param \patest\StructType\GlobalString $displayDescription
     * @param \patest\StructType\GlobalString $displayName
     * @param string $endDate
     * @param string $eventId
     * @param string $iconUrl
     * @param bool $isCodeTextSecret
     * @param int $maxTicketsPerAccessCode
     * @param int $maxTicketsPerCustomer
     * @param string[] $maxTransactionsPerAccessCode
     * @param \patest\StructType\GlobalString $name
     * @param string $overrideId
     * @param string[] $paymentCorrelation
     * @param \patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds
     * @param string $paymentCreditCompanyId
     * @param string[] $paymentMode
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @param int $rankWeight
     * @param string $seriesId
     * @param string $showId
     * @param string $showTypeId
     * @param string $startDate
     * @param string $testClientTypeId
     * @param \patest\StructType\RelativeTime $visibilityStart
     * @param string $wrongCardMessage
     */
    public function __construct(array $accessCodeMode = array(), \patest\ArrayType\ArrayOfstring $accessCodeTexts = null, \patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds = null, $accessCreditCompanyId = null, \patest\ArrayType\ArrayOfguid $allocationTypeIds = null, $allowAdvertisingOnSeatGeek = null, \patest\ArrayType\ArrayOfguid $clientTypeIds = null, \patest\StructType\GlobalString $displayDescription = null, \patest\StructType\GlobalString $displayName = null, $endDate = null, $eventId = null, $iconUrl = null, $isCodeTextSecret = null, $maxTicketsPerAccessCode = null, $maxTicketsPerCustomer = null, array $maxTransactionsPerAccessCode = array(), \patest\StructType\GlobalString $name = null, $overrideId = null, array $paymentCorrelation = array(), \patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds = null, $paymentCreditCompanyId = null, array $paymentMode = array(), \patest\ArrayType\ArrayOfguid $priceTypeIds = null, $rankWeight = null, $seriesId = null, $showId = null, $showTypeId = null, $startDate = null, $testClientTypeId = null, \patest\StructType\RelativeTime $visibilityStart = null, $wrongCardMessage = null)
    {
        $this
            ->setAccessCodeMode($accessCodeMode)
            ->setAccessCodeTexts($accessCodeTexts)
            ->setAccessCreditCardTypeIds($accessCreditCardTypeIds)
            ->setAccessCreditCompanyId($accessCreditCompanyId)
            ->setAllocationTypeIds($allocationTypeIds)
            ->setAllowAdvertisingOnSeatGeek($allowAdvertisingOnSeatGeek)
            ->setClientTypeIds($clientTypeIds)
            ->setDisplayDescription($displayDescription)
            ->setDisplayName($displayName)
            ->setEndDate($endDate)
            ->setEventId($eventId)
            ->setIconUrl($iconUrl)
            ->setIsCodeTextSecret($isCodeTextSecret)
            ->setMaxTicketsPerAccessCode($maxTicketsPerAccessCode)
            ->setMaxTicketsPerCustomer($maxTicketsPerCustomer)
            ->setMaxTransactionsPerAccessCode($maxTransactionsPerAccessCode)
            ->setName($name)
            ->setOverrideId($overrideId)
            ->setPaymentCorrelation($paymentCorrelation)
            ->setPaymentCreditCardTypeIds($paymentCreditCardTypeIds)
            ->setPaymentCreditCompanyId($paymentCreditCompanyId)
            ->setPaymentMode($paymentMode)
            ->setPriceTypeIds($priceTypeIds)
            ->setRankWeight($rankWeight)
            ->setSeriesId($seriesId)
            ->setShowId($showId)
            ->setShowTypeId($showTypeId)
            ->setStartDate($startDate)
            ->setTestClientTypeId($testClientTypeId)
            ->setVisibilityStart($visibilityStart)
            ->setWrongCardMessage($wrongCardMessage);
    }
    /**
     * Get AccessCodeMode value
     * @return string[]|null
     */
    public function getAccessCodeMode()
    {
        return $this->AccessCodeMode;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessCodeMode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessCodeMode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessCodeModeForArrayConstraintsFromSetAccessCodeMode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleDescriptorAccessCodeModeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\AccessCodeScheme::valueIsValid($presaleDescriptorAccessCodeModeItem)) {
                $invalidValues[] = is_object($presaleDescriptorAccessCodeModeItem) ? get_class($presaleDescriptorAccessCodeModeItem) : sprintf('%s(%s)', gettype($presaleDescriptorAccessCodeModeItem), var_export($presaleDescriptorAccessCodeModeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCodeScheme', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\AccessCodeScheme::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessCodeMode value
     * @uses \patest\EnumType\AccessCodeScheme::valueIsValid()
     * @uses \patest\EnumType\AccessCodeScheme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessCodeMode
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setAccessCodeMode(array $accessCodeMode = array())
    {
        // validation for constraint: list
        if ('' !== ($accessCodeModeArrayErrorMessage = self::validateAccessCodeModeForArrayConstraintsFromSetAccessCodeMode($accessCodeMode))) {
            throw new \InvalidArgumentException($accessCodeModeArrayErrorMessage, __LINE__);
        }
        $this->AccessCodeMode = is_array($accessCodeMode) ? implode(' ', $accessCodeMode) : null;
        return $this;
    }
    /**
     * Get AccessCodeTexts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getAccessCodeTexts()
    {
        return isset($this->AccessCodeTexts) ? $this->AccessCodeTexts : null;
    }
    /**
     * Set AccessCodeTexts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $accessCodeTexts
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setAccessCodeTexts(\patest\ArrayType\ArrayOfstring $accessCodeTexts = null)
    {
        if (is_null($accessCodeTexts) || (is_array($accessCodeTexts) && empty($accessCodeTexts))) {
            unset($this->AccessCodeTexts);
        } else {
            $this->AccessCodeTexts = $accessCodeTexts;
        }
        return $this;
    }
    /**
     * Get AccessCreditCardTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAccessCreditCardTypeIds()
    {
        return isset($this->AccessCreditCardTypeIds) ? $this->AccessCreditCardTypeIds : null;
    }
    /**
     * Set AccessCreditCardTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setAccessCreditCardTypeIds(\patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds = null)
    {
        if (is_null($accessCreditCardTypeIds) || (is_array($accessCreditCardTypeIds) && empty($accessCreditCardTypeIds))) {
            unset($this->AccessCreditCardTypeIds);
        } else {
            $this->AccessCreditCardTypeIds = $accessCreditCardTypeIds;
        }
        return $this;
    }
    /**
     * Get AccessCreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCreditCompanyId()
    {
        return isset($this->AccessCreditCompanyId) ? $this->AccessCreditCompanyId : null;
    }
    /**
     * Set AccessCreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCreditCompanyId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setAccessCreditCompanyId($accessCreditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCreditCompanyId) && !is_string($accessCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCreditCompanyId, true), gettype($accessCreditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCreditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCreditCompanyId, true)), __LINE__);
        }
        if (is_null($accessCreditCompanyId) || (is_array($accessCreditCompanyId) && empty($accessCreditCompanyId))) {
            unset($this->AccessCreditCompanyId);
        } else {
            $this->AccessCreditCompanyId = $accessCreditCompanyId;
        }
        return $this;
    }
    /**
     * Get AllocationTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAllocationTypeIds()
    {
        return isset($this->AllocationTypeIds) ? $this->AllocationTypeIds : null;
    }
    /**
     * Set AllocationTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $allocationTypeIds
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setAllocationTypeIds(\patest\ArrayType\ArrayOfguid $allocationTypeIds = null)
    {
        if (is_null($allocationTypeIds) || (is_array($allocationTypeIds) && empty($allocationTypeIds))) {
            unset($this->AllocationTypeIds);
        } else {
            $this->AllocationTypeIds = $allocationTypeIds;
        }
        return $this;
    }
    /**
     * Get AllowAdvertisingOnSeatGeek value
     * @return bool|null
     */
    public function getAllowAdvertisingOnSeatGeek()
    {
        return $this->AllowAdvertisingOnSeatGeek;
    }
    /**
     * Set AllowAdvertisingOnSeatGeek value
     * @param bool $allowAdvertisingOnSeatGeek
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setAllowAdvertisingOnSeatGeek($allowAdvertisingOnSeatGeek = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAdvertisingOnSeatGeek) && !is_bool($allowAdvertisingOnSeatGeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowAdvertisingOnSeatGeek, true), gettype($allowAdvertisingOnSeatGeek)), __LINE__);
        }
        $this->AllowAdvertisingOnSeatGeek = $allowAdvertisingOnSeatGeek;
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $clientTypeIds
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setClientTypeIds(\patest\ArrayType\ArrayOfguid $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get DisplayDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayDescription()
    {
        return isset($this->DisplayDescription) ? $this->DisplayDescription : null;
    }
    /**
     * Set DisplayDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayDescription
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setDisplayDescription(\patest\StructType\GlobalString $displayDescription = null)
    {
        if (is_null($displayDescription) || (is_array($displayDescription) && empty($displayDescription))) {
            unset($this->DisplayDescription);
        } else {
            $this->DisplayDescription = $displayDescription;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayName
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setDisplayName(\patest\StructType\GlobalString $displayName = null)
    {
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IconUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconUrl()
    {
        return isset($this->IconUrl) ? $this->IconUrl : null;
    }
    /**
     * Set IconUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconUrl
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setIconUrl($iconUrl = null)
    {
        // validation for constraint: string
        if (!is_null($iconUrl) && !is_string($iconUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconUrl, true), gettype($iconUrl)), __LINE__);
        }
        if (is_null($iconUrl) || (is_array($iconUrl) && empty($iconUrl))) {
            unset($this->IconUrl);
        } else {
            $this->IconUrl = $iconUrl;
        }
        return $this;
    }
    /**
     * Get IsCodeTextSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCodeTextSecret()
    {
        return isset($this->IsCodeTextSecret) ? $this->IsCodeTextSecret : null;
    }
    /**
     * Set IsCodeTextSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCodeTextSecret
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setIsCodeTextSecret($isCodeTextSecret = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCodeTextSecret) && !is_bool($isCodeTextSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCodeTextSecret, true), gettype($isCodeTextSecret)), __LINE__);
        }
        if (is_null($isCodeTextSecret) || (is_array($isCodeTextSecret) && empty($isCodeTextSecret))) {
            unset($this->IsCodeTextSecret);
        } else {
            $this->IsCodeTextSecret = $isCodeTextSecret;
        }
        return $this;
    }
    /**
     * Get MaxTicketsPerAccessCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerAccessCode()
    {
        return isset($this->MaxTicketsPerAccessCode) ? $this->MaxTicketsPerAccessCode : null;
    }
    /**
     * Set MaxTicketsPerAccessCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerAccessCode
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setMaxTicketsPerAccessCode($maxTicketsPerAccessCode = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerAccessCode) && !(is_int($maxTicketsPerAccessCode) || ctype_digit($maxTicketsPerAccessCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerAccessCode, true), gettype($maxTicketsPerAccessCode)), __LINE__);
        }
        if (is_null($maxTicketsPerAccessCode) || (is_array($maxTicketsPerAccessCode) && empty($maxTicketsPerAccessCode))) {
            unset($this->MaxTicketsPerAccessCode);
        } else {
            $this->MaxTicketsPerAccessCode = $maxTicketsPerAccessCode;
        }
        return $this;
    }
    /**
     * Get MaxTicketsPerCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerCustomer()
    {
        return isset($this->MaxTicketsPerCustomer) ? $this->MaxTicketsPerCustomer : null;
    }
    /**
     * Set MaxTicketsPerCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerCustomer
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setMaxTicketsPerCustomer($maxTicketsPerCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerCustomer) && !(is_int($maxTicketsPerCustomer) || ctype_digit($maxTicketsPerCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerCustomer, true), gettype($maxTicketsPerCustomer)), __LINE__);
        }
        if (is_null($maxTicketsPerCustomer) || (is_array($maxTicketsPerCustomer) && empty($maxTicketsPerCustomer))) {
            unset($this->MaxTicketsPerCustomer);
        } else {
            $this->MaxTicketsPerCustomer = $maxTicketsPerCustomer;
        }
        return $this;
    }
    /**
     * Get MaxTransactionsPerAccessCode value
     * @return string[]|null
     */
    public function getMaxTransactionsPerAccessCode()
    {
        return $this->MaxTransactionsPerAccessCode;
    }
    /**
     * This method is responsible for validating the values passed to the setMaxTransactionsPerAccessCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaxTransactionsPerAccessCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaxTransactionsPerAccessCodeForArrayConstraintsFromSetMaxTransactionsPerAccessCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleDescriptorMaxTransactionsPerAccessCodeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\AccessCodeUsageType::valueIsValid($presaleDescriptorMaxTransactionsPerAccessCodeItem)) {
                $invalidValues[] = is_object($presaleDescriptorMaxTransactionsPerAccessCodeItem) ? get_class($presaleDescriptorMaxTransactionsPerAccessCodeItem) : sprintf('%s(%s)', gettype($presaleDescriptorMaxTransactionsPerAccessCodeItem), var_export($presaleDescriptorMaxTransactionsPerAccessCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCodeUsageType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\AccessCodeUsageType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MaxTransactionsPerAccessCode value
     * @uses \patest\EnumType\AccessCodeUsageType::valueIsValid()
     * @uses \patest\EnumType\AccessCodeUsageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $maxTransactionsPerAccessCode
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setMaxTransactionsPerAccessCode(array $maxTransactionsPerAccessCode = array())
    {
        // validation for constraint: list
        if ('' !== ($maxTransactionsPerAccessCodeArrayErrorMessage = self::validateMaxTransactionsPerAccessCodeForArrayConstraintsFromSetMaxTransactionsPerAccessCode($maxTransactionsPerAccessCode))) {
            throw new \InvalidArgumentException($maxTransactionsPerAccessCodeArrayErrorMessage, __LINE__);
        }
        $this->MaxTransactionsPerAccessCode = is_array($maxTransactionsPerAccessCode) ? implode(' ', $maxTransactionsPerAccessCode) : null;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OverrideId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideId()
    {
        return isset($this->OverrideId) ? $this->OverrideId : null;
    }
    /**
     * Set OverrideId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setOverrideId($overrideId = null)
    {
        // validation for constraint: string
        if (!is_null($overrideId) && !is_string($overrideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideId, true), gettype($overrideId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($overrideId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $overrideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($overrideId, true)), __LINE__);
        }
        if (is_null($overrideId) || (is_array($overrideId) && empty($overrideId))) {
            unset($this->OverrideId);
        } else {
            $this->OverrideId = $overrideId;
        }
        return $this;
    }
    /**
     * Get PaymentCorrelation value
     * @return string[]|null
     */
    public function getPaymentCorrelation()
    {
        return $this->PaymentCorrelation;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentCorrelation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCorrelation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentCorrelationForArrayConstraintsFromSetPaymentCorrelation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleDescriptorPaymentCorrelationItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentCorrelationType::valueIsValid($presaleDescriptorPaymentCorrelationItem)) {
                $invalidValues[] = is_object($presaleDescriptorPaymentCorrelationItem) ? get_class($presaleDescriptorPaymentCorrelationItem) : sprintf('%s(%s)', gettype($presaleDescriptorPaymentCorrelationItem), var_export($presaleDescriptorPaymentCorrelationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentCorrelationType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentCorrelationType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentCorrelation value
     * @uses \patest\EnumType\PaymentCorrelationType::valueIsValid()
     * @uses \patest\EnumType\PaymentCorrelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentCorrelation
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setPaymentCorrelation(array $paymentCorrelation = array())
    {
        // validation for constraint: list
        if ('' !== ($paymentCorrelationArrayErrorMessage = self::validatePaymentCorrelationForArrayConstraintsFromSetPaymentCorrelation($paymentCorrelation))) {
            throw new \InvalidArgumentException($paymentCorrelationArrayErrorMessage, __LINE__);
        }
        $this->PaymentCorrelation = is_array($paymentCorrelation) ? implode(' ', $paymentCorrelation) : null;
        return $this;
    }
    /**
     * Get PaymentCreditCardTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPaymentCreditCardTypeIds()
    {
        return isset($this->PaymentCreditCardTypeIds) ? $this->PaymentCreditCardTypeIds : null;
    }
    /**
     * Set PaymentCreditCardTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setPaymentCreditCardTypeIds(\patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds = null)
    {
        if (is_null($paymentCreditCardTypeIds) || (is_array($paymentCreditCardTypeIds) && empty($paymentCreditCardTypeIds))) {
            unset($this->PaymentCreditCardTypeIds);
        } else {
            $this->PaymentCreditCardTypeIds = $paymentCreditCardTypeIds;
        }
        return $this;
    }
    /**
     * Get PaymentCreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentCreditCompanyId()
    {
        return isset($this->PaymentCreditCompanyId) ? $this->PaymentCreditCompanyId : null;
    }
    /**
     * Set PaymentCreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentCreditCompanyId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setPaymentCreditCompanyId($paymentCreditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCreditCompanyId) && !is_string($paymentCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCreditCompanyId, true), gettype($paymentCreditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentCreditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentCreditCompanyId, true)), __LINE__);
        }
        if (is_null($paymentCreditCompanyId) || (is_array($paymentCreditCompanyId) && empty($paymentCreditCompanyId))) {
            unset($this->PaymentCreditCompanyId);
        } else {
            $this->PaymentCreditCompanyId = $paymentCreditCompanyId;
        }
        return $this;
    }
    /**
     * Get PaymentMode value
     * @return string[]|null
     */
    public function getPaymentMode()
    {
        return $this->PaymentMode;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentModeForArrayConstraintsFromSetPaymentMode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleDescriptorPaymentModeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentValidationScheme::valueIsValid($presaleDescriptorPaymentModeItem)) {
                $invalidValues[] = is_object($presaleDescriptorPaymentModeItem) ? get_class($presaleDescriptorPaymentModeItem) : sprintf('%s(%s)', gettype($presaleDescriptorPaymentModeItem), var_export($presaleDescriptorPaymentModeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentValidationScheme', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentValidationScheme::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMode value
     * @uses \patest\EnumType\PaymentValidationScheme::valueIsValid()
     * @uses \patest\EnumType\PaymentValidationScheme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentMode
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setPaymentMode(array $paymentMode = array())
    {
        // validation for constraint: list
        if ('' !== ($paymentModeArrayErrorMessage = self::validatePaymentModeForArrayConstraintsFromSetPaymentMode($paymentMode))) {
            throw new \InvalidArgumentException($paymentModeArrayErrorMessage, __LINE__);
        }
        $this->PaymentMode = is_array($paymentMode) ? implode(' ', $paymentMode) : null;
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setPriceTypeIds(\patest\ArrayType\ArrayOfguid $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get RankWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRankWeight()
    {
        return isset($this->RankWeight) ? $this->RankWeight : null;
    }
    /**
     * Set RankWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rankWeight
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setRankWeight($rankWeight = null)
    {
        // validation for constraint: int
        if (!is_null($rankWeight) && !(is_int($rankWeight) || ctype_digit($rankWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rankWeight, true), gettype($rankWeight)), __LINE__);
        }
        if (is_null($rankWeight) || (is_array($rankWeight) && empty($rankWeight))) {
            unset($this->RankWeight);
        } else {
            $this->RankWeight = $rankWeight;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ShowTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTypeId()
    {
        return isset($this->ShowTypeId) ? $this->ShowTypeId : null;
    }
    /**
     * Set ShowTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTypeId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        if (is_null($showTypeId) || (is_array($showTypeId) && empty($showTypeId))) {
            unset($this->ShowTypeId);
        } else {
            $this->ShowTypeId = $showTypeId;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get TestClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestClientTypeId()
    {
        return isset($this->TestClientTypeId) ? $this->TestClientTypeId : null;
    }
    /**
     * Set TestClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testClientTypeId
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setTestClientTypeId($testClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($testClientTypeId) && !is_string($testClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testClientTypeId, true), gettype($testClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($testClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $testClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($testClientTypeId, true)), __LINE__);
        }
        if (is_null($testClientTypeId) || (is_array($testClientTypeId) && empty($testClientTypeId))) {
            unset($this->TestClientTypeId);
        } else {
            $this->TestClientTypeId = $testClientTypeId;
        }
        return $this;
    }
    /**
     * Get VisibilityStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelativeTime|null
     */
    public function getVisibilityStart()
    {
        return isset($this->VisibilityStart) ? $this->VisibilityStart : null;
    }
    /**
     * Set VisibilityStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelativeTime $visibilityStart
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setVisibilityStart(\patest\StructType\RelativeTime $visibilityStart = null)
    {
        if (is_null($visibilityStart) || (is_array($visibilityStart) && empty($visibilityStart))) {
            unset($this->VisibilityStart);
        } else {
            $this->VisibilityStart = $visibilityStart;
        }
        return $this;
    }
    /**
     * Get WrongCardMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWrongCardMessage()
    {
        return isset($this->WrongCardMessage) ? $this->WrongCardMessage : null;
    }
    /**
     * Set WrongCardMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wrongCardMessage
     * @return \patest\StructType\PresaleDescriptor
     */
    public function setWrongCardMessage($wrongCardMessage = null)
    {
        // validation for constraint: string
        if (!is_null($wrongCardMessage) && !is_string($wrongCardMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wrongCardMessage, true), gettype($wrongCardMessage)), __LINE__);
        }
        if (is_null($wrongCardMessage) || (is_array($wrongCardMessage) && empty($wrongCardMessage))) {
            unset($this->WrongCardMessage);
        } else {
            $this->WrongCardMessage = $wrongCardMessage;
        }
        return $this;
    }
}
