<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareSeriesAvailabilityFilterForCouponRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareSeriesAvailabilityFilterForCouponRequest
 * @subpackage Structs
 */
class PrepareSeriesAvailabilityFilterForCouponRequest extends AbstractStructBase
{
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The PriceLevelsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterList
     */
    public $PriceLevelsFilter;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PriceTypeIds;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for PrepareSeriesAvailabilityFilterForCouponRequest
     * @uses PrepareSeriesAvailabilityFilterForCouponRequest::setCouponIdentity()
     * @uses PrepareSeriesAvailabilityFilterForCouponRequest::setPriceLevelsFilter()
     * @uses PrepareSeriesAvailabilityFilterForCouponRequest::setPriceTypeIds()
     * @uses PrepareSeriesAvailabilityFilterForCouponRequest::setSeriesId()
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @param string $seriesId
     */
    public function __construct(\patest\StructType\CouponIdentity $couponIdentity = null, \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter = null, \patest\ArrayType\ArrayOfguid $priceTypeIds = null, $seriesId = null)
    {
        $this
            ->setCouponIdentity($couponIdentity)
            ->setPriceLevelsFilter($priceLevelsFilter)
            ->setPriceTypeIds($priceTypeIds)
            ->setSeriesId($seriesId);
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\PrepareSeriesAvailabilityFilterForCouponRequest
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get PriceLevelsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterList|null
     */
    public function getPriceLevelsFilter()
    {
        return isset($this->PriceLevelsFilter) ? $this->PriceLevelsFilter : null;
    }
    /**
     * Set PriceLevelsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter
     * @return \patest\StructType\PrepareSeriesAvailabilityFilterForCouponRequest
     */
    public function setPriceLevelsFilter(\patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter = null)
    {
        if (is_null($priceLevelsFilter) || (is_array($priceLevelsFilter) && empty($priceLevelsFilter))) {
            unset($this->PriceLevelsFilter);
        } else {
            $this->PriceLevelsFilter = $priceLevelsFilter;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @return \patest\StructType\PrepareSeriesAvailabilityFilterForCouponRequest
     */
    public function setPriceTypeIds(\patest\ArrayType\ArrayOfguid $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\PrepareSeriesAvailabilityFilterForCouponRequest
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
