<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareEventAvailabilityFilterForCouponRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareEventAvailabilityFilterForCouponRequest
 * @subpackage Structs
 */
class PrepareEventAvailabilityFilterForCouponRequest extends AbstractStructBase
{
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The PriceLevelsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterList
     */
    public $PriceLevelsFilter;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PriceTypeIds;
    /**
     * Constructor method for PrepareEventAvailabilityFilterForCouponRequest
     * @uses PrepareEventAvailabilityFilterForCouponRequest::setCouponIdentity()
     * @uses PrepareEventAvailabilityFilterForCouponRequest::setEventId()
     * @uses PrepareEventAvailabilityFilterForCouponRequest::setPriceLevelsFilter()
     * @uses PrepareEventAvailabilityFilterForCouponRequest::setPriceTypeIds()
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param string $eventId
     * @param \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     */
    public function __construct(\patest\StructType\CouponIdentity $couponIdentity = null, $eventId = null, \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter = null, \patest\ArrayType\ArrayOfguid $priceTypeIds = null)
    {
        $this
            ->setCouponIdentity($couponIdentity)
            ->setEventId($eventId)
            ->setPriceLevelsFilter($priceLevelsFilter)
            ->setPriceTypeIds($priceTypeIds);
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\PrepareEventAvailabilityFilterForCouponRequest
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\PrepareEventAvailabilityFilterForCouponRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get PriceLevelsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterList|null
     */
    public function getPriceLevelsFilter()
    {
        return isset($this->PriceLevelsFilter) ? $this->PriceLevelsFilter : null;
    }
    /**
     * Set PriceLevelsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter
     * @return \patest\StructType\PrepareEventAvailabilityFilterForCouponRequest
     */
    public function setPriceLevelsFilter(\patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter = null)
    {
        if (is_null($priceLevelsFilter) || (is_array($priceLevelsFilter) && empty($priceLevelsFilter))) {
            unset($this->PriceLevelsFilter);
        } else {
            $this->PriceLevelsFilter = $priceLevelsFilter;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @return \patest\StructType\PrepareEventAvailabilityFilterForCouponRequest
     */
    public function setPriceTypeIds(\patest\ArrayType\ArrayOfguid $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
}
