<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareAvailabilityFilterForHospitalityRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareAvailabilityFilterForHospitalityRequest
 * @subpackage Structs
 */
class PrepareAvailabilityFilterForHospitalityRequest extends AbstractStructBase
{
    /**
     * The HospitalityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HospitalityId;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * Constructor method for PrepareAvailabilityFilterForHospitalityRequest
     * @uses PrepareAvailabilityFilterForHospitalityRequest::setHospitalityId()
     * @uses PrepareAvailabilityFilterForHospitalityRequest::setSeatingPlanId()
     * @param string $hospitalityId
     * @param string $seatingPlanId
     */
    public function __construct($hospitalityId = null, $seatingPlanId = null)
    {
        $this
            ->setHospitalityId($hospitalityId)
            ->setSeatingPlanId($seatingPlanId);
    }
    /**
     * Get HospitalityId value
     * @return string|null
     */
    public function getHospitalityId()
    {
        return $this->HospitalityId;
    }
    /**
     * Set HospitalityId value
     * @param string $hospitalityId
     * @return \patest\StructType\PrepareAvailabilityFilterForHospitalityRequest
     */
    public function setHospitalityId($hospitalityId = null)
    {
        // validation for constraint: string
        if (!is_null($hospitalityId) && !is_string($hospitalityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hospitalityId, true), gettype($hospitalityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hospitalityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hospitalityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hospitalityId, true)), __LINE__);
        }
        $this->HospitalityId = $hospitalityId;
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return $this->SeatingPlanId;
    }
    /**
     * Set SeatingPlanId value
     * @param string $seatingPlanId
     * @return \patest\StructType\PrepareAvailabilityFilterForHospitalityRequest
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        $this->SeatingPlanId = $seatingPlanId;
        return $this;
    }
}
