<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareAvailabilityFilterForCouponResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareAvailabilityFilterForCouponResponse
 * @subpackage Structs
 */
class PrepareAvailabilityFilterForCouponResponse extends AbstractStructBase
{
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilter
     */
    public $Filter;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Token;
    /**
     * Constructor method for PrepareAvailabilityFilterForCouponResponse
     * @uses PrepareAvailabilityFilterForCouponResponse::setFilter()
     * @uses PrepareAvailabilityFilterForCouponResponse::setToken()
     * @param \patest\StructType\EffectiveAvailabilityFilter $filter
     * @param string $token
     */
    public function __construct(\patest\StructType\EffectiveAvailabilityFilter $filter = null, $token = null)
    {
        $this
            ->setFilter($filter)
            ->setToken($token);
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilter|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilter $filter
     * @return \patest\StructType\PrepareAvailabilityFilterForCouponResponse
     */
    public function setFilter(\patest\StructType\EffectiveAvailabilityFilter $filter = null)
    {
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \patest\StructType\PrepareAvailabilityFilterForCouponResponse
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($token) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($token, true)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
}
