<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PopulateSubscriptionTicketsListForActionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PopulateSubscriptionTicketsListForActionRequest
 * @subpackage Structs
 */
class PopulateSubscriptionTicketsListForActionRequest extends ExtensibleDataContract
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ChangeSubsTicketAppliedPriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ChangeSubsTicketAppliedPriceListType
     */
    public $ChangeSubsTicketAppliedPriceList;
    /**
     * The TicketIdentifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketIdentifier
     */
    public $TicketIdentifiers;
    /**
     * Constructor method for PopulateSubscriptionTicketsListForActionRequest
     * @uses PopulateSubscriptionTicketsListForActionRequest::setAction()
     * @uses PopulateSubscriptionTicketsListForActionRequest::setChangeSubsTicketAppliedPriceList()
     * @uses PopulateSubscriptionTicketsListForActionRequest::setTicketIdentifiers()
     * @param string $action
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @param \patest\ArrayType\ArrayOfTicketIdentifier $ticketIdentifiers
     */
    public function __construct($action = null, \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null, \patest\ArrayType\ArrayOfTicketIdentifier $ticketIdentifiers = null)
    {
        $this
            ->setAction($action)
            ->setChangeSubsTicketAppliedPriceList($changeSubsTicketAppliedPriceList)
            ->setTicketIdentifiers($ticketIdentifiers);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionTicketAction::valueIsValid()
     * @uses \patest\EnumType\SubscriptionTicketAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\PopulateSubscriptionTicketsListForActionRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionTicketAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionTicketAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriptionTicketAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ChangeSubsTicketAppliedPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ChangeSubsTicketAppliedPriceListType|null
     */
    public function getChangeSubsTicketAppliedPriceList()
    {
        return isset($this->ChangeSubsTicketAppliedPriceList) ? $this->ChangeSubsTicketAppliedPriceList : null;
    }
    /**
     * Set ChangeSubsTicketAppliedPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @return \patest\StructType\PopulateSubscriptionTicketsListForActionRequest
     */
    public function setChangeSubsTicketAppliedPriceList(\patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null)
    {
        if (is_null($changeSubsTicketAppliedPriceList) || (is_array($changeSubsTicketAppliedPriceList) && empty($changeSubsTicketAppliedPriceList))) {
            unset($this->ChangeSubsTicketAppliedPriceList);
        } else {
            $this->ChangeSubsTicketAppliedPriceList = $changeSubsTicketAppliedPriceList;
        }
        return $this;
    }
    /**
     * Get TicketIdentifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketIdentifier|null
     */
    public function getTicketIdentifiers()
    {
        return isset($this->TicketIdentifiers) ? $this->TicketIdentifiers : null;
    }
    /**
     * Set TicketIdentifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketIdentifier $ticketIdentifiers
     * @return \patest\StructType\PopulateSubscriptionTicketsListForActionRequest
     */
    public function setTicketIdentifiers(\patest\ArrayType\ArrayOfTicketIdentifier $ticketIdentifiers = null)
    {
        if (is_null($ticketIdentifiers) || (is_array($ticketIdentifiers) && empty($ticketIdentifiers))) {
            unset($this->TicketIdentifiers);
        } else {
            $this->TicketIdentifiers = $ticketIdentifiers;
        }
        return $this;
    }
}
