<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonName StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PersonName
 * @subpackage Structs
 */
class PersonName extends ManagedEntityBase
{
    /**
     * The First
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $First;
    /**
     * The FullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullName;
    /**
     * The IssuerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IssuerCompanyId;
    /**
     * The Last
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Last;
    /**
     * The Middle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Middle;
    /**
     * The Prefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prefix;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * Constructor method for PersonName
     * @uses PersonName::setFirst()
     * @uses PersonName::setFullName()
     * @uses PersonName::setIssuerCompanyId()
     * @uses PersonName::setLast()
     * @uses PersonName::setMiddle()
     * @uses PersonName::setPrefix()
     * @uses PersonName::setSuffix()
     * @param string $first
     * @param string $fullName
     * @param int $issuerCompanyId
     * @param string $last
     * @param string $middle
     * @param string $prefix
     * @param string $suffix
     */
    public function __construct($first = null, $fullName = null, $issuerCompanyId = null, $last = null, $middle = null, $prefix = null, $suffix = null)
    {
        $this
            ->setFirst($first)
            ->setFullName($fullName)
            ->setIssuerCompanyId($issuerCompanyId)
            ->setLast($last)
            ->setMiddle($middle)
            ->setPrefix($prefix)
            ->setSuffix($suffix);
    }
    /**
     * Get First value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirst()
    {
        return isset($this->First) ? $this->First : null;
    }
    /**
     * Set First value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $first
     * @return \patest\StructType\PersonName
     */
    public function setFirst($first = null)
    {
        // validation for constraint: string
        if (!is_null($first) && !is_string($first)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first, true), gettype($first)), __LINE__);
        }
        if (is_null($first) || (is_array($first) && empty($first))) {
            unset($this->First);
        } else {
            $this->First = $first;
        }
        return $this;
    }
    /**
     * Get FullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullName()
    {
        return isset($this->FullName) ? $this->FullName : null;
    }
    /**
     * Set FullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullName
     * @return \patest\StructType\PersonName
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        if (is_null($fullName) || (is_array($fullName) && empty($fullName))) {
            unset($this->FullName);
        } else {
            $this->FullName = $fullName;
        }
        return $this;
    }
    /**
     * Get IssuerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerCompanyId()
    {
        return isset($this->IssuerCompanyId) ? $this->IssuerCompanyId : null;
    }
    /**
     * Set IssuerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerCompanyId
     * @return \patest\StructType\PersonName
     */
    public function setIssuerCompanyId($issuerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerCompanyId) && !(is_int($issuerCompanyId) || ctype_digit($issuerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerCompanyId, true), gettype($issuerCompanyId)), __LINE__);
        }
        if (is_null($issuerCompanyId) || (is_array($issuerCompanyId) && empty($issuerCompanyId))) {
            unset($this->IssuerCompanyId);
        } else {
            $this->IssuerCompanyId = $issuerCompanyId;
        }
        return $this;
    }
    /**
     * Get Last value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLast()
    {
        return isset($this->Last) ? $this->Last : null;
    }
    /**
     * Set Last value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $last
     * @return \patest\StructType\PersonName
     */
    public function setLast($last = null)
    {
        // validation for constraint: string
        if (!is_null($last) && !is_string($last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last, true), gettype($last)), __LINE__);
        }
        if (is_null($last) || (is_array($last) && empty($last))) {
            unset($this->Last);
        } else {
            $this->Last = $last;
        }
        return $this;
    }
    /**
     * Get Middle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddle()
    {
        return isset($this->Middle) ? $this->Middle : null;
    }
    /**
     * Set Middle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middle
     * @return \patest\StructType\PersonName
     */
    public function setMiddle($middle = null)
    {
        // validation for constraint: string
        if (!is_null($middle) && !is_string($middle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middle, true), gettype($middle)), __LINE__);
        }
        if (is_null($middle) || (is_array($middle) && empty($middle))) {
            unset($this->Middle);
        } else {
            $this->Middle = $middle;
        }
        return $this;
    }
    /**
     * Get Prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefix()
    {
        return isset($this->Prefix) ? $this->Prefix : null;
    }
    /**
     * Set Prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefix
     * @return \patest\StructType\PersonName
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        if (is_null($prefix) || (is_array($prefix) && empty($prefix))) {
            unset($this->Prefix);
        } else {
            $this->Prefix = $prefix;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \patest\StructType\PersonName
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
}
