<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerformProcessControlActionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PerformProcessControlActionRequest
 * @subpackage Structs
 */
class PerformProcessControlActionRequest extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProcessFilter
     */
    public $Filter;
    /**
     * The NumberOFWaits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOFWaits;
    /**
     * The WaitIntervalTimeInSeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WaitIntervalTimeInSeconds;
    /**
     * The WaitUntilCompletion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $WaitUntilCompletion;
    /**
     * The WaitBeforePollingInSeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WaitBeforePollingInSeconds;
    /**
     * Constructor method for PerformProcessControlActionRequest
     * @uses PerformProcessControlActionRequest::setAction()
     * @uses PerformProcessControlActionRequest::setFilter()
     * @uses PerformProcessControlActionRequest::setNumberOFWaits()
     * @uses PerformProcessControlActionRequest::setWaitIntervalTimeInSeconds()
     * @uses PerformProcessControlActionRequest::setWaitUntilCompletion()
     * @uses PerformProcessControlActionRequest::setWaitBeforePollingInSeconds()
     * @param string $action
     * @param \patest\StructType\ProcessFilter $filter
     * @param int $numberOFWaits
     * @param int $waitIntervalTimeInSeconds
     * @param bool $waitUntilCompletion
     * @param int $waitBeforePollingInSeconds
     */
    public function __construct($action = null, \patest\StructType\ProcessFilter $filter = null, $numberOFWaits = null, $waitIntervalTimeInSeconds = null, $waitUntilCompletion = null, $waitBeforePollingInSeconds = null)
    {
        $this
            ->setAction($action)
            ->setFilter($filter)
            ->setNumberOFWaits($numberOFWaits)
            ->setWaitIntervalTimeInSeconds($waitIntervalTimeInSeconds)
            ->setWaitUntilCompletion($waitUntilCompletion)
            ->setWaitBeforePollingInSeconds($waitBeforePollingInSeconds);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \patest\EnumType\ProcessControlAction::valueIsValid()
     * @uses \patest\EnumType\ProcessControlAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\PerformProcessControlActionRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProcessControlAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProcessControlAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\ProcessControlAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProcessFilter|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProcessFilter $filter
     * @return \patest\StructType\PerformProcessControlActionRequest
     */
    public function setFilter(\patest\StructType\ProcessFilter $filter = null)
    {
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get NumberOFWaits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOFWaits()
    {
        return isset($this->NumberOFWaits) ? $this->NumberOFWaits : null;
    }
    /**
     * Set NumberOFWaits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOFWaits
     * @return \patest\StructType\PerformProcessControlActionRequest
     */
    public function setNumberOFWaits($numberOFWaits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOFWaits) && !(is_int($numberOFWaits) || ctype_digit($numberOFWaits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOFWaits, true), gettype($numberOFWaits)), __LINE__);
        }
        if (is_null($numberOFWaits) || (is_array($numberOFWaits) && empty($numberOFWaits))) {
            unset($this->NumberOFWaits);
        } else {
            $this->NumberOFWaits = $numberOFWaits;
        }
        return $this;
    }
    /**
     * Get WaitIntervalTimeInSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWaitIntervalTimeInSeconds()
    {
        return isset($this->WaitIntervalTimeInSeconds) ? $this->WaitIntervalTimeInSeconds : null;
    }
    /**
     * Set WaitIntervalTimeInSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $waitIntervalTimeInSeconds
     * @return \patest\StructType\PerformProcessControlActionRequest
     */
    public function setWaitIntervalTimeInSeconds($waitIntervalTimeInSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($waitIntervalTimeInSeconds) && !(is_int($waitIntervalTimeInSeconds) || ctype_digit($waitIntervalTimeInSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitIntervalTimeInSeconds, true), gettype($waitIntervalTimeInSeconds)), __LINE__);
        }
        if (is_null($waitIntervalTimeInSeconds) || (is_array($waitIntervalTimeInSeconds) && empty($waitIntervalTimeInSeconds))) {
            unset($this->WaitIntervalTimeInSeconds);
        } else {
            $this->WaitIntervalTimeInSeconds = $waitIntervalTimeInSeconds;
        }
        return $this;
    }
    /**
     * Get WaitUntilCompletion value
     * @return bool|null
     */
    public function getWaitUntilCompletion()
    {
        return $this->WaitUntilCompletion;
    }
    /**
     * Set WaitUntilCompletion value
     * @param bool $waitUntilCompletion
     * @return \patest\StructType\PerformProcessControlActionRequest
     */
    public function setWaitUntilCompletion($waitUntilCompletion = null)
    {
        // validation for constraint: boolean
        if (!is_null($waitUntilCompletion) && !is_bool($waitUntilCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waitUntilCompletion, true), gettype($waitUntilCompletion)), __LINE__);
        }
        $this->WaitUntilCompletion = $waitUntilCompletion;
        return $this;
    }
    /**
     * Get WaitBeforePollingInSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWaitBeforePollingInSeconds()
    {
        return isset($this->WaitBeforePollingInSeconds) ? $this->WaitBeforePollingInSeconds : null;
    }
    /**
     * Set WaitBeforePollingInSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $waitBeforePollingInSeconds
     * @return \patest\StructType\PerformProcessControlActionRequest
     */
    public function setWaitBeforePollingInSeconds($waitBeforePollingInSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($waitBeforePollingInSeconds) && !(is_int($waitBeforePollingInSeconds) || ctype_digit($waitBeforePollingInSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitBeforePollingInSeconds, true), gettype($waitBeforePollingInSeconds)), __LINE__);
        }
        if (is_null($waitBeforePollingInSeconds) || (is_array($waitBeforePollingInSeconds) && empty($waitBeforePollingInSeconds))) {
            unset($this->WaitBeforePollingInSeconds);
        } else {
            $this->WaitBeforePollingInSeconds = $waitBeforePollingInSeconds;
        }
        return $this;
    }
}
