<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.ServerClientCreditCardPaymentToken StructType
 * @subpackage Structs
 */
class Payment_ServerClientCreditCardPaymentToken extends Payment_ClientCreditCardToken
{
    /**
     * The ServerTokenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServerTokenId;
    /**
     * Constructor method for Payment.ServerClientCreditCardPaymentToken
     * @uses Payment_ServerClientCreditCardPaymentToken::setServerTokenId()
     * @param string $serverTokenId
     */
    public function __construct($serverTokenId = null)
    {
        $this
            ->setServerTokenId($serverTokenId);
    }
    /**
     * Get ServerTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServerTokenId()
    {
        return isset($this->ServerTokenId) ? $this->ServerTokenId : null;
    }
    /**
     * Set ServerTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serverTokenId
     * @return \patest\StructType\Payment_ServerClientCreditCardPaymentToken
     */
    public function setServerTokenId($serverTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($serverTokenId) && !is_string($serverTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverTokenId, true), gettype($serverTokenId)), __LINE__);
        }
        if (is_null($serverTokenId) || (is_array($serverTokenId) && empty($serverTokenId))) {
            unset($this->ServerTokenId);
        } else {
            $this->ServerTokenId = $serverTokenId;
        }
        return $this;
    }
}
