<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Printing.LoyaltyPointsDetails StructType
 * @subpackage Structs
 */
class Payment_Printing_LoyaltyPointsDetails extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CompanyAmountEquivalent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmountEquivalent;
    /**
     * The PointsExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PointsExchange;
    /**
     * The RedeemedPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RedeemedPoints;
    /**
     * Constructor method for Payment.Printing.LoyaltyPointsDetails
     * @uses Payment_Printing_LoyaltyPointsDetails::setClientId()
     * @uses Payment_Printing_LoyaltyPointsDetails::setCompanyAmountEquivalent()
     * @uses Payment_Printing_LoyaltyPointsDetails::setPointsExchange()
     * @uses Payment_Printing_LoyaltyPointsDetails::setRedeemedPoints()
     * @param string $clientId
     * @param \patest\StructType\Money $companyAmountEquivalent
     * @param float $pointsExchange
     * @param float $redeemedPoints
     */
    public function __construct($clientId = null, \patest\StructType\Money $companyAmountEquivalent = null, $pointsExchange = null, $redeemedPoints = null)
    {
        $this
            ->setClientId($clientId)
            ->setCompanyAmountEquivalent($companyAmountEquivalent)
            ->setPointsExchange($pointsExchange)
            ->setRedeemedPoints($redeemedPoints);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_Printing_LoyaltyPointsDetails
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CompanyAmountEquivalent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmountEquivalent()
    {
        return isset($this->CompanyAmountEquivalent) ? $this->CompanyAmountEquivalent : null;
    }
    /**
     * Set CompanyAmountEquivalent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmountEquivalent
     * @return \patest\StructType\Payment_Printing_LoyaltyPointsDetails
     */
    public function setCompanyAmountEquivalent(\patest\StructType\Money $companyAmountEquivalent = null)
    {
        if (is_null($companyAmountEquivalent) || (is_array($companyAmountEquivalent) && empty($companyAmountEquivalent))) {
            unset($this->CompanyAmountEquivalent);
        } else {
            $this->CompanyAmountEquivalent = $companyAmountEquivalent;
        }
        return $this;
    }
    /**
     * Get PointsExchange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPointsExchange()
    {
        return isset($this->PointsExchange) ? $this->PointsExchange : null;
    }
    /**
     * Set PointsExchange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pointsExchange
     * @return \patest\StructType\Payment_Printing_LoyaltyPointsDetails
     */
    public function setPointsExchange($pointsExchange = null)
    {
        // validation for constraint: float
        if (!is_null($pointsExchange) && !(is_float($pointsExchange) || is_numeric($pointsExchange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointsExchange, true), gettype($pointsExchange)), __LINE__);
        }
        if (is_null($pointsExchange) || (is_array($pointsExchange) && empty($pointsExchange))) {
            unset($this->PointsExchange);
        } else {
            $this->PointsExchange = $pointsExchange;
        }
        return $this;
    }
    /**
     * Get RedeemedPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRedeemedPoints()
    {
        return isset($this->RedeemedPoints) ? $this->RedeemedPoints : null;
    }
    /**
     * Set RedeemedPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $redeemedPoints
     * @return \patest\StructType\Payment_Printing_LoyaltyPointsDetails
     */
    public function setRedeemedPoints($redeemedPoints = null)
    {
        // validation for constraint: float
        if (!is_null($redeemedPoints) && !(is_float($redeemedPoints) || is_numeric($redeemedPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redeemedPoints, true), gettype($redeemedPoints)), __LINE__);
        }
        if (is_null($redeemedPoints) || (is_array($redeemedPoints) && empty($redeemedPoints))) {
            unset($this->RedeemedPoints);
        } else {
            $this->RedeemedPoints = $redeemedPoints;
        }
        return $this;
    }
}
