<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Printing.DirectDebitPayment StructType
 * @subpackage Structs
 */
class Payment_Printing_DirectDebitPayment extends AnyEntity
{
    /**
     * The FirstPaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FirstPaymentAmount;
    /**
     * The InstallmentsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InstallmentsNumber;
    /**
     * The Mandate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public $Mandate;
    /**
     * The NextPaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $NextPaymentAmount;
    /**
     * Constructor method for Payment.Printing.DirectDebitPayment
     * @uses Payment_Printing_DirectDebitPayment::setFirstPaymentAmount()
     * @uses Payment_Printing_DirectDebitPayment::setInstallmentsNumber()
     * @uses Payment_Printing_DirectDebitPayment::setMandate()
     * @uses Payment_Printing_DirectDebitPayment::setNextPaymentAmount()
     * @param \patest\StructType\Money $firstPaymentAmount
     * @param int $installmentsNumber
     * @param \patest\StructType\Payment_Printing_DirectDebitMandate $mandate
     * @param \patest\StructType\Money $nextPaymentAmount
     */
    public function __construct(\patest\StructType\Money $firstPaymentAmount = null, $installmentsNumber = null, \patest\StructType\Payment_Printing_DirectDebitMandate $mandate = null, \patest\StructType\Money $nextPaymentAmount = null)
    {
        $this
            ->setFirstPaymentAmount($firstPaymentAmount)
            ->setInstallmentsNumber($installmentsNumber)
            ->setMandate($mandate)
            ->setNextPaymentAmount($nextPaymentAmount);
    }
    /**
     * Get FirstPaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFirstPaymentAmount()
    {
        return isset($this->FirstPaymentAmount) ? $this->FirstPaymentAmount : null;
    }
    /**
     * Set FirstPaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $firstPaymentAmount
     * @return \patest\StructType\Payment_Printing_DirectDebitPayment
     */
    public function setFirstPaymentAmount(\patest\StructType\Money $firstPaymentAmount = null)
    {
        if (is_null($firstPaymentAmount) || (is_array($firstPaymentAmount) && empty($firstPaymentAmount))) {
            unset($this->FirstPaymentAmount);
        } else {
            $this->FirstPaymentAmount = $firstPaymentAmount;
        }
        return $this;
    }
    /**
     * Get InstallmentsNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallmentsNumber()
    {
        return isset($this->InstallmentsNumber) ? $this->InstallmentsNumber : null;
    }
    /**
     * Set InstallmentsNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installmentsNumber
     * @return \patest\StructType\Payment_Printing_DirectDebitPayment
     */
    public function setInstallmentsNumber($installmentsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($installmentsNumber) && !(is_int($installmentsNumber) || ctype_digit($installmentsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installmentsNumber, true), gettype($installmentsNumber)), __LINE__);
        }
        if (is_null($installmentsNumber) || (is_array($installmentsNumber) && empty($installmentsNumber))) {
            unset($this->InstallmentsNumber);
        } else {
            $this->InstallmentsNumber = $installmentsNumber;
        }
        return $this;
    }
    /**
     * Get Mandate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate|null
     */
    public function getMandate()
    {
        return isset($this->Mandate) ? $this->Mandate : null;
    }
    /**
     * Set Mandate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Printing_DirectDebitMandate $mandate
     * @return \patest\StructType\Payment_Printing_DirectDebitPayment
     */
    public function setMandate(\patest\StructType\Payment_Printing_DirectDebitMandate $mandate = null)
    {
        if (is_null($mandate) || (is_array($mandate) && empty($mandate))) {
            unset($this->Mandate);
        } else {
            $this->Mandate = $mandate;
        }
        return $this;
    }
    /**
     * Get NextPaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getNextPaymentAmount()
    {
        return isset($this->NextPaymentAmount) ? $this->NextPaymentAmount : null;
    }
    /**
     * Set NextPaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $nextPaymentAmount
     * @return \patest\StructType\Payment_Printing_DirectDebitPayment
     */
    public function setNextPaymentAmount(\patest\StructType\Money $nextPaymentAmount = null)
    {
        if (is_null($nextPaymentAmount) || (is_array($nextPaymentAmount) && empty($nextPaymentAmount))) {
            unset($this->NextPaymentAmount);
        } else {
            $this->NextPaymentAmount = $nextPaymentAmount;
        }
        return $this;
    }
}
