<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PointsGrantingDetailsWithBankedDate StructType
 * @subpackage Structs
 */
class Payment_PointsGrantingDetailsWithBankedDate extends Payment_LoyaltyPointsGrantingDetails
{
    /**
     * The BankedFromDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankedFromDate;
    /**
     * The Mode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mode;
    /**
     * Constructor method for Payment.PointsGrantingDetailsWithBankedDate
     * @uses Payment_PointsGrantingDetailsWithBankedDate::setBankedFromDate()
     * @uses Payment_PointsGrantingDetailsWithBankedDate::setMode()
     * @param string $bankedFromDate
     * @param string $mode
     */
    public function __construct($bankedFromDate = null, $mode = null)
    {
        $this
            ->setBankedFromDate($bankedFromDate)
            ->setMode($mode);
    }
    /**
     * Get BankedFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankedFromDate()
    {
        return isset($this->BankedFromDate) ? $this->BankedFromDate : null;
    }
    /**
     * Set BankedFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankedFromDate
     * @return \patest\StructType\Payment_PointsGrantingDetailsWithBankedDate
     */
    public function setBankedFromDate($bankedFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($bankedFromDate) && !is_string($bankedFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankedFromDate, true), gettype($bankedFromDate)), __LINE__);
        }
        if (is_null($bankedFromDate) || (is_array($bankedFromDate) && empty($bankedFromDate))) {
            unset($this->BankedFromDate);
        } else {
            $this->BankedFromDate = $bankedFromDate;
        }
        return $this;
    }
    /**
     * Get Mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->Mode) ? $this->Mode : null;
    }
    /**
     * Set Mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LoyaltyPointsMode::valueIsValid()
     * @uses \patest\EnumType\LoyaltyPointsMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \patest\StructType\Payment_PointsGrantingDetailsWithBankedDate
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LoyaltyPointsMode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LoyaltyPointsMode', is_array($mode) ? implode(', ', $mode) : var_export($mode, true), implode(', ', \patest\EnumType\LoyaltyPointsMode::getValidValues())), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->Mode);
        } else {
            $this->Mode = $mode;
        }
        return $this;
    }
}
