<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentSessionFilter StructType
 * @subpackage Structs
 */
class Payment_PaymentSessionFilter extends FilterEntity
{
    /**
     * The ClientCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCrmId;
    /**
     * The ClientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientEmail;
    /**
     * The ClientFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientFirstName;
    /**
     * The ClientLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientLastName;
    /**
     * The ClientPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPhone;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IsIncludeAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncludeAccepted;
    /**
     * The IsIncludeCancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncludeCancelled;
    /**
     * The IsIncludeDeclined
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncludeDeclined;
    /**
     * The IsIncludeErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncludeErrors;
    /**
     * The IsIncludeNotCompleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncludeNotCompleted;
    /**
     * The LocalRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalRefNumber;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The ProblematicType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProblematicType;
    /**
     * The ResultCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardSuffix;
    /**
     * The ResultConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultConfirmationNumber;
    /**
     * The ResultGatewayTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultGatewayTransactionId;
    /**
     * The ResultRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultRefNumber;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Payment.PaymentSessionFilter
     * @uses Payment_PaymentSessionFilter::setClientCrmId()
     * @uses Payment_PaymentSessionFilter::setClientEmail()
     * @uses Payment_PaymentSessionFilter::setClientFirstName()
     * @uses Payment_PaymentSessionFilter::setClientLastName()
     * @uses Payment_PaymentSessionFilter::setClientPhone()
     * @uses Payment_PaymentSessionFilter::setFromDate()
     * @uses Payment_PaymentSessionFilter::setIsIncludeAccepted()
     * @uses Payment_PaymentSessionFilter::setIsIncludeCancelled()
     * @uses Payment_PaymentSessionFilter::setIsIncludeDeclined()
     * @uses Payment_PaymentSessionFilter::setIsIncludeErrors()
     * @uses Payment_PaymentSessionFilter::setIsIncludeNotCompleted()
     * @uses Payment_PaymentSessionFilter::setLocalRefNumber()
     * @uses Payment_PaymentSessionFilter::setOperation()
     * @uses Payment_PaymentSessionFilter::setPaymentMethodId()
     * @uses Payment_PaymentSessionFilter::setPaymentMethodType()
     * @uses Payment_PaymentSessionFilter::setProblematicType()
     * @uses Payment_PaymentSessionFilter::setResultCardSuffix()
     * @uses Payment_PaymentSessionFilter::setResultConfirmationNumber()
     * @uses Payment_PaymentSessionFilter::setResultGatewayTransactionId()
     * @uses Payment_PaymentSessionFilter::setResultRefNumber()
     * @uses Payment_PaymentSessionFilter::setToDate()
     * @uses Payment_PaymentSessionFilter::setTransactionNumber()
     * @param string $clientCrmId
     * @param string $clientEmail
     * @param string $clientFirstName
     * @param string $clientLastName
     * @param string $clientPhone
     * @param string $fromDate
     * @param bool $isIncludeAccepted
     * @param bool $isIncludeCancelled
     * @param bool $isIncludeDeclined
     * @param bool $isIncludeErrors
     * @param bool $isIncludeNotCompleted
     * @param int $localRefNumber
     * @param string $operation
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param string $problematicType
     * @param string $resultCardSuffix
     * @param string $resultConfirmationNumber
     * @param string $resultGatewayTransactionId
     * @param string $resultRefNumber
     * @param string $toDate
     * @param int $transactionNumber
     */
    public function __construct($clientCrmId = null, $clientEmail = null, $clientFirstName = null, $clientLastName = null, $clientPhone = null, $fromDate = null, $isIncludeAccepted = null, $isIncludeCancelled = null, $isIncludeDeclined = null, $isIncludeErrors = null, $isIncludeNotCompleted = null, $localRefNumber = null, $operation = null, $paymentMethodId = null, $paymentMethodType = null, $problematicType = null, $resultCardSuffix = null, $resultConfirmationNumber = null, $resultGatewayTransactionId = null, $resultRefNumber = null, $toDate = null, $transactionNumber = null)
    {
        $this
            ->setClientCrmId($clientCrmId)
            ->setClientEmail($clientEmail)
            ->setClientFirstName($clientFirstName)
            ->setClientLastName($clientLastName)
            ->setClientPhone($clientPhone)
            ->setFromDate($fromDate)
            ->setIsIncludeAccepted($isIncludeAccepted)
            ->setIsIncludeCancelled($isIncludeCancelled)
            ->setIsIncludeDeclined($isIncludeDeclined)
            ->setIsIncludeErrors($isIncludeErrors)
            ->setIsIncludeNotCompleted($isIncludeNotCompleted)
            ->setLocalRefNumber($localRefNumber)
            ->setOperation($operation)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setProblematicType($problematicType)
            ->setResultCardSuffix($resultCardSuffix)
            ->setResultConfirmationNumber($resultConfirmationNumber)
            ->setResultGatewayTransactionId($resultGatewayTransactionId)
            ->setResultRefNumber($resultRefNumber)
            ->setToDate($toDate)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClientCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCrmId()
    {
        return isset($this->ClientCrmId) ? $this->ClientCrmId : null;
    }
    /**
     * Set ClientCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCrmId
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setClientCrmId($clientCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($clientCrmId) && !is_string($clientCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCrmId, true), gettype($clientCrmId)), __LINE__);
        }
        if (is_null($clientCrmId) || (is_array($clientCrmId) && empty($clientCrmId))) {
            unset($this->ClientCrmId);
        } else {
            $this->ClientCrmId = $clientCrmId;
        }
        return $this;
    }
    /**
     * Get ClientEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEmail()
    {
        return isset($this->ClientEmail) ? $this->ClientEmail : null;
    }
    /**
     * Set ClientEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEmail
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setClientEmail($clientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($clientEmail) && !is_string($clientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEmail, true), gettype($clientEmail)), __LINE__);
        }
        if (is_null($clientEmail) || (is_array($clientEmail) && empty($clientEmail))) {
            unset($this->ClientEmail);
        } else {
            $this->ClientEmail = $clientEmail;
        }
        return $this;
    }
    /**
     * Get ClientFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientFirstName()
    {
        return isset($this->ClientFirstName) ? $this->ClientFirstName : null;
    }
    /**
     * Set ClientFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientFirstName
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setClientFirstName($clientFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($clientFirstName) && !is_string($clientFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientFirstName, true), gettype($clientFirstName)), __LINE__);
        }
        if (is_null($clientFirstName) || (is_array($clientFirstName) && empty($clientFirstName))) {
            unset($this->ClientFirstName);
        } else {
            $this->ClientFirstName = $clientFirstName;
        }
        return $this;
    }
    /**
     * Get ClientLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientLastName()
    {
        return isset($this->ClientLastName) ? $this->ClientLastName : null;
    }
    /**
     * Set ClientLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientLastName
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setClientLastName($clientLastName = null)
    {
        // validation for constraint: string
        if (!is_null($clientLastName) && !is_string($clientLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLastName, true), gettype($clientLastName)), __LINE__);
        }
        if (is_null($clientLastName) || (is_array($clientLastName) && empty($clientLastName))) {
            unset($this->ClientLastName);
        } else {
            $this->ClientLastName = $clientLastName;
        }
        return $this;
    }
    /**
     * Get ClientPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPhone()
    {
        return isset($this->ClientPhone) ? $this->ClientPhone : null;
    }
    /**
     * Set ClientPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientPhone
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setClientPhone($clientPhone = null)
    {
        // validation for constraint: string
        if (!is_null($clientPhone) && !is_string($clientPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientPhone, true), gettype($clientPhone)), __LINE__);
        }
        if (is_null($clientPhone) || (is_array($clientPhone) && empty($clientPhone))) {
            unset($this->ClientPhone);
        } else {
            $this->ClientPhone = $clientPhone;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IsIncludeAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncludeAccepted()
    {
        return isset($this->IsIncludeAccepted) ? $this->IsIncludeAccepted : null;
    }
    /**
     * Set IsIncludeAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncludeAccepted
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setIsIncludeAccepted($isIncludeAccepted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeAccepted) && !is_bool($isIncludeAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeAccepted, true), gettype($isIncludeAccepted)), __LINE__);
        }
        if (is_null($isIncludeAccepted) || (is_array($isIncludeAccepted) && empty($isIncludeAccepted))) {
            unset($this->IsIncludeAccepted);
        } else {
            $this->IsIncludeAccepted = $isIncludeAccepted;
        }
        return $this;
    }
    /**
     * Get IsIncludeCancelled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncludeCancelled()
    {
        return isset($this->IsIncludeCancelled) ? $this->IsIncludeCancelled : null;
    }
    /**
     * Set IsIncludeCancelled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncludeCancelled
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setIsIncludeCancelled($isIncludeCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeCancelled) && !is_bool($isIncludeCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeCancelled, true), gettype($isIncludeCancelled)), __LINE__);
        }
        if (is_null($isIncludeCancelled) || (is_array($isIncludeCancelled) && empty($isIncludeCancelled))) {
            unset($this->IsIncludeCancelled);
        } else {
            $this->IsIncludeCancelled = $isIncludeCancelled;
        }
        return $this;
    }
    /**
     * Get IsIncludeDeclined value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncludeDeclined()
    {
        return isset($this->IsIncludeDeclined) ? $this->IsIncludeDeclined : null;
    }
    /**
     * Set IsIncludeDeclined value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncludeDeclined
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setIsIncludeDeclined($isIncludeDeclined = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeDeclined) && !is_bool($isIncludeDeclined)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeDeclined, true), gettype($isIncludeDeclined)), __LINE__);
        }
        if (is_null($isIncludeDeclined) || (is_array($isIncludeDeclined) && empty($isIncludeDeclined))) {
            unset($this->IsIncludeDeclined);
        } else {
            $this->IsIncludeDeclined = $isIncludeDeclined;
        }
        return $this;
    }
    /**
     * Get IsIncludeErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncludeErrors()
    {
        return isset($this->IsIncludeErrors) ? $this->IsIncludeErrors : null;
    }
    /**
     * Set IsIncludeErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncludeErrors
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setIsIncludeErrors($isIncludeErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeErrors) && !is_bool($isIncludeErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeErrors, true), gettype($isIncludeErrors)), __LINE__);
        }
        if (is_null($isIncludeErrors) || (is_array($isIncludeErrors) && empty($isIncludeErrors))) {
            unset($this->IsIncludeErrors);
        } else {
            $this->IsIncludeErrors = $isIncludeErrors;
        }
        return $this;
    }
    /**
     * Get IsIncludeNotCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncludeNotCompleted()
    {
        return isset($this->IsIncludeNotCompleted) ? $this->IsIncludeNotCompleted : null;
    }
    /**
     * Set IsIncludeNotCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncludeNotCompleted
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setIsIncludeNotCompleted($isIncludeNotCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeNotCompleted) && !is_bool($isIncludeNotCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeNotCompleted, true), gettype($isIncludeNotCompleted)), __LINE__);
        }
        if (is_null($isIncludeNotCompleted) || (is_array($isIncludeNotCompleted) && empty($isIncludeNotCompleted))) {
            unset($this->IsIncludeNotCompleted);
        } else {
            $this->IsIncludeNotCompleted = $isIncludeNotCompleted;
        }
        return $this;
    }
    /**
     * Get LocalRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalRefNumber()
    {
        return isset($this->LocalRefNumber) ? $this->LocalRefNumber : null;
    }
    /**
     * Set LocalRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localRefNumber
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setLocalRefNumber($localRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($localRefNumber) && !(is_int($localRefNumber) || ctype_digit($localRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localRefNumber, true), gettype($localRefNumber)), __LINE__);
        }
        if (is_null($localRefNumber) || (is_array($localRefNumber) && empty($localRefNumber))) {
            unset($this->LocalRefNumber);
        } else {
            $this->LocalRefNumber = $localRefNumber;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentSessionOperationKind::valueIsValid()
     * @uses \patest\EnumType\PaymentSessionOperationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentSessionOperationKind::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentSessionOperationKind', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\PaymentSessionOperationKind::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get ProblematicType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProblematicType()
    {
        return isset($this->ProblematicType) ? $this->ProblematicType : null;
    }
    /**
     * Set ProblematicType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $problematicType
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setProblematicType($problematicType = null)
    {
        // validation for constraint: string
        if (!is_null($problematicType) && !is_string($problematicType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($problematicType, true), gettype($problematicType)), __LINE__);
        }
        if (is_null($problematicType) || (is_array($problematicType) && empty($problematicType))) {
            unset($this->ProblematicType);
        } else {
            $this->ProblematicType = $problematicType;
        }
        return $this;
    }
    /**
     * Get ResultCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardSuffix()
    {
        return isset($this->ResultCardSuffix) ? $this->ResultCardSuffix : null;
    }
    /**
     * Set ResultCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardSuffix
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setResultCardSuffix($resultCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardSuffix) && !is_string($resultCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardSuffix, true), gettype($resultCardSuffix)), __LINE__);
        }
        if (is_null($resultCardSuffix) || (is_array($resultCardSuffix) && empty($resultCardSuffix))) {
            unset($this->ResultCardSuffix);
        } else {
            $this->ResultCardSuffix = $resultCardSuffix;
        }
        return $this;
    }
    /**
     * Get ResultConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultConfirmationNumber()
    {
        return isset($this->ResultConfirmationNumber) ? $this->ResultConfirmationNumber : null;
    }
    /**
     * Set ResultConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultConfirmationNumber
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setResultConfirmationNumber($resultConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($resultConfirmationNumber) && !is_string($resultConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultConfirmationNumber, true), gettype($resultConfirmationNumber)), __LINE__);
        }
        if (is_null($resultConfirmationNumber) || (is_array($resultConfirmationNumber) && empty($resultConfirmationNumber))) {
            unset($this->ResultConfirmationNumber);
        } else {
            $this->ResultConfirmationNumber = $resultConfirmationNumber;
        }
        return $this;
    }
    /**
     * Get ResultGatewayTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultGatewayTransactionId()
    {
        return isset($this->ResultGatewayTransactionId) ? $this->ResultGatewayTransactionId : null;
    }
    /**
     * Set ResultGatewayTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultGatewayTransactionId
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setResultGatewayTransactionId($resultGatewayTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($resultGatewayTransactionId) && !is_string($resultGatewayTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultGatewayTransactionId, true), gettype($resultGatewayTransactionId)), __LINE__);
        }
        if (is_null($resultGatewayTransactionId) || (is_array($resultGatewayTransactionId) && empty($resultGatewayTransactionId))) {
            unset($this->ResultGatewayTransactionId);
        } else {
            $this->ResultGatewayTransactionId = $resultGatewayTransactionId;
        }
        return $this;
    }
    /**
     * Get ResultRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultRefNumber()
    {
        return isset($this->ResultRefNumber) ? $this->ResultRefNumber : null;
    }
    /**
     * Set ResultRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultRefNumber
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setResultRefNumber($resultRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($resultRefNumber) && !is_string($resultRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultRefNumber, true), gettype($resultRefNumber)), __LINE__);
        }
        if (is_null($resultRefNumber) || (is_array($resultRefNumber) && empty($resultRefNumber))) {
            unset($this->ResultRefNumber);
        } else {
            $this->ResultRefNumber = $resultRefNumber;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_PaymentSessionFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
