<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentPlanNextInstallmentDueDate StructType
 * @subpackage Structs
 */
class Payment_PaymentPlanNextInstallmentDueDate extends AnyEntity
{
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The NextInstallmentDueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextInstallmentDueDate;
    /**
     * The PaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentInstallmentsScheduleId;
    /**
     * Constructor method for Payment.PaymentPlanNextInstallmentDueDate
     * @uses Payment_PaymentPlanNextInstallmentDueDate::setHolderTenantId()
     * @uses Payment_PaymentPlanNextInstallmentDueDate::setNextInstallmentDueDate()
     * @uses Payment_PaymentPlanNextInstallmentDueDate::setPaymentInstallmentsScheduleId()
     * @param int $holderTenantId
     * @param string $nextInstallmentDueDate
     * @param string $paymentInstallmentsScheduleId
     */
    public function __construct($holderTenantId = null, $nextInstallmentDueDate = null, $paymentInstallmentsScheduleId = null)
    {
        $this
            ->setHolderTenantId($holderTenantId)
            ->setNextInstallmentDueDate($nextInstallmentDueDate)
            ->setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId);
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Payment_PaymentPlanNextInstallmentDueDate
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get NextInstallmentDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextInstallmentDueDate()
    {
        return isset($this->NextInstallmentDueDate) ? $this->NextInstallmentDueDate : null;
    }
    /**
     * Set NextInstallmentDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextInstallmentDueDate
     * @return \patest\StructType\Payment_PaymentPlanNextInstallmentDueDate
     */
    public function setNextInstallmentDueDate($nextInstallmentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextInstallmentDueDate) && !is_string($nextInstallmentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextInstallmentDueDate, true), gettype($nextInstallmentDueDate)), __LINE__);
        }
        if (is_null($nextInstallmentDueDate) || (is_array($nextInstallmentDueDate) && empty($nextInstallmentDueDate))) {
            unset($this->NextInstallmentDueDate);
        } else {
            $this->NextInstallmentDueDate = $nextInstallmentDueDate;
        }
        return $this;
    }
    /**
     * Get PaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentInstallmentsScheduleId()
    {
        return isset($this->PaymentInstallmentsScheduleId) ? $this->PaymentInstallmentsScheduleId : null;
    }
    /**
     * Set PaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentInstallmentsScheduleId
     * @return \patest\StructType\Payment_PaymentPlanNextInstallmentDueDate
     */
    public function setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstallmentsScheduleId) && !is_string($paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstallmentsScheduleId, true), gettype($paymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($paymentInstallmentsScheduleId) || (is_array($paymentInstallmentsScheduleId) && empty($paymentInstallmentsScheduleId))) {
            unset($this->PaymentInstallmentsScheduleId);
        } else {
            $this->PaymentInstallmentsScheduleId = $paymentInstallmentsScheduleId;
        }
        return $this;
    }
}
