<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentPlan StructType
 * @subpackage Structs
 */
class Payment_PaymentPlan extends Payment_PaymentMethod
{
    /**
     * The DownPaymentKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DownPaymentKind;
    /**
     * The DownPaymentValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DownPaymentValue;
    /**
     * The InstallmentDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_InstallmentDate
     */
    public $InstallmentDates;
    /**
     * The InstallmentPaymentMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\InstallmentPaymentMethods
     */
    public $InstallmentPaymentMethods;
    /**
     * The InstallmentsPastDuePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsPastDuePolicy;
    /**
     * The InstallmentsScheduleKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsScheduleKind;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * Constructor method for Payment.PaymentPlan
     * @uses Payment_PaymentPlan::setDownPaymentKind()
     * @uses Payment_PaymentPlan::setDownPaymentValue()
     * @uses Payment_PaymentPlan::setInstallmentDates()
     * @uses Payment_PaymentPlan::setInstallmentPaymentMethods()
     * @uses Payment_PaymentPlan::setInstallmentsPastDuePolicy()
     * @uses Payment_PaymentPlan::setInstallmentsScheduleKind()
     * @uses Payment_PaymentPlan::setNumberOfInstallments()
     * @param string $downPaymentKind
     * @param float $downPaymentValue
     * @param \patest\StructType\RecordSetOfPayment_InstallmentDate $installmentDates
     * @param \patest\StructType\InstallmentPaymentMethods $installmentPaymentMethods
     * @param string $installmentsPastDuePolicy
     * @param string $installmentsScheduleKind
     * @param int $numberOfInstallments
     */
    public function __construct($downPaymentKind = null, $downPaymentValue = null, \patest\StructType\RecordSetOfPayment_InstallmentDate $installmentDates = null, \patest\StructType\InstallmentPaymentMethods $installmentPaymentMethods = null, $installmentsPastDuePolicy = null, $installmentsScheduleKind = null, $numberOfInstallments = null)
    {
        $this
            ->setDownPaymentKind($downPaymentKind)
            ->setDownPaymentValue($downPaymentValue)
            ->setInstallmentDates($installmentDates)
            ->setInstallmentPaymentMethods($installmentPaymentMethods)
            ->setInstallmentsPastDuePolicy($installmentsPastDuePolicy)
            ->setInstallmentsScheduleKind($installmentsScheduleKind)
            ->setNumberOfInstallments($numberOfInstallments);
    }
    /**
     * Get DownPaymentKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDownPaymentKind()
    {
        return isset($this->DownPaymentKind) ? $this->DownPaymentKind : null;
    }
    /**
     * Set DownPaymentKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DownPaymentKind::valueIsValid()
     * @uses \patest\EnumType\DownPaymentKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $downPaymentKind
     * @return \patest\StructType\Payment_PaymentPlan
     */
    public function setDownPaymentKind($downPaymentKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DownPaymentKind::valueIsValid($downPaymentKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DownPaymentKind', is_array($downPaymentKind) ? implode(', ', $downPaymentKind) : var_export($downPaymentKind, true), implode(', ', \patest\EnumType\DownPaymentKind::getValidValues())), __LINE__);
        }
        if (is_null($downPaymentKind) || (is_array($downPaymentKind) && empty($downPaymentKind))) {
            unset($this->DownPaymentKind);
        } else {
            $this->DownPaymentKind = $downPaymentKind;
        }
        return $this;
    }
    /**
     * Get DownPaymentValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDownPaymentValue()
    {
        return isset($this->DownPaymentValue) ? $this->DownPaymentValue : null;
    }
    /**
     * Set DownPaymentValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $downPaymentValue
     * @return \patest\StructType\Payment_PaymentPlan
     */
    public function setDownPaymentValue($downPaymentValue = null)
    {
        // validation for constraint: float
        if (!is_null($downPaymentValue) && !(is_float($downPaymentValue) || is_numeric($downPaymentValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($downPaymentValue, true), gettype($downPaymentValue)), __LINE__);
        }
        if (is_null($downPaymentValue) || (is_array($downPaymentValue) && empty($downPaymentValue))) {
            unset($this->DownPaymentValue);
        } else {
            $this->DownPaymentValue = $downPaymentValue;
        }
        return $this;
    }
    /**
     * Get InstallmentDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_InstallmentDate|null
     */
    public function getInstallmentDates()
    {
        return isset($this->InstallmentDates) ? $this->InstallmentDates : null;
    }
    /**
     * Set InstallmentDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_InstallmentDate $installmentDates
     * @return \patest\StructType\Payment_PaymentPlan
     */
    public function setInstallmentDates(\patest\StructType\RecordSetOfPayment_InstallmentDate $installmentDates = null)
    {
        if (is_null($installmentDates) || (is_array($installmentDates) && empty($installmentDates))) {
            unset($this->InstallmentDates);
        } else {
            $this->InstallmentDates = $installmentDates;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\InstallmentPaymentMethods|null
     */
    public function getInstallmentPaymentMethods()
    {
        return isset($this->InstallmentPaymentMethods) ? $this->InstallmentPaymentMethods : null;
    }
    /**
     * Set InstallmentPaymentMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\InstallmentPaymentMethods $installmentPaymentMethods
     * @return \patest\StructType\Payment_PaymentPlan
     */
    public function setInstallmentPaymentMethods(\patest\StructType\InstallmentPaymentMethods $installmentPaymentMethods = null)
    {
        if (is_null($installmentPaymentMethods) || (is_array($installmentPaymentMethods) && empty($installmentPaymentMethods))) {
            unset($this->InstallmentPaymentMethods);
        } else {
            $this->InstallmentPaymentMethods = $installmentPaymentMethods;
        }
        return $this;
    }
    /**
     * Get InstallmentsPastDuePolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsPastDuePolicy()
    {
        return isset($this->InstallmentsPastDuePolicy) ? $this->InstallmentsPastDuePolicy : null;
    }
    /**
     * Set InstallmentsPastDuePolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsPastDuePolicy::valueIsValid()
     * @uses \patest\EnumType\InstallmentsPastDuePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsPastDuePolicy
     * @return \patest\StructType\Payment_PaymentPlan
     */
    public function setInstallmentsPastDuePolicy($installmentsPastDuePolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsPastDuePolicy::valueIsValid($installmentsPastDuePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsPastDuePolicy', is_array($installmentsPastDuePolicy) ? implode(', ', $installmentsPastDuePolicy) : var_export($installmentsPastDuePolicy, true), implode(', ', \patest\EnumType\InstallmentsPastDuePolicy::getValidValues())), __LINE__);
        }
        if (is_null($installmentsPastDuePolicy) || (is_array($installmentsPastDuePolicy) && empty($installmentsPastDuePolicy))) {
            unset($this->InstallmentsPastDuePolicy);
        } else {
            $this->InstallmentsPastDuePolicy = $installmentsPastDuePolicy;
        }
        return $this;
    }
    /**
     * Get InstallmentsScheduleKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsScheduleKind()
    {
        return isset($this->InstallmentsScheduleKind) ? $this->InstallmentsScheduleKind : null;
    }
    /**
     * Set InstallmentsScheduleKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsScheduleKind
     * @return \patest\StructType\Payment_PaymentPlan
     */
    public function setInstallmentsScheduleKind($installmentsScheduleKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($installmentsScheduleKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($installmentsScheduleKind) ? implode(', ', $installmentsScheduleKind) : var_export($installmentsScheduleKind, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        if (is_null($installmentsScheduleKind) || (is_array($installmentsScheduleKind) && empty($installmentsScheduleKind))) {
            unset($this->InstallmentsScheduleKind);
        } else {
            $this->InstallmentsScheduleKind = $installmentsScheduleKind;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Payment_PaymentPlan
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
}
