<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentIntention StructType
 * @subpackage Structs
 */
class Payment_PaymentIntention extends AnyEntity
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Id;
    /**
     * The IntegrationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntegrationType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Payment.PaymentIntention
     * @uses Payment_PaymentIntention::setId()
     * @uses Payment_PaymentIntention::setIntegrationType()
     * @uses Payment_PaymentIntention::setName()
     * @param string[] $id
     * @param string $integrationType
     * @param string $name
     */
    public function __construct(array $id = array(), $integrationType = null, $name = null)
    {
        $this
            ->setId($id)
            ->setIntegrationType($integrationType)
            ->setName($name);
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payment_PaymentIntentionIdItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentIntention::valueIsValid($payment_PaymentIntentionIdItem)) {
                $invalidValues[] = is_object($payment_PaymentIntentionIdItem) ? get_class($payment_PaymentIntentionIdItem) : sprintf('%s(%s)', gettype($payment_PaymentIntentionIdItem), var_export($payment_PaymentIntentionIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentIntention', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentIntention::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentIntention::valueIsValid()
     * @uses \patest\EnumType\PaymentIntention::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $id
     * @return \patest\StructType\Payment_PaymentIntention
     */
    public function setId(array $id = array())
    {
        // validation for constraint: list
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = is_array($id) ? implode(' ', $id) : null;
        }
        return $this;
    }
    /**
     * Get IntegrationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrationType()
    {
        return isset($this->IntegrationType) ? $this->IntegrationType : null;
    }
    /**
     * Set IntegrationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrationType
     * @return \patest\StructType\Payment_PaymentIntention
     */
    public function setIntegrationType($integrationType = null)
    {
        // validation for constraint: string
        if (!is_null($integrationType) && !is_string($integrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationType, true), gettype($integrationType)), __LINE__);
        }
        if (is_null($integrationType) || (is_array($integrationType) && empty($integrationType))) {
            unset($this->IntegrationType);
        } else {
            $this->IntegrationType = $integrationType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Payment_PaymentIntention
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
