<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentDetails StructType
 * @subpackage Structs
 */
class Payment_PaymentDetails extends VolatileEntity
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CommitDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateTime;
    /**
     * The CompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmount;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Installments;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentPlanScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanScheduleId;
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReceiptNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Payment.PaymentDetails
     * @uses Payment_PaymentDetails::setClientAmount()
     * @uses Payment_PaymentDetails::setClientId()
     * @uses Payment_PaymentDetails::setCommitDateTime()
     * @uses Payment_PaymentDetails::setCompanyAmount()
     * @uses Payment_PaymentDetails::setDetails()
     * @uses Payment_PaymentDetails::setInsertionMode()
     * @uses Payment_PaymentDetails::setInstallments()
     * @uses Payment_PaymentDetails::setPaymentItemId()
     * @uses Payment_PaymentDetails::setPaymentMethodId()
     * @uses Payment_PaymentDetails::setPaymentMethodName()
     * @uses Payment_PaymentDetails::setPaymentMethodType()
     * @uses Payment_PaymentDetails::setPaymentPlanScheduleId()
     * @uses Payment_PaymentDetails::setReceiptNumber()
     * @uses Payment_PaymentDetails::setStatus()
     * @uses Payment_PaymentDetails::setTransactionGuid()
     * @uses Payment_PaymentDetails::setTransactionNumber()
     * @uses Payment_PaymentDetails::setTransactionReferenceNumber()
     * @uses Payment_PaymentDetails::setUserId()
     * @param \patest\StructType\Money $clientAmount
     * @param string $clientId
     * @param string $commitDateTime
     * @param \patest\StructType\Money $companyAmount
     * @param string $details
     * @param string $insertionMode
     * @param int $installments
     * @param string $paymentItemId
     * @param string $paymentMethodId
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param string $paymentMethodType
     * @param string $paymentPlanScheduleId
     * @param int $receiptNumber
     * @param string $status
     * @param string $transactionGuid
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     * @param string $userId
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $clientId = null, $commitDateTime = null, \patest\StructType\Money $companyAmount = null, $details = null, $insertionMode = null, $installments = null, $paymentItemId = null, $paymentMethodId = null, \patest\StructType\GlobalString $paymentMethodName = null, $paymentMethodType = null, $paymentPlanScheduleId = null, $receiptNumber = null, $status = null, $transactionGuid = null, $transactionNumber = null, $transactionReferenceNumber = null, $userId = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setClientId($clientId)
            ->setCommitDateTime($commitDateTime)
            ->setCompanyAmount($companyAmount)
            ->setDetails($details)
            ->setInsertionMode($insertionMode)
            ->setInstallments($installments)
            ->setPaymentItemId($paymentItemId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentPlanScheduleId($paymentPlanScheduleId)
            ->setReceiptNumber($receiptNumber)
            ->setStatus($status)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setUserId($userId);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CommitDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateTime()
    {
        return isset($this->CommitDateTime) ? $this->CommitDateTime : null;
    }
    /**
     * Set CommitDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateTime
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setCommitDateTime($commitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateTime) && !is_string($commitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateTime, true), gettype($commitDateTime)), __LINE__);
        }
        if (is_null($commitDateTime) || (is_array($commitDateTime) && empty($commitDateTime))) {
            unset($this->CommitDateTime);
        } else {
            $this->CommitDateTime = $commitDateTime;
        }
        return $this;
    }
    /**
     * Get CompanyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmount()
    {
        return isset($this->CompanyAmount) ? $this->CompanyAmount : null;
    }
    /**
     * Set CompanyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmount
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setCompanyAmount(\patest\StructType\Money $companyAmount = null)
    {
        if (is_null($companyAmount) || (is_array($companyAmount) && empty($companyAmount))) {
            unset($this->CompanyAmount);
        } else {
            $this->CompanyAmount = $companyAmount;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installments
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setInstallments($installments = null)
    {
        // validation for constraint: int
        if (!is_null($installments) && !(is_int($installments) || ctype_digit($installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installments, true), gettype($installments)), __LINE__);
        }
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentPlanScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanScheduleId()
    {
        return isset($this->PaymentPlanScheduleId) ? $this->PaymentPlanScheduleId : null;
    }
    /**
     * Set PaymentPlanScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanScheduleId
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setPaymentPlanScheduleId($paymentPlanScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanScheduleId) && !is_string($paymentPlanScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanScheduleId, true), gettype($paymentPlanScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanScheduleId, true)), __LINE__);
        }
        if (is_null($paymentPlanScheduleId) || (is_array($paymentPlanScheduleId) && empty($paymentPlanScheduleId))) {
            unset($this->PaymentPlanScheduleId);
        } else {
            $this->PaymentPlanScheduleId = $paymentPlanScheduleId;
        }
        return $this;
    }
    /**
     * Get ReceiptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReceiptNumber()
    {
        return isset($this->ReceiptNumber) ? $this->ReceiptNumber : null;
    }
    /**
     * Set ReceiptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $receiptNumber
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: int
        if (!is_null($receiptNumber) && !(is_int($receiptNumber) || ctype_digit($receiptNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        if (is_null($receiptNumber) || (is_array($receiptNumber) && empty($receiptNumber))) {
            unset($this->ReceiptNumber);
        } else {
            $this->ReceiptNumber = $receiptNumber;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Payment_PaymentDetails
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
