<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.MandateType StructType
 * @subpackage Structs
 */
class Payment_MandateType extends DistributableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CollectPaymentOnDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CollectPaymentOnDay;
    /**
     * The ConfirmationPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationPolicy;
    /**
     * The CreateMandateDuringPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateMandateDuringPayment;
    /**
     * The CreditorBIC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditorBIC;
    /**
     * The CreditorIBAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditorIBAN;
    /**
     * The CreditorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditorId;
    /**
     * The CreditorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditorName;
    /**
     * The MandateAuthorizedByDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MandateAuthorizedByDefault;
    /**
     * The MandateExpirationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateExpirationDays;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NotSoonerThenDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotSoonerThenDate;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Payment.MandateType
     * @uses Payment_MandateType::setAclSchemeId()
     * @uses Payment_MandateType::setCollectPaymentOnDay()
     * @uses Payment_MandateType::setConfirmationPolicy()
     * @uses Payment_MandateType::setCreateMandateDuringPayment()
     * @uses Payment_MandateType::setCreditorBIC()
     * @uses Payment_MandateType::setCreditorIBAN()
     * @uses Payment_MandateType::setCreditorId()
     * @uses Payment_MandateType::setCreditorName()
     * @uses Payment_MandateType::setMandateAuthorizedByDefault()
     * @uses Payment_MandateType::setMandateExpirationDays()
     * @uses Payment_MandateType::setName()
     * @uses Payment_MandateType::setNotSoonerThenDate()
     * @uses Payment_MandateType::setOrganizationUnitId()
     * @uses Payment_MandateType::setPriority()
     * @uses Payment_MandateType::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param int $collectPaymentOnDay
     * @param string $confirmationPolicy
     * @param string $createMandateDuringPayment
     * @param string $creditorBIC
     * @param string $creditorIBAN
     * @param string $creditorId
     * @param string $creditorName
     * @param bool $mandateAuthorizedByDefault
     * @param int $mandateExpirationDays
     * @param \patest\StructType\GlobalString $name
     * @param string $notSoonerThenDate
     * @param string $organizationUnitId
     * @param int $priority
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $collectPaymentOnDay = null, $confirmationPolicy = null, $createMandateDuringPayment = null, $creditorBIC = null, $creditorIBAN = null, $creditorId = null, $creditorName = null, $mandateAuthorizedByDefault = null, $mandateExpirationDays = null, \patest\StructType\GlobalString $name = null, $notSoonerThenDate = null, $organizationUnitId = null, $priority = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setCollectPaymentOnDay($collectPaymentOnDay)
            ->setConfirmationPolicy($confirmationPolicy)
            ->setCreateMandateDuringPayment($createMandateDuringPayment)
            ->setCreditorBIC($creditorBIC)
            ->setCreditorIBAN($creditorIBAN)
            ->setCreditorId($creditorId)
            ->setCreditorName($creditorName)
            ->setMandateAuthorizedByDefault($mandateAuthorizedByDefault)
            ->setMandateExpirationDays($mandateExpirationDays)
            ->setName($name)
            ->setNotSoonerThenDate($notSoonerThenDate)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPriority($priority)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Payment_MandateType
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CollectPaymentOnDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCollectPaymentOnDay()
    {
        return isset($this->CollectPaymentOnDay) ? $this->CollectPaymentOnDay : null;
    }
    /**
     * Set CollectPaymentOnDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $collectPaymentOnDay
     * @return \patest\StructType\Payment_MandateType
     */
    public function setCollectPaymentOnDay($collectPaymentOnDay = null)
    {
        // validation for constraint: int
        if (!is_null($collectPaymentOnDay) && !(is_int($collectPaymentOnDay) || ctype_digit($collectPaymentOnDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($collectPaymentOnDay, true), gettype($collectPaymentOnDay)), __LINE__);
        }
        if (is_null($collectPaymentOnDay) || (is_array($collectPaymentOnDay) && empty($collectPaymentOnDay))) {
            unset($this->CollectPaymentOnDay);
        } else {
            $this->CollectPaymentOnDay = $collectPaymentOnDay;
        }
        return $this;
    }
    /**
     * Get ConfirmationPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationPolicy()
    {
        return isset($this->ConfirmationPolicy) ? $this->ConfirmationPolicy : null;
    }
    /**
     * Set ConfirmationPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ConfirmationPolicy::valueIsValid()
     * @uses \patest\EnumType\ConfirmationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confirmationPolicy
     * @return \patest\StructType\Payment_MandateType
     */
    public function setConfirmationPolicy($confirmationPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ConfirmationPolicy::valueIsValid($confirmationPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ConfirmationPolicy', is_array($confirmationPolicy) ? implode(', ', $confirmationPolicy) : var_export($confirmationPolicy, true), implode(', ', \patest\EnumType\ConfirmationPolicy::getValidValues())), __LINE__);
        }
        if (is_null($confirmationPolicy) || (is_array($confirmationPolicy) && empty($confirmationPolicy))) {
            unset($this->ConfirmationPolicy);
        } else {
            $this->ConfirmationPolicy = $confirmationPolicy;
        }
        return $this;
    }
    /**
     * Get CreateMandateDuringPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateMandateDuringPayment()
    {
        return isset($this->CreateMandateDuringPayment) ? $this->CreateMandateDuringPayment : null;
    }
    /**
     * Set CreateMandateDuringPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CreateMandateDuringPayment::valueIsValid()
     * @uses \patest\EnumType\CreateMandateDuringPayment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $createMandateDuringPayment
     * @return \patest\StructType\Payment_MandateType
     */
    public function setCreateMandateDuringPayment($createMandateDuringPayment = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CreateMandateDuringPayment::valueIsValid($createMandateDuringPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CreateMandateDuringPayment', is_array($createMandateDuringPayment) ? implode(', ', $createMandateDuringPayment) : var_export($createMandateDuringPayment, true), implode(', ', \patest\EnumType\CreateMandateDuringPayment::getValidValues())), __LINE__);
        }
        if (is_null($createMandateDuringPayment) || (is_array($createMandateDuringPayment) && empty($createMandateDuringPayment))) {
            unset($this->CreateMandateDuringPayment);
        } else {
            $this->CreateMandateDuringPayment = $createMandateDuringPayment;
        }
        return $this;
    }
    /**
     * Get CreditorBIC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditorBIC()
    {
        return isset($this->CreditorBIC) ? $this->CreditorBIC : null;
    }
    /**
     * Set CreditorBIC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditorBIC
     * @return \patest\StructType\Payment_MandateType
     */
    public function setCreditorBIC($creditorBIC = null)
    {
        // validation for constraint: string
        if (!is_null($creditorBIC) && !is_string($creditorBIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditorBIC, true), gettype($creditorBIC)), __LINE__);
        }
        if (is_null($creditorBIC) || (is_array($creditorBIC) && empty($creditorBIC))) {
            unset($this->CreditorBIC);
        } else {
            $this->CreditorBIC = $creditorBIC;
        }
        return $this;
    }
    /**
     * Get CreditorIBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditorIBAN()
    {
        return isset($this->CreditorIBAN) ? $this->CreditorIBAN : null;
    }
    /**
     * Set CreditorIBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditorIBAN
     * @return \patest\StructType\Payment_MandateType
     */
    public function setCreditorIBAN($creditorIBAN = null)
    {
        // validation for constraint: string
        if (!is_null($creditorIBAN) && !is_string($creditorIBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditorIBAN, true), gettype($creditorIBAN)), __LINE__);
        }
        if (is_null($creditorIBAN) || (is_array($creditorIBAN) && empty($creditorIBAN))) {
            unset($this->CreditorIBAN);
        } else {
            $this->CreditorIBAN = $creditorIBAN;
        }
        return $this;
    }
    /**
     * Get CreditorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditorId()
    {
        return isset($this->CreditorId) ? $this->CreditorId : null;
    }
    /**
     * Set CreditorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditorId
     * @return \patest\StructType\Payment_MandateType
     */
    public function setCreditorId($creditorId = null)
    {
        // validation for constraint: string
        if (!is_null($creditorId) && !is_string($creditorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditorId, true), gettype($creditorId)), __LINE__);
        }
        if (is_null($creditorId) || (is_array($creditorId) && empty($creditorId))) {
            unset($this->CreditorId);
        } else {
            $this->CreditorId = $creditorId;
        }
        return $this;
    }
    /**
     * Get CreditorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditorName()
    {
        return isset($this->CreditorName) ? $this->CreditorName : null;
    }
    /**
     * Set CreditorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditorName
     * @return \patest\StructType\Payment_MandateType
     */
    public function setCreditorName($creditorName = null)
    {
        // validation for constraint: string
        if (!is_null($creditorName) && !is_string($creditorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditorName, true), gettype($creditorName)), __LINE__);
        }
        if (is_null($creditorName) || (is_array($creditorName) && empty($creditorName))) {
            unset($this->CreditorName);
        } else {
            $this->CreditorName = $creditorName;
        }
        return $this;
    }
    /**
     * Get MandateAuthorizedByDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMandateAuthorizedByDefault()
    {
        return isset($this->MandateAuthorizedByDefault) ? $this->MandateAuthorizedByDefault : null;
    }
    /**
     * Set MandateAuthorizedByDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mandateAuthorizedByDefault
     * @return \patest\StructType\Payment_MandateType
     */
    public function setMandateAuthorizedByDefault($mandateAuthorizedByDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandateAuthorizedByDefault) && !is_bool($mandateAuthorizedByDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandateAuthorizedByDefault, true), gettype($mandateAuthorizedByDefault)), __LINE__);
        }
        if (is_null($mandateAuthorizedByDefault) || (is_array($mandateAuthorizedByDefault) && empty($mandateAuthorizedByDefault))) {
            unset($this->MandateAuthorizedByDefault);
        } else {
            $this->MandateAuthorizedByDefault = $mandateAuthorizedByDefault;
        }
        return $this;
    }
    /**
     * Get MandateExpirationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateExpirationDays()
    {
        return isset($this->MandateExpirationDays) ? $this->MandateExpirationDays : null;
    }
    /**
     * Set MandateExpirationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateExpirationDays
     * @return \patest\StructType\Payment_MandateType
     */
    public function setMandateExpirationDays($mandateExpirationDays = null)
    {
        // validation for constraint: int
        if (!is_null($mandateExpirationDays) && !(is_int($mandateExpirationDays) || ctype_digit($mandateExpirationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateExpirationDays, true), gettype($mandateExpirationDays)), __LINE__);
        }
        if (is_null($mandateExpirationDays) || (is_array($mandateExpirationDays) && empty($mandateExpirationDays))) {
            unset($this->MandateExpirationDays);
        } else {
            $this->MandateExpirationDays = $mandateExpirationDays;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Payment_MandateType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NotSoonerThenDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotSoonerThenDate()
    {
        return isset($this->NotSoonerThenDate) ? $this->NotSoonerThenDate : null;
    }
    /**
     * Set NotSoonerThenDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notSoonerThenDate
     * @return \patest\StructType\Payment_MandateType
     */
    public function setNotSoonerThenDate($notSoonerThenDate = null)
    {
        // validation for constraint: string
        if (!is_null($notSoonerThenDate) && !is_string($notSoonerThenDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notSoonerThenDate, true), gettype($notSoonerThenDate)), __LINE__);
        }
        if (is_null($notSoonerThenDate) || (is_array($notSoonerThenDate) && empty($notSoonerThenDate))) {
            unset($this->NotSoonerThenDate);
        } else {
            $this->NotSoonerThenDate = $notSoonerThenDate;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Payment_MandateType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Payment_MandateType
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Payment_MandateType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
