<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.LoyaltyPointsPaymentItemInformation StructType
 * @subpackage Structs
 */
class Payment_LoyaltyPointsPaymentItemInformation extends Payment_BasePaymentItemInformation
{
    /**
     * The PointQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointQuantity;
    /**
     * Constructor method for Payment.LoyaltyPointsPaymentItemInformation
     * @uses Payment_LoyaltyPointsPaymentItemInformation::setPointQuantity()
     * @param string $pointQuantity
     */
    public function __construct($pointQuantity = null)
    {
        $this
            ->setPointQuantity($pointQuantity);
    }
    /**
     * Get PointQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointQuantity()
    {
        return isset($this->PointQuantity) ? $this->PointQuantity : null;
    }
    /**
     * Set PointQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pointQuantity
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentItemInformation
     */
    public function setPointQuantity($pointQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($pointQuantity) && !is_string($pointQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointQuantity, true), gettype($pointQuantity)), __LINE__);
        }
        if (is_null($pointQuantity) || (is_array($pointQuantity) && empty($pointQuantity))) {
            unset($this->PointQuantity);
        } else {
            $this->PointQuantity = $pointQuantity;
        }
        return $this;
    }
}
