<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.LoyaltyPointsPaymentDetail StructType
 * @subpackage Structs
 */
class Payment_LoyaltyPointsPaymentDetail extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CompanyAmountEquivalent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmountEquivalent;
    /**
     * The IsRefundComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRefundComplete;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The PointsExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PointsExchange;
    /**
     * The RedeemedPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RedeemedPoints;
    /**
     * The RefundPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RefundPoints;
    /**
     * The SiteAmountEquivalent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SiteAmountEquivalent;
    /**
     * Constructor method for Payment.LoyaltyPointsPaymentDetail
     * @uses Payment_LoyaltyPointsPaymentDetail::setClientId()
     * @uses Payment_LoyaltyPointsPaymentDetail::setCompanyAmountEquivalent()
     * @uses Payment_LoyaltyPointsPaymentDetail::setIsRefundComplete()
     * @uses Payment_LoyaltyPointsPaymentDetail::setPaymentItemId()
     * @uses Payment_LoyaltyPointsPaymentDetail::setPointsExchange()
     * @uses Payment_LoyaltyPointsPaymentDetail::setRedeemedPoints()
     * @uses Payment_LoyaltyPointsPaymentDetail::setRefundPoints()
     * @uses Payment_LoyaltyPointsPaymentDetail::setSiteAmountEquivalent()
     * @param string $clientId
     * @param \patest\StructType\Money $companyAmountEquivalent
     * @param bool $isRefundComplete
     * @param string $paymentItemId
     * @param float $pointsExchange
     * @param float $redeemedPoints
     * @param float $refundPoints
     * @param \patest\StructType\Money $siteAmountEquivalent
     */
    public function __construct($clientId = null, \patest\StructType\Money $companyAmountEquivalent = null, $isRefundComplete = null, $paymentItemId = null, $pointsExchange = null, $redeemedPoints = null, $refundPoints = null, \patest\StructType\Money $siteAmountEquivalent = null)
    {
        $this
            ->setClientId($clientId)
            ->setCompanyAmountEquivalent($companyAmountEquivalent)
            ->setIsRefundComplete($isRefundComplete)
            ->setPaymentItemId($paymentItemId)
            ->setPointsExchange($pointsExchange)
            ->setRedeemedPoints($redeemedPoints)
            ->setRefundPoints($refundPoints)
            ->setSiteAmountEquivalent($siteAmountEquivalent);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CompanyAmountEquivalent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmountEquivalent()
    {
        return isset($this->CompanyAmountEquivalent) ? $this->CompanyAmountEquivalent : null;
    }
    /**
     * Set CompanyAmountEquivalent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmountEquivalent
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setCompanyAmountEquivalent(\patest\StructType\Money $companyAmountEquivalent = null)
    {
        if (is_null($companyAmountEquivalent) || (is_array($companyAmountEquivalent) && empty($companyAmountEquivalent))) {
            unset($this->CompanyAmountEquivalent);
        } else {
            $this->CompanyAmountEquivalent = $companyAmountEquivalent;
        }
        return $this;
    }
    /**
     * Get IsRefundComplete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRefundComplete()
    {
        return isset($this->IsRefundComplete) ? $this->IsRefundComplete : null;
    }
    /**
     * Set IsRefundComplete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRefundComplete
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setIsRefundComplete($isRefundComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRefundComplete) && !is_bool($isRefundComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRefundComplete, true), gettype($isRefundComplete)), __LINE__);
        }
        if (is_null($isRefundComplete) || (is_array($isRefundComplete) && empty($isRefundComplete))) {
            unset($this->IsRefundComplete);
        } else {
            $this->IsRefundComplete = $isRefundComplete;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get PointsExchange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPointsExchange()
    {
        return isset($this->PointsExchange) ? $this->PointsExchange : null;
    }
    /**
     * Set PointsExchange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pointsExchange
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setPointsExchange($pointsExchange = null)
    {
        // validation for constraint: float
        if (!is_null($pointsExchange) && !(is_float($pointsExchange) || is_numeric($pointsExchange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointsExchange, true), gettype($pointsExchange)), __LINE__);
        }
        if (is_null($pointsExchange) || (is_array($pointsExchange) && empty($pointsExchange))) {
            unset($this->PointsExchange);
        } else {
            $this->PointsExchange = $pointsExchange;
        }
        return $this;
    }
    /**
     * Get RedeemedPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRedeemedPoints()
    {
        return isset($this->RedeemedPoints) ? $this->RedeemedPoints : null;
    }
    /**
     * Set RedeemedPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $redeemedPoints
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setRedeemedPoints($redeemedPoints = null)
    {
        // validation for constraint: float
        if (!is_null($redeemedPoints) && !(is_float($redeemedPoints) || is_numeric($redeemedPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redeemedPoints, true), gettype($redeemedPoints)), __LINE__);
        }
        if (is_null($redeemedPoints) || (is_array($redeemedPoints) && empty($redeemedPoints))) {
            unset($this->RedeemedPoints);
        } else {
            $this->RedeemedPoints = $redeemedPoints;
        }
        return $this;
    }
    /**
     * Get RefundPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRefundPoints()
    {
        return isset($this->RefundPoints) ? $this->RefundPoints : null;
    }
    /**
     * Set RefundPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $refundPoints
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setRefundPoints($refundPoints = null)
    {
        // validation for constraint: float
        if (!is_null($refundPoints) && !(is_float($refundPoints) || is_numeric($refundPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refundPoints, true), gettype($refundPoints)), __LINE__);
        }
        if (is_null($refundPoints) || (is_array($refundPoints) && empty($refundPoints))) {
            unset($this->RefundPoints);
        } else {
            $this->RefundPoints = $refundPoints;
        }
        return $this;
    }
    /**
     * Get SiteAmountEquivalent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmountEquivalent()
    {
        return isset($this->SiteAmountEquivalent) ? $this->SiteAmountEquivalent : null;
    }
    /**
     * Set SiteAmountEquivalent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $siteAmountEquivalent
     * @return \patest\StructType\Payment_LoyaltyPointsPaymentDetail
     */
    public function setSiteAmountEquivalent(\patest\StructType\Money $siteAmountEquivalent = null)
    {
        if (is_null($siteAmountEquivalent) || (is_array($siteAmountEquivalent) && empty($siteAmountEquivalent))) {
            unset($this->SiteAmountEquivalent);
        } else {
            $this->SiteAmountEquivalent = $siteAmountEquivalent;
        }
        return $this;
    }
}
