<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.InstallmentFilter StructType
 * @subpackage Structs
 */
class Payment_InstallmentFilter extends FilterEntity
{
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The ClientSalesRepIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientSalesRepIds
     */
    public $ClientSalesRepIds;
    /**
     * The CreditCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardSuffix;
    /**
     * The DepositTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepositTransactionNumber;
    /**
     * The DueDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDateFrom;
    /**
     * The DueDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDateTo;
    /**
     * The ExecutionDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionDateFrom;
    /**
     * The ExecutionDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionDateTo;
    /**
     * The ExpiryDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateFrom;
    /**
     * The ExpiryDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateTo;
    /**
     * The InstallmentAmountGreaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $InstallmentAmountGreaterThan;
    /**
     * The InstallmentAmountLessThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $InstallmentAmountLessThan;
    /**
     * The InstallmentPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentMethodId;
    /**
     * The InstallmentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentStatus;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The PaymentPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanId;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Payment.InstallmentFilter
     * @uses Payment_InstallmentFilter::setClientName()
     * @uses Payment_InstallmentFilter::setClientSalesRepIds()
     * @uses Payment_InstallmentFilter::setCreditCardSuffix()
     * @uses Payment_InstallmentFilter::setDepositTransactionNumber()
     * @uses Payment_InstallmentFilter::setDueDateFrom()
     * @uses Payment_InstallmentFilter::setDueDateTo()
     * @uses Payment_InstallmentFilter::setExecutionDateFrom()
     * @uses Payment_InstallmentFilter::setExecutionDateTo()
     * @uses Payment_InstallmentFilter::setExpiryDateFrom()
     * @uses Payment_InstallmentFilter::setExpiryDateTo()
     * @uses Payment_InstallmentFilter::setInstallmentAmountGreaterThan()
     * @uses Payment_InstallmentFilter::setInstallmentAmountLessThan()
     * @uses Payment_InstallmentFilter::setInstallmentPaymentMethodId()
     * @uses Payment_InstallmentFilter::setInstallmentStatus()
     * @uses Payment_InstallmentFilter::setMandateNumber()
     * @uses Payment_InstallmentFilter::setPaymentPlanId()
     * @uses Payment_InstallmentFilter::setPaymentStatus()
     * @uses Payment_InstallmentFilter::setTransactionNumber()
     * @param string $clientName
     * @param \patest\StructType\ClientSalesRepIds $clientSalesRepIds
     * @param string $creditCardSuffix
     * @param string $depositTransactionNumber
     * @param string $dueDateFrom
     * @param string $dueDateTo
     * @param string $executionDateFrom
     * @param string $executionDateTo
     * @param string $expiryDateFrom
     * @param string $expiryDateTo
     * @param \patest\StructType\Money $installmentAmountGreaterThan
     * @param \patest\StructType\Money $installmentAmountLessThan
     * @param string $installmentPaymentMethodId
     * @param string $installmentStatus
     * @param int $mandateNumber
     * @param string $paymentPlanId
     * @param string $paymentStatus
     * @param int $transactionNumber
     */
    public function __construct($clientName = null, \patest\StructType\ClientSalesRepIds $clientSalesRepIds = null, $creditCardSuffix = null, $depositTransactionNumber = null, $dueDateFrom = null, $dueDateTo = null, $executionDateFrom = null, $executionDateTo = null, $expiryDateFrom = null, $expiryDateTo = null, \patest\StructType\Money $installmentAmountGreaterThan = null, \patest\StructType\Money $installmentAmountLessThan = null, $installmentPaymentMethodId = null, $installmentStatus = null, $mandateNumber = null, $paymentPlanId = null, $paymentStatus = null, $transactionNumber = null)
    {
        $this
            ->setClientName($clientName)
            ->setClientSalesRepIds($clientSalesRepIds)
            ->setCreditCardSuffix($creditCardSuffix)
            ->setDepositTransactionNumber($depositTransactionNumber)
            ->setDueDateFrom($dueDateFrom)
            ->setDueDateTo($dueDateTo)
            ->setExecutionDateFrom($executionDateFrom)
            ->setExecutionDateTo($executionDateTo)
            ->setExpiryDateFrom($expiryDateFrom)
            ->setExpiryDateTo($expiryDateTo)
            ->setInstallmentAmountGreaterThan($installmentAmountGreaterThan)
            ->setInstallmentAmountLessThan($installmentAmountLessThan)
            ->setInstallmentPaymentMethodId($installmentPaymentMethodId)
            ->setInstallmentStatus($installmentStatus)
            ->setMandateNumber($mandateNumber)
            ->setPaymentPlanId($paymentPlanId)
            ->setPaymentStatus($paymentStatus)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get ClientSalesRepIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientSalesRepIds|null
     */
    public function getClientSalesRepIds()
    {
        return isset($this->ClientSalesRepIds) ? $this->ClientSalesRepIds : null;
    }
    /**
     * Set ClientSalesRepIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientSalesRepIds $clientSalesRepIds
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setClientSalesRepIds(\patest\StructType\ClientSalesRepIds $clientSalesRepIds = null)
    {
        if (is_null($clientSalesRepIds) || (is_array($clientSalesRepIds) && empty($clientSalesRepIds))) {
            unset($this->ClientSalesRepIds);
        } else {
            $this->ClientSalesRepIds = $clientSalesRepIds;
        }
        return $this;
    }
    /**
     * Get CreditCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardSuffix()
    {
        return isset($this->CreditCardSuffix) ? $this->CreditCardSuffix : null;
    }
    /**
     * Set CreditCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardSuffix
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setCreditCardSuffix($creditCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardSuffix) && !is_string($creditCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardSuffix, true), gettype($creditCardSuffix)), __LINE__);
        }
        if (is_null($creditCardSuffix) || (is_array($creditCardSuffix) && empty($creditCardSuffix))) {
            unset($this->CreditCardSuffix);
        } else {
            $this->CreditCardSuffix = $creditCardSuffix;
        }
        return $this;
    }
    /**
     * Get DepositTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositTransactionNumber()
    {
        return isset($this->DepositTransactionNumber) ? $this->DepositTransactionNumber : null;
    }
    /**
     * Set DepositTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositTransactionNumber
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setDepositTransactionNumber($depositTransactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($depositTransactionNumber) && !is_string($depositTransactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTransactionNumber, true), gettype($depositTransactionNumber)), __LINE__);
        }
        if (is_null($depositTransactionNumber) || (is_array($depositTransactionNumber) && empty($depositTransactionNumber))) {
            unset($this->DepositTransactionNumber);
        } else {
            $this->DepositTransactionNumber = $depositTransactionNumber;
        }
        return $this;
    }
    /**
     * Get DueDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDateFrom()
    {
        return isset($this->DueDateFrom) ? $this->DueDateFrom : null;
    }
    /**
     * Set DueDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDateFrom
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setDueDateFrom($dueDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dueDateFrom) && !is_string($dueDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDateFrom, true), gettype($dueDateFrom)), __LINE__);
        }
        if (is_null($dueDateFrom) || (is_array($dueDateFrom) && empty($dueDateFrom))) {
            unset($this->DueDateFrom);
        } else {
            $this->DueDateFrom = $dueDateFrom;
        }
        return $this;
    }
    /**
     * Get DueDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDateTo()
    {
        return isset($this->DueDateTo) ? $this->DueDateTo : null;
    }
    /**
     * Set DueDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDateTo
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setDueDateTo($dueDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dueDateTo) && !is_string($dueDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDateTo, true), gettype($dueDateTo)), __LINE__);
        }
        if (is_null($dueDateTo) || (is_array($dueDateTo) && empty($dueDateTo))) {
            unset($this->DueDateTo);
        } else {
            $this->DueDateTo = $dueDateTo;
        }
        return $this;
    }
    /**
     * Get ExecutionDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionDateFrom()
    {
        return isset($this->ExecutionDateFrom) ? $this->ExecutionDateFrom : null;
    }
    /**
     * Set ExecutionDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionDateFrom
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setExecutionDateFrom($executionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($executionDateFrom) && !is_string($executionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDateFrom, true), gettype($executionDateFrom)), __LINE__);
        }
        if (is_null($executionDateFrom) || (is_array($executionDateFrom) && empty($executionDateFrom))) {
            unset($this->ExecutionDateFrom);
        } else {
            $this->ExecutionDateFrom = $executionDateFrom;
        }
        return $this;
    }
    /**
     * Get ExecutionDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionDateTo()
    {
        return isset($this->ExecutionDateTo) ? $this->ExecutionDateTo : null;
    }
    /**
     * Set ExecutionDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionDateTo
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setExecutionDateTo($executionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($executionDateTo) && !is_string($executionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDateTo, true), gettype($executionDateTo)), __LINE__);
        }
        if (is_null($executionDateTo) || (is_array($executionDateTo) && empty($executionDateTo))) {
            unset($this->ExecutionDateTo);
        } else {
            $this->ExecutionDateTo = $executionDateTo;
        }
        return $this;
    }
    /**
     * Get ExpiryDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateFrom()
    {
        return isset($this->ExpiryDateFrom) ? $this->ExpiryDateFrom : null;
    }
    /**
     * Set ExpiryDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateFrom
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setExpiryDateFrom($expiryDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateFrom) && !is_string($expiryDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateFrom, true), gettype($expiryDateFrom)), __LINE__);
        }
        if (is_null($expiryDateFrom) || (is_array($expiryDateFrom) && empty($expiryDateFrom))) {
            unset($this->ExpiryDateFrom);
        } else {
            $this->ExpiryDateFrom = $expiryDateFrom;
        }
        return $this;
    }
    /**
     * Get ExpiryDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateTo()
    {
        return isset($this->ExpiryDateTo) ? $this->ExpiryDateTo : null;
    }
    /**
     * Set ExpiryDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateTo
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setExpiryDateTo($expiryDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateTo) && !is_string($expiryDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateTo, true), gettype($expiryDateTo)), __LINE__);
        }
        if (is_null($expiryDateTo) || (is_array($expiryDateTo) && empty($expiryDateTo))) {
            unset($this->ExpiryDateTo);
        } else {
            $this->ExpiryDateTo = $expiryDateTo;
        }
        return $this;
    }
    /**
     * Get InstallmentAmountGreaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getInstallmentAmountGreaterThan()
    {
        return isset($this->InstallmentAmountGreaterThan) ? $this->InstallmentAmountGreaterThan : null;
    }
    /**
     * Set InstallmentAmountGreaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $installmentAmountGreaterThan
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setInstallmentAmountGreaterThan(\patest\StructType\Money $installmentAmountGreaterThan = null)
    {
        if (is_null($installmentAmountGreaterThan) || (is_array($installmentAmountGreaterThan) && empty($installmentAmountGreaterThan))) {
            unset($this->InstallmentAmountGreaterThan);
        } else {
            $this->InstallmentAmountGreaterThan = $installmentAmountGreaterThan;
        }
        return $this;
    }
    /**
     * Get InstallmentAmountLessThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getInstallmentAmountLessThan()
    {
        return isset($this->InstallmentAmountLessThan) ? $this->InstallmentAmountLessThan : null;
    }
    /**
     * Set InstallmentAmountLessThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $installmentAmountLessThan
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setInstallmentAmountLessThan(\patest\StructType\Money $installmentAmountLessThan = null)
    {
        if (is_null($installmentAmountLessThan) || (is_array($installmentAmountLessThan) && empty($installmentAmountLessThan))) {
            unset($this->InstallmentAmountLessThan);
        } else {
            $this->InstallmentAmountLessThan = $installmentAmountLessThan;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodId()
    {
        return isset($this->InstallmentPaymentMethodId) ? $this->InstallmentPaymentMethodId : null;
    }
    /**
     * Set InstallmentPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentMethodId
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setInstallmentPaymentMethodId($installmentPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentMethodId) && !is_string($installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentMethodId, true), gettype($installmentPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentMethodId, true)), __LINE__);
        }
        if (is_null($installmentPaymentMethodId) || (is_array($installmentPaymentMethodId) && empty($installmentPaymentMethodId))) {
            unset($this->InstallmentPaymentMethodId);
        } else {
            $this->InstallmentPaymentMethodId = $installmentPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get InstallmentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentStatus()
    {
        return isset($this->InstallmentStatus) ? $this->InstallmentStatus : null;
    }
    /**
     * Set InstallmentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentStatus::valueIsValid()
     * @uses \patest\EnumType\InstallmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentStatus
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setInstallmentStatus($installmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentStatus::valueIsValid($installmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentStatus', is_array($installmentStatus) ? implode(', ', $installmentStatus) : var_export($installmentStatus, true), implode(', ', \patest\EnumType\InstallmentStatus::getValidValues())), __LINE__);
        }
        if (is_null($installmentStatus) || (is_array($installmentStatus) && empty($installmentStatus))) {
            unset($this->InstallmentStatus);
        } else {
            $this->InstallmentStatus = $installmentStatus;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get PaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanId()
    {
        return isset($this->PaymentPlanId) ? $this->PaymentPlanId : null;
    }
    /**
     * Set PaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanId
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setPaymentPlanId($paymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanId) && !is_string($paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanId, true), gettype($paymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanId, true)), __LINE__);
        }
        if (is_null($paymentPlanId) || (is_array($paymentPlanId) && empty($paymentPlanId))) {
            unset($this->PaymentPlanId);
        } else {
            $this->PaymentPlanId = $paymentPlanId;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_InstallmentFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
