<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.IBANSupportedCountry StructType
 * @subpackage Structs
 */
class Payment_IBANSupportedCountry extends DistributableEntity
{
    /**
     * The AccountNumberLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountNumberLength;
    /**
     * The IsoName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsoName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Payment.IBANSupportedCountry
     * @uses Payment_IBANSupportedCountry::setAccountNumberLength()
     * @uses Payment_IBANSupportedCountry::setIsoName()
     * @uses Payment_IBANSupportedCountry::setName()
     * @param int $accountNumberLength
     * @param string $isoName
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($accountNumberLength = null, $isoName = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setAccountNumberLength($accountNumberLength)
            ->setIsoName($isoName)
            ->setName($name);
    }
    /**
     * Get AccountNumberLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountNumberLength()
    {
        return isset($this->AccountNumberLength) ? $this->AccountNumberLength : null;
    }
    /**
     * Set AccountNumberLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountNumberLength
     * @return \patest\StructType\Payment_IBANSupportedCountry
     */
    public function setAccountNumberLength($accountNumberLength = null)
    {
        // validation for constraint: int
        if (!is_null($accountNumberLength) && !(is_int($accountNumberLength) || ctype_digit($accountNumberLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountNumberLength, true), gettype($accountNumberLength)), __LINE__);
        }
        if (is_null($accountNumberLength) || (is_array($accountNumberLength) && empty($accountNumberLength))) {
            unset($this->AccountNumberLength);
        } else {
            $this->AccountNumberLength = $accountNumberLength;
        }
        return $this;
    }
    /**
     * Get IsoName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsoName()
    {
        return isset($this->IsoName) ? $this->IsoName : null;
    }
    /**
     * Set IsoName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isoName
     * @return \patest\StructType\Payment_IBANSupportedCountry
     */
    public function setIsoName($isoName = null)
    {
        // validation for constraint: string
        if (!is_null($isoName) && !is_string($isoName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isoName, true), gettype($isoName)), __LINE__);
        }
        if (is_null($isoName) || (is_array($isoName) && empty($isoName))) {
            unset($this->IsoName);
        } else {
            $this->IsoName = $isoName;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Payment_IBANSupportedCountry
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
