<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.FailedTransactionForRecovery StructType
 * @subpackage Structs
 */
class Payment_FailedTransactionForRecovery extends PersistableEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The ClientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientEmail;
    /**
     * The ClientFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientFirstName;
    /**
     * The ClientGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientGuid;
    /**
     * The ClientLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientLastName;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DeclineDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclineDate;
    /**
     * The FailedTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FailedTokenId;
    /**
     * The IsRecovered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRecovered;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Purpose;
    /**
     * The RecoveryTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecoveryTransactionId;
    /**
     * The ServiceSpecificIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceSpecificIds;
    /**
     * The ShouldUpdateToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldUpdateToken;
    /**
     * The TransactionDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDescription;
    /**
     * Constructor method for Payment.FailedTransactionForRecovery
     * @uses Payment_FailedTransactionForRecovery::setAmount()
     * @uses Payment_FailedTransactionForRecovery::setClientEmail()
     * @uses Payment_FailedTransactionForRecovery::setClientFirstName()
     * @uses Payment_FailedTransactionForRecovery::setClientGuid()
     * @uses Payment_FailedTransactionForRecovery::setClientLastName()
     * @uses Payment_FailedTransactionForRecovery::setCurrencyCode()
     * @uses Payment_FailedTransactionForRecovery::setDeclineDate()
     * @uses Payment_FailedTransactionForRecovery::setFailedTokenId()
     * @uses Payment_FailedTransactionForRecovery::setIsRecovered()
     * @uses Payment_FailedTransactionForRecovery::setPaymentMethodId()
     * @uses Payment_FailedTransactionForRecovery::setPurpose()
     * @uses Payment_FailedTransactionForRecovery::setRecoveryTransactionId()
     * @uses Payment_FailedTransactionForRecovery::setServiceSpecificIds()
     * @uses Payment_FailedTransactionForRecovery::setShouldUpdateToken()
     * @uses Payment_FailedTransactionForRecovery::setTransactionDescription()
     * @param \patest\StructType\Money $amount
     * @param string $clientEmail
     * @param string $clientFirstName
     * @param string $clientGuid
     * @param string $clientLastName
     * @param string $currencyCode
     * @param string $declineDate
     * @param string $failedTokenId
     * @param bool $isRecovered
     * @param string $paymentMethodId
     * @param string $purpose
     * @param string $recoveryTransactionId
     * @param string $serviceSpecificIds
     * @param bool $shouldUpdateToken
     * @param string $transactionDescription
     */
    public function __construct(\patest\StructType\Money $amount = null, $clientEmail = null, $clientFirstName = null, $clientGuid = null, $clientLastName = null, $currencyCode = null, $declineDate = null, $failedTokenId = null, $isRecovered = null, $paymentMethodId = null, $purpose = null, $recoveryTransactionId = null, $serviceSpecificIds = null, $shouldUpdateToken = null, $transactionDescription = null)
    {
        $this
            ->setAmount($amount)
            ->setClientEmail($clientEmail)
            ->setClientFirstName($clientFirstName)
            ->setClientGuid($clientGuid)
            ->setClientLastName($clientLastName)
            ->setCurrencyCode($currencyCode)
            ->setDeclineDate($declineDate)
            ->setFailedTokenId($failedTokenId)
            ->setIsRecovered($isRecovered)
            ->setPaymentMethodId($paymentMethodId)
            ->setPurpose($purpose)
            ->setRecoveryTransactionId($recoveryTransactionId)
            ->setServiceSpecificIds($serviceSpecificIds)
            ->setShouldUpdateToken($shouldUpdateToken)
            ->setTransactionDescription($transactionDescription);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ClientEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEmail()
    {
        return isset($this->ClientEmail) ? $this->ClientEmail : null;
    }
    /**
     * Set ClientEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEmail
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setClientEmail($clientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($clientEmail) && !is_string($clientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEmail, true), gettype($clientEmail)), __LINE__);
        }
        if (is_null($clientEmail) || (is_array($clientEmail) && empty($clientEmail))) {
            unset($this->ClientEmail);
        } else {
            $this->ClientEmail = $clientEmail;
        }
        return $this;
    }
    /**
     * Get ClientFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientFirstName()
    {
        return isset($this->ClientFirstName) ? $this->ClientFirstName : null;
    }
    /**
     * Set ClientFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientFirstName
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setClientFirstName($clientFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($clientFirstName) && !is_string($clientFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientFirstName, true), gettype($clientFirstName)), __LINE__);
        }
        if (is_null($clientFirstName) || (is_array($clientFirstName) && empty($clientFirstName))) {
            unset($this->ClientFirstName);
        } else {
            $this->ClientFirstName = $clientFirstName;
        }
        return $this;
    }
    /**
     * Get ClientGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientGuid()
    {
        return isset($this->ClientGuid) ? $this->ClientGuid : null;
    }
    /**
     * Set ClientGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientGuid
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setClientGuid($clientGuid = null)
    {
        // validation for constraint: string
        if (!is_null($clientGuid) && !is_string($clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientGuid, true), gettype($clientGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientGuid, true)), __LINE__);
        }
        if (is_null($clientGuid) || (is_array($clientGuid) && empty($clientGuid))) {
            unset($this->ClientGuid);
        } else {
            $this->ClientGuid = $clientGuid;
        }
        return $this;
    }
    /**
     * Get ClientLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientLastName()
    {
        return isset($this->ClientLastName) ? $this->ClientLastName : null;
    }
    /**
     * Set ClientLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientLastName
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setClientLastName($clientLastName = null)
    {
        // validation for constraint: string
        if (!is_null($clientLastName) && !is_string($clientLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLastName, true), gettype($clientLastName)), __LINE__);
        }
        if (is_null($clientLastName) || (is_array($clientLastName) && empty($clientLastName))) {
            unset($this->ClientLastName);
        } else {
            $this->ClientLastName = $clientLastName;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get DeclineDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclineDate()
    {
        return isset($this->DeclineDate) ? $this->DeclineDate : null;
    }
    /**
     * Set DeclineDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declineDate
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setDeclineDate($declineDate = null)
    {
        // validation for constraint: string
        if (!is_null($declineDate) && !is_string($declineDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declineDate, true), gettype($declineDate)), __LINE__);
        }
        if (is_null($declineDate) || (is_array($declineDate) && empty($declineDate))) {
            unset($this->DeclineDate);
        } else {
            $this->DeclineDate = $declineDate;
        }
        return $this;
    }
    /**
     * Get FailedTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailedTokenId()
    {
        return isset($this->FailedTokenId) ? $this->FailedTokenId : null;
    }
    /**
     * Set FailedTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failedTokenId
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setFailedTokenId($failedTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($failedTokenId) && !is_string($failedTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failedTokenId, true), gettype($failedTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($failedTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $failedTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($failedTokenId, true)), __LINE__);
        }
        if (is_null($failedTokenId) || (is_array($failedTokenId) && empty($failedTokenId))) {
            unset($this->FailedTokenId);
        } else {
            $this->FailedTokenId = $failedTokenId;
        }
        return $this;
    }
    /**
     * Get IsRecovered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRecovered()
    {
        return isset($this->IsRecovered) ? $this->IsRecovered : null;
    }
    /**
     * Set IsRecovered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRecovered
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setIsRecovered($isRecovered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecovered) && !is_bool($isRecovered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRecovered, true), gettype($isRecovered)), __LINE__);
        }
        if (is_null($isRecovered) || (is_array($isRecovered) && empty($isRecovered))) {
            unset($this->IsRecovered);
        } else {
            $this->IsRecovered = $isRecovered;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get Purpose value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurpose()
    {
        return isset($this->Purpose) ? $this->Purpose : null;
    }
    /**
     * Set Purpose value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purpose
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        if (is_null($purpose) || (is_array($purpose) && empty($purpose))) {
            unset($this->Purpose);
        } else {
            $this->Purpose = $purpose;
        }
        return $this;
    }
    /**
     * Get RecoveryTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecoveryTransactionId()
    {
        return isset($this->RecoveryTransactionId) ? $this->RecoveryTransactionId : null;
    }
    /**
     * Set RecoveryTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recoveryTransactionId
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setRecoveryTransactionId($recoveryTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($recoveryTransactionId) && !is_string($recoveryTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recoveryTransactionId, true), gettype($recoveryTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recoveryTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recoveryTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recoveryTransactionId, true)), __LINE__);
        }
        if (is_null($recoveryTransactionId) || (is_array($recoveryTransactionId) && empty($recoveryTransactionId))) {
            unset($this->RecoveryTransactionId);
        } else {
            $this->RecoveryTransactionId = $recoveryTransactionId;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificIds()
    {
        return isset($this->ServiceSpecificIds) ? $this->ServiceSpecificIds : null;
    }
    /**
     * Set ServiceSpecificIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificIds
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setServiceSpecificIds($serviceSpecificIds = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificIds) && !is_string($serviceSpecificIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificIds, true), gettype($serviceSpecificIds)), __LINE__);
        }
        if (is_null($serviceSpecificIds) || (is_array($serviceSpecificIds) && empty($serviceSpecificIds))) {
            unset($this->ServiceSpecificIds);
        } else {
            $this->ServiceSpecificIds = $serviceSpecificIds;
        }
        return $this;
    }
    /**
     * Get ShouldUpdateToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldUpdateToken()
    {
        return isset($this->ShouldUpdateToken) ? $this->ShouldUpdateToken : null;
    }
    /**
     * Set ShouldUpdateToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldUpdateToken
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setShouldUpdateToken($shouldUpdateToken = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldUpdateToken) && !is_bool($shouldUpdateToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldUpdateToken, true), gettype($shouldUpdateToken)), __LINE__);
        }
        if (is_null($shouldUpdateToken) || (is_array($shouldUpdateToken) && empty($shouldUpdateToken))) {
            unset($this->ShouldUpdateToken);
        } else {
            $this->ShouldUpdateToken = $shouldUpdateToken;
        }
        return $this;
    }
    /**
     * Get TransactionDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDescription()
    {
        return isset($this->TransactionDescription) ? $this->TransactionDescription : null;
    }
    /**
     * Set TransactionDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDescription
     * @return \patest\StructType\Payment_FailedTransactionForRecovery
     */
    public function setTransactionDescription($transactionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDescription) && !is_string($transactionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDescription, true), gettype($transactionDescription)), __LINE__);
        }
        if (is_null($transactionDescription) || (is_array($transactionDescription) && empty($transactionDescription))) {
            unset($this->TransactionDescription);
        } else {
            $this->TransactionDescription = $transactionDescription;
        }
        return $this;
    }
}
