<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DirectDebitMandateExtended StructType
 * @subpackage Structs
 */
class Payment_DirectDebitMandateExtended extends Payment_DirectDebitMandate
{
    /**
     * The AccountNumberView
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumberView;
    /**
     * The CreatedBy
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedBy;
    /**
     * The MandateTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MandateTypeName;
    /**
     * Constructor method for Payment.DirectDebitMandateExtended
     * @uses Payment_DirectDebitMandateExtended::setAccountNumberView()
     * @uses Payment_DirectDebitMandateExtended::setCreatedBy()
     * @uses Payment_DirectDebitMandateExtended::setMandateTypeName()
     * @param string $accountNumberView
     * @param string $createdBy
     * @param \patest\StructType\GlobalString $mandateTypeName
     */
    public function __construct($accountNumberView = null, $createdBy = null, \patest\StructType\GlobalString $mandateTypeName = null)
    {
        $this
            ->setAccountNumberView($accountNumberView)
            ->setCreatedBy($createdBy)
            ->setMandateTypeName($mandateTypeName);
    }
    /**
     * Get AccountNumberView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumberView()
    {
        return isset($this->AccountNumberView) ? $this->AccountNumberView : null;
    }
    /**
     * Set AccountNumberView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumberView
     * @return \patest\StructType\Payment_DirectDebitMandateExtended
     */
    public function setAccountNumberView($accountNumberView = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumberView) && !is_string($accountNumberView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumberView, true), gettype($accountNumberView)), __LINE__);
        }
        if (is_null($accountNumberView) || (is_array($accountNumberView) && empty($accountNumberView))) {
            unset($this->AccountNumberView);
        } else {
            $this->AccountNumberView = $accountNumberView;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdBy
     * @return \patest\StructType\Payment_DirectDebitMandateExtended
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get MandateTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMandateTypeName()
    {
        return isset($this->MandateTypeName) ? $this->MandateTypeName : null;
    }
    /**
     * Set MandateTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $mandateTypeName
     * @return \patest\StructType\Payment_DirectDebitMandateExtended
     */
    public function setMandateTypeName(\patest\StructType\GlobalString $mandateTypeName = null)
    {
        if (is_null($mandateTypeName) || (is_array($mandateTypeName) && empty($mandateTypeName))) {
            unset($this->MandateTypeName);
        } else {
            $this->MandateTypeName = $mandateTypeName;
        }
        return $this;
    }
}
