<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DepositCategory StructType
 * @subpackage Structs
 */
class Payment_DepositCategory extends Payment_BaseClientCreditCategory
{
    /**
     * The CrmClientUsage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CrmClientUsage;
    /**
     * Constructor method for Payment.DepositCategory
     * @uses Payment_DepositCategory::setCrmClientUsage()
     * @param string[] $crmClientUsage
     */
    public function __construct(array $crmClientUsage = array())
    {
        $this
            ->setCrmClientUsage($crmClientUsage);
    }
    /**
     * Get CrmClientUsage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCrmClientUsage()
    {
        return isset($this->CrmClientUsage) ? $this->CrmClientUsage : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCrmClientUsage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCrmClientUsage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCrmClientUsageForArrayConstraintsFromSetCrmClientUsage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payment_DepositCategoryCrmClientUsageItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($payment_DepositCategoryCrmClientUsageItem)) {
                $invalidValues[] = is_object($payment_DepositCategoryCrmClientUsageItem) ? get_class($payment_DepositCategoryCrmClientUsageItem) : sprintf('%s(%s)', gettype($payment_DepositCategoryCrmClientUsageItem), var_export($payment_DepositCategoryCrmClientUsageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CrmClientUsage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $crmClientUsage
     * @return \patest\StructType\Payment_DepositCategory
     */
    public function setCrmClientUsage(array $crmClientUsage = array())
    {
        // validation for constraint: list
        if ('' !== ($crmClientUsageArrayErrorMessage = self::validateCrmClientUsageForArrayConstraintsFromSetCrmClientUsage($crmClientUsage))) {
            throw new \InvalidArgumentException($crmClientUsageArrayErrorMessage, __LINE__);
        }
        if (is_null($crmClientUsage) || (is_array($crmClientUsage) && empty($crmClientUsage))) {
            unset($this->CrmClientUsage);
        } else {
            $this->CrmClientUsage = is_array($crmClientUsage) ? implode(' ', $crmClientUsage) : null;
        }
        return $this;
    }
}
