<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.CurrencyDenominations StructType
 * @subpackage Structs
 */
class Payment_CurrencyDenominations extends AnyEntity
{
    /**
     * The Denominations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_MoneyDenomination
     */
    public $Denominations;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Payment.CurrencyDenominations
     * @uses Payment_CurrencyDenominations::setDenominations()
     * @uses Payment_CurrencyDenominations::setHolderCompanyId()
     * @uses Payment_CurrencyDenominations::setId()
     * @param \patest\StructType\RecordSetOfPayment_MoneyDenomination $denominations
     * @param int $holderCompanyId
     * @param string $id
     */
    public function __construct(\patest\StructType\RecordSetOfPayment_MoneyDenomination $denominations = null, $holderCompanyId = null, $id = null)
    {
        $this
            ->setDenominations($denominations)
            ->setHolderCompanyId($holderCompanyId)
            ->setId($id);
    }
    /**
     * Get Denominations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_MoneyDenomination|null
     */
    public function getDenominations()
    {
        return isset($this->Denominations) ? $this->Denominations : null;
    }
    /**
     * Set Denominations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_MoneyDenomination $denominations
     * @return \patest\StructType\Payment_CurrencyDenominations
     */
    public function setDenominations(\patest\StructType\RecordSetOfPayment_MoneyDenomination $denominations = null)
    {
        if (is_null($denominations) || (is_array($denominations) && empty($denominations))) {
            unset($this->Denominations);
        } else {
            $this->Denominations = $denominations;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Payment_CurrencyDenominations
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Payment_CurrencyDenominations
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
}
