<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.CreditCompanyTransferDetail StructType
 * @subpackage Structs
 */
class Payment_CreditCompanyTransferDetail extends PersistableEntity
{
    /**
     * The CreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCompanyId;
    /**
     * The StartDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartDay;
    /**
     * The TransferDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransferDay;
    /**
     * The UntilDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UntilDay;
    /**
     * Constructor method for Payment.CreditCompanyTransferDetail
     * @uses Payment_CreditCompanyTransferDetail::setCreditCompanyId()
     * @uses Payment_CreditCompanyTransferDetail::setStartDay()
     * @uses Payment_CreditCompanyTransferDetail::setTransferDay()
     * @uses Payment_CreditCompanyTransferDetail::setUntilDay()
     * @param string $creditCompanyId
     * @param int $startDay
     * @param int $transferDay
     * @param int $untilDay
     */
    public function __construct($creditCompanyId = null, $startDay = null, $transferDay = null, $untilDay = null)
    {
        $this
            ->setCreditCompanyId($creditCompanyId)
            ->setStartDay($startDay)
            ->setTransferDay($transferDay)
            ->setUntilDay($untilDay);
    }
    /**
     * Get CreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCompanyId()
    {
        return isset($this->CreditCompanyId) ? $this->CreditCompanyId : null;
    }
    /**
     * Set CreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCompanyId
     * @return \patest\StructType\Payment_CreditCompanyTransferDetail
     */
    public function setCreditCompanyId($creditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($creditCompanyId) && !is_string($creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCompanyId, true), gettype($creditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCompanyId, true)), __LINE__);
        }
        if (is_null($creditCompanyId) || (is_array($creditCompanyId) && empty($creditCompanyId))) {
            unset($this->CreditCompanyId);
        } else {
            $this->CreditCompanyId = $creditCompanyId;
        }
        return $this;
    }
    /**
     * Get StartDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartDay()
    {
        return isset($this->StartDay) ? $this->StartDay : null;
    }
    /**
     * Set StartDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startDay
     * @return \patest\StructType\Payment_CreditCompanyTransferDetail
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: int
        if (!is_null($startDay) && !(is_int($startDay) || ctype_digit($startDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startDay, true), gettype($startDay)), __LINE__);
        }
        if (is_null($startDay) || (is_array($startDay) && empty($startDay))) {
            unset($this->StartDay);
        } else {
            $this->StartDay = $startDay;
        }
        return $this;
    }
    /**
     * Get TransferDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransferDay()
    {
        return isset($this->TransferDay) ? $this->TransferDay : null;
    }
    /**
     * Set TransferDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transferDay
     * @return \patest\StructType\Payment_CreditCompanyTransferDetail
     */
    public function setTransferDay($transferDay = null)
    {
        // validation for constraint: int
        if (!is_null($transferDay) && !(is_int($transferDay) || ctype_digit($transferDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transferDay, true), gettype($transferDay)), __LINE__);
        }
        if (is_null($transferDay) || (is_array($transferDay) && empty($transferDay))) {
            unset($this->TransferDay);
        } else {
            $this->TransferDay = $transferDay;
        }
        return $this;
    }
    /**
     * Get UntilDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUntilDay()
    {
        return isset($this->UntilDay) ? $this->UntilDay : null;
    }
    /**
     * Set UntilDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $untilDay
     * @return \patest\StructType\Payment_CreditCompanyTransferDetail
     */
    public function setUntilDay($untilDay = null)
    {
        // validation for constraint: int
        if (!is_null($untilDay) && !(is_int($untilDay) || ctype_digit($untilDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($untilDay, true), gettype($untilDay)), __LINE__);
        }
        if (is_null($untilDay) || (is_array($untilDay) && empty($untilDay))) {
            unset($this->UntilDay);
        } else {
            $this->UntilDay = $untilDay;
        }
        return $this;
    }
}
