<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.CreditCompany StructType
 * @subpackage Structs
 */
class Payment_CreditCompany extends DistributableEntity
{
    /**
     * The CardTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_CreditCardType
     */
    public $CardTypes;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Commission;
    /**
     * The CompanyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CompanyNumber;
    /**
     * The CreditCompanyIcon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreditCompanyIcon;
    /**
     * The EffectiveImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveImageUrl;
    /**
     * The GlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GlobalName;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The TransferDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_CreditCompanyTransferDetail
     */
    public $TransferDetails;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Payment.CreditCompany
     * @uses Payment_CreditCompany::setCardTypes()
     * @uses Payment_CreditCompany::setCommission()
     * @uses Payment_CreditCompany::setCompanyNumber()
     * @uses Payment_CreditCompany::setCreditCompanyIcon()
     * @uses Payment_CreditCompany::setEffectiveImageUrl()
     * @uses Payment_CreditCompany::setGlobalName()
     * @uses Payment_CreditCompany::setLedgerId()
     * @uses Payment_CreditCompany::setOrganizationUnitId()
     * @uses Payment_CreditCompany::setProjectIdentifierId()
     * @uses Payment_CreditCompany::setTransferDetails()
     * @uses Payment_CreditCompany::setVisibleBySubordinates()
     * @param \patest\StructType\RecordSetOfPayment_CreditCardType $cardTypes
     * @param float $commission
     * @param int $companyNumber
     * @param int $creditCompanyIcon
     * @param string $effectiveImageUrl
     * @param \patest\StructType\GlobalString $globalName
     * @param string $ledgerId
     * @param string $organizationUnitId
     * @param string $projectIdentifierId
     * @param \patest\StructType\RecordSetOfPayment_CreditCompanyTransferDetail $transferDetails
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\RecordSetOfPayment_CreditCardType $cardTypes = null, $commission = null, $companyNumber = null, $creditCompanyIcon = null, $effectiveImageUrl = null, \patest\StructType\GlobalString $globalName = null, $ledgerId = null, $organizationUnitId = null, $projectIdentifierId = null, \patest\StructType\RecordSetOfPayment_CreditCompanyTransferDetail $transferDetails = null, $visibleBySubordinates = null)
    {
        $this
            ->setCardTypes($cardTypes)
            ->setCommission($commission)
            ->setCompanyNumber($companyNumber)
            ->setCreditCompanyIcon($creditCompanyIcon)
            ->setEffectiveImageUrl($effectiveImageUrl)
            ->setGlobalName($globalName)
            ->setLedgerId($ledgerId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setTransferDetails($transferDetails)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get CardTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_CreditCardType|null
     */
    public function getCardTypes()
    {
        return isset($this->CardTypes) ? $this->CardTypes : null;
    }
    /**
     * Set CardTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_CreditCardType $cardTypes
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setCardTypes(\patest\StructType\RecordSetOfPayment_CreditCardType $cardTypes = null)
    {
        if (is_null($cardTypes) || (is_array($cardTypes) && empty($cardTypes))) {
            unset($this->CardTypes);
        } else {
            $this->CardTypes = $cardTypes;
        }
        return $this;
    }
    /**
     * Get Commission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCommission()
    {
        return isset($this->Commission) ? $this->Commission : null;
    }
    /**
     * Set Commission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $commission
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        if (is_null($commission) || (is_array($commission) && empty($commission))) {
            unset($this->Commission);
        } else {
            $this->Commission = $commission;
        }
        return $this;
    }
    /**
     * Get CompanyNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCompanyNumber()
    {
        return isset($this->CompanyNumber) ? $this->CompanyNumber : null;
    }
    /**
     * Set CompanyNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $companyNumber
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setCompanyNumber($companyNumber = null)
    {
        // validation for constraint: int
        if (!is_null($companyNumber) && !(is_int($companyNumber) || ctype_digit($companyNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyNumber, true), gettype($companyNumber)), __LINE__);
        }
        if (is_null($companyNumber) || (is_array($companyNumber) && empty($companyNumber))) {
            unset($this->CompanyNumber);
        } else {
            $this->CompanyNumber = $companyNumber;
        }
        return $this;
    }
    /**
     * Get CreditCompanyIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreditCompanyIcon()
    {
        return isset($this->CreditCompanyIcon) ? $this->CreditCompanyIcon : null;
    }
    /**
     * Set CreditCompanyIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creditCompanyIcon
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setCreditCompanyIcon($creditCompanyIcon = null)
    {
        // validation for constraint: int
        if (!is_null($creditCompanyIcon) && !(is_int($creditCompanyIcon) || ctype_digit($creditCompanyIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditCompanyIcon, true), gettype($creditCompanyIcon)), __LINE__);
        }
        if (is_null($creditCompanyIcon) || (is_array($creditCompanyIcon) && empty($creditCompanyIcon))) {
            unset($this->CreditCompanyIcon);
        } else {
            $this->CreditCompanyIcon = $creditCompanyIcon;
        }
        return $this;
    }
    /**
     * Get EffectiveImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveImageUrl()
    {
        return isset($this->EffectiveImageUrl) ? $this->EffectiveImageUrl : null;
    }
    /**
     * Set EffectiveImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveImageUrl
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setEffectiveImageUrl($effectiveImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveImageUrl) && !is_string($effectiveImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveImageUrl, true), gettype($effectiveImageUrl)), __LINE__);
        }
        if (is_null($effectiveImageUrl) || (is_array($effectiveImageUrl) && empty($effectiveImageUrl))) {
            unset($this->EffectiveImageUrl);
        } else {
            $this->EffectiveImageUrl = $effectiveImageUrl;
        }
        return $this;
    }
    /**
     * Get GlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGlobalName()
    {
        return isset($this->GlobalName) ? $this->GlobalName : null;
    }
    /**
     * Set GlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $globalName
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setGlobalName(\patest\StructType\GlobalString $globalName = null)
    {
        if (is_null($globalName) || (is_array($globalName) && empty($globalName))) {
            unset($this->GlobalName);
        } else {
            $this->GlobalName = $globalName;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get TransferDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_CreditCompanyTransferDetail|null
     */
    public function getTransferDetails()
    {
        return isset($this->TransferDetails) ? $this->TransferDetails : null;
    }
    /**
     * Set TransferDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_CreditCompanyTransferDetail $transferDetails
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setTransferDetails(\patest\StructType\RecordSetOfPayment_CreditCompanyTransferDetail $transferDetails = null)
    {
        if (is_null($transferDetails) || (is_array($transferDetails) && empty($transferDetails))) {
            unset($this->TransferDetails);
        } else {
            $this->TransferDetails = $transferDetails;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Payment_CreditCompany
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
