<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.CreditCardType StructType
 * @subpackage Structs
 */
class Payment_CreditCardType extends PersistableEntity
{
    /**
     * The BINCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BINCodes;
    /**
     * The BINCodesCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BINCodesCount;
    /**
     * The BINCodesText
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BINCodesText;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The CreditCardTypeKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardTypeKind;
    /**
     * The CreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCompanyId;
    /**
     * Constructor method for Payment.CreditCardType
     * @uses Payment_CreditCardType::setBINCodes()
     * @uses Payment_CreditCardType::setBINCodesCount()
     * @uses Payment_CreditCardType::setBINCodesText()
     * @uses Payment_CreditCardType::setCardType()
     * @uses Payment_CreditCardType::setCreditCardTypeKind()
     * @uses Payment_CreditCardType::setCreditCompanyId()
     * @param string $bINCodes
     * @param int $bINCodesCount
     * @param string $bINCodesText
     * @param string $cardType
     * @param string $creditCardTypeKind
     * @param string $creditCompanyId
     */
    public function __construct($bINCodes = null, $bINCodesCount = null, $bINCodesText = null, $cardType = null, $creditCardTypeKind = null, $creditCompanyId = null)
    {
        $this
            ->setBINCodes($bINCodes)
            ->setBINCodesCount($bINCodesCount)
            ->setBINCodesText($bINCodesText)
            ->setCardType($cardType)
            ->setCreditCardTypeKind($creditCardTypeKind)
            ->setCreditCompanyId($creditCompanyId);
    }
    /**
     * Get BINCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBINCodes()
    {
        return isset($this->BINCodes) ? $this->BINCodes : null;
    }
    /**
     * Set BINCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bINCodes
     * @return \patest\StructType\Payment_CreditCardType
     */
    public function setBINCodes($bINCodes = null)
    {
        // validation for constraint: string
        if (!is_null($bINCodes) && !is_string($bINCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bINCodes, true), gettype($bINCodes)), __LINE__);
        }
        if (is_null($bINCodes) || (is_array($bINCodes) && empty($bINCodes))) {
            unset($this->BINCodes);
        } else {
            $this->BINCodes = $bINCodes;
        }
        return $this;
    }
    /**
     * Get BINCodesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBINCodesCount()
    {
        return isset($this->BINCodesCount) ? $this->BINCodesCount : null;
    }
    /**
     * Set BINCodesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bINCodesCount
     * @return \patest\StructType\Payment_CreditCardType
     */
    public function setBINCodesCount($bINCodesCount = null)
    {
        // validation for constraint: int
        if (!is_null($bINCodesCount) && !(is_int($bINCodesCount) || ctype_digit($bINCodesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bINCodesCount, true), gettype($bINCodesCount)), __LINE__);
        }
        if (is_null($bINCodesCount) || (is_array($bINCodesCount) && empty($bINCodesCount))) {
            unset($this->BINCodesCount);
        } else {
            $this->BINCodesCount = $bINCodesCount;
        }
        return $this;
    }
    /**
     * Get BINCodesText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBINCodesText()
    {
        return isset($this->BINCodesText) ? $this->BINCodesText : null;
    }
    /**
     * Set BINCodesText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bINCodesText
     * @return \patest\StructType\Payment_CreditCardType
     */
    public function setBINCodesText($bINCodesText = null)
    {
        // validation for constraint: string
        if (!is_null($bINCodesText) && !is_string($bINCodesText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bINCodesText, true), gettype($bINCodesText)), __LINE__);
        }
        if (is_null($bINCodesText) || (is_array($bINCodesText) && empty($bINCodesText))) {
            unset($this->BINCodesText);
        } else {
            $this->BINCodesText = $bINCodesText;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardType
     * @return \patest\StructType\Payment_CreditCardType
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get CreditCardTypeKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardTypeKind()
    {
        return isset($this->CreditCardTypeKind) ? $this->CreditCardTypeKind : null;
    }
    /**
     * Set CreditCardTypeKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CreditCardTypeKind::valueIsValid()
     * @uses \patest\EnumType\CreditCardTypeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCardTypeKind
     * @return \patest\StructType\Payment_CreditCardType
     */
    public function setCreditCardTypeKind($creditCardTypeKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CreditCardTypeKind::valueIsValid($creditCardTypeKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CreditCardTypeKind', is_array($creditCardTypeKind) ? implode(', ', $creditCardTypeKind) : var_export($creditCardTypeKind, true), implode(', ', \patest\EnumType\CreditCardTypeKind::getValidValues())), __LINE__);
        }
        if (is_null($creditCardTypeKind) || (is_array($creditCardTypeKind) && empty($creditCardTypeKind))) {
            unset($this->CreditCardTypeKind);
        } else {
            $this->CreditCardTypeKind = $creditCardTypeKind;
        }
        return $this;
    }
    /**
     * Get CreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCompanyId()
    {
        return isset($this->CreditCompanyId) ? $this->CreditCompanyId : null;
    }
    /**
     * Set CreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCompanyId
     * @return \patest\StructType\Payment_CreditCardType
     */
    public function setCreditCompanyId($creditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($creditCompanyId) && !is_string($creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCompanyId, true), gettype($creditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCompanyId, true)), __LINE__);
        }
        if (is_null($creditCompanyId) || (is_array($creditCompanyId) && empty($creditCompanyId))) {
            unset($this->CreditCompanyId);
        } else {
            $this->CreditCompanyId = $creditCompanyId;
        }
        return $this;
    }
}
