<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.ClientCreditUtilization StructType
 * @subpackage Structs
 */
class Payment_ClientCreditUtilization extends PersistableEntity
{
    /**
     * The ByTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ByTransaction;
    /**
     * The ClientCreditItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientCreditItemId;
    /**
     * The CompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmount;
    /**
     * The CompanyCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencyCode;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The SiteAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SiteAmount;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Payment.ClientCreditUtilization
     * @uses Payment_ClientCreditUtilization::setByTransaction()
     * @uses Payment_ClientCreditUtilization::setClientCreditItemId()
     * @uses Payment_ClientCreditUtilization::setCompanyAmount()
     * @uses Payment_ClientCreditUtilization::setCompanyCurrencyCode()
     * @uses Payment_ClientCreditUtilization::setPaymentItemId()
     * @uses Payment_ClientCreditUtilization::setSiteAmount()
     * @uses Payment_ClientCreditUtilization::setSiteCurrencyCode()
     * @uses Payment_ClientCreditUtilization::setTransactionGuid()
     * @param bool $byTransaction
     * @param string $clientCreditItemId
     * @param \patest\StructType\Money $companyAmount
     * @param string $companyCurrencyCode
     * @param string $paymentItemId
     * @param \patest\StructType\Money $siteAmount
     * @param string $siteCurrencyCode
     * @param string $transactionGuid
     */
    public function __construct($byTransaction = null, $clientCreditItemId = null, \patest\StructType\Money $companyAmount = null, $companyCurrencyCode = null, $paymentItemId = null, \patest\StructType\Money $siteAmount = null, $siteCurrencyCode = null, $transactionGuid = null)
    {
        $this
            ->setByTransaction($byTransaction)
            ->setClientCreditItemId($clientCreditItemId)
            ->setCompanyAmount($companyAmount)
            ->setCompanyCurrencyCode($companyCurrencyCode)
            ->setPaymentItemId($paymentItemId)
            ->setSiteAmount($siteAmount)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ByTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getByTransaction()
    {
        return isset($this->ByTransaction) ? $this->ByTransaction : null;
    }
    /**
     * Set ByTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $byTransaction
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setByTransaction($byTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($byTransaction) && !is_bool($byTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($byTransaction, true), gettype($byTransaction)), __LINE__);
        }
        if (is_null($byTransaction) || (is_array($byTransaction) && empty($byTransaction))) {
            unset($this->ByTransaction);
        } else {
            $this->ByTransaction = $byTransaction;
        }
        return $this;
    }
    /**
     * Get ClientCreditItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCreditItemId()
    {
        return isset($this->ClientCreditItemId) ? $this->ClientCreditItemId : null;
    }
    /**
     * Set ClientCreditItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCreditItemId
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setClientCreditItemId($clientCreditItemId = null)
    {
        // validation for constraint: string
        if (!is_null($clientCreditItemId) && !is_string($clientCreditItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCreditItemId, true), gettype($clientCreditItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientCreditItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientCreditItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientCreditItemId, true)), __LINE__);
        }
        if (is_null($clientCreditItemId) || (is_array($clientCreditItemId) && empty($clientCreditItemId))) {
            unset($this->ClientCreditItemId);
        } else {
            $this->ClientCreditItemId = $clientCreditItemId;
        }
        return $this;
    }
    /**
     * Get CompanyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmount()
    {
        return isset($this->CompanyAmount) ? $this->CompanyAmount : null;
    }
    /**
     * Set CompanyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmount
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setCompanyAmount(\patest\StructType\Money $companyAmount = null)
    {
        if (is_null($companyAmount) || (is_array($companyAmount) && empty($companyAmount))) {
            unset($this->CompanyAmount);
        } else {
            $this->CompanyAmount = $companyAmount;
        }
        return $this;
    }
    /**
     * Get CompanyCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencyCode()
    {
        return isset($this->CompanyCurrencyCode) ? $this->CompanyCurrencyCode : null;
    }
    /**
     * Set CompanyCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencyCode
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setCompanyCurrencyCode($companyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencyCode) && !is_string($companyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencyCode, true), gettype($companyCurrencyCode)), __LINE__);
        }
        if (is_null($companyCurrencyCode) || (is_array($companyCurrencyCode) && empty($companyCurrencyCode))) {
            unset($this->CompanyCurrencyCode);
        } else {
            $this->CompanyCurrencyCode = $companyCurrencyCode;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get SiteAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmount()
    {
        return isset($this->SiteAmount) ? $this->SiteAmount : null;
    }
    /**
     * Set SiteAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $siteAmount
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setSiteAmount(\patest\StructType\Money $siteAmount = null)
    {
        if (is_null($siteAmount) || (is_array($siteAmount) && empty($siteAmount))) {
            unset($this->SiteAmount);
        } else {
            $this->SiteAmount = $siteAmount;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_ClientCreditUtilization
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
