<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.ClientCreditCategory StructType
 * @subpackage Structs
 */
class Payment_ClientCreditCategory extends Payment_BaseClientCreditCategory
{
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The ExpirationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExpirationDays;
    /**
     * Constructor method for Payment.ClientCreditCategory
     * @uses Payment_ClientCreditCategory::setExpirationDate()
     * @uses Payment_ClientCreditCategory::setExpirationDays()
     * @param string $expirationDate
     * @param int $expirationDays
     */
    public function __construct($expirationDate = null, $expirationDays = null)
    {
        $this
            ->setExpirationDate($expirationDate)
            ->setExpirationDays($expirationDays);
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDate
     * @return \patest\StructType\Payment_ClientCreditCategory
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get ExpirationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpirationDays()
    {
        return isset($this->ExpirationDays) ? $this->ExpirationDays : null;
    }
    /**
     * Set ExpirationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expirationDays
     * @return \patest\StructType\Payment_ClientCreditCategory
     */
    public function setExpirationDays($expirationDays = null)
    {
        // validation for constraint: int
        if (!is_null($expirationDays) && !(is_int($expirationDays) || ctype_digit($expirationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expirationDays, true), gettype($expirationDays)), __LINE__);
        }
        if (is_null($expirationDays) || (is_array($expirationDays) && empty($expirationDays))) {
            unset($this->ExpirationDays);
        } else {
            $this->ExpirationDays = $expirationDays;
        }
        return $this;
    }
}
