<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.ClientCreditCardToken StructType
 * @subpackage Structs
 */
class Payment_ClientCreditCardToken extends PersistableEntity
{
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardNumberMask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumberMask;
    /**
     * The CardPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardPrefix;
    /**
     * The CardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardSuffix;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreatedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCompanyId;
    /**
     * The CreditCompanyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CreditCompanyName;
    /**
     * The CustomName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomName;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The ExpiryMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryMonth;
    /**
     * The ExpiryYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryYear;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsUsable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUsable;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The ProviderCreditCompanyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderCreditCompanyCode;
    /**
     * The ProviderCreditCompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderCreditCompanyName;
    /**
     * Constructor method for Payment.ClientCreditCardToken
     * @uses Payment_ClientCreditCardToken::setCardHolderName()
     * @uses Payment_ClientCreditCardToken::setCardNumberMask()
     * @uses Payment_ClientCreditCardToken::setCardPrefix()
     * @uses Payment_ClientCreditCardToken::setCardSuffix()
     * @uses Payment_ClientCreditCardToken::setClientId()
     * @uses Payment_ClientCreditCardToken::setCreatedDate()
     * @uses Payment_ClientCreditCardToken::setCreditCompanyId()
     * @uses Payment_ClientCreditCardToken::setCreditCompanyName()
     * @uses Payment_ClientCreditCardToken::setCustomName()
     * @uses Payment_ClientCreditCardToken::setExpirationDate()
     * @uses Payment_ClientCreditCardToken::setExpiryMonth()
     * @uses Payment_ClientCreditCardToken::setExpiryYear()
     * @uses Payment_ClientCreditCardToken::setIsActive()
     * @uses Payment_ClientCreditCardToken::setIsUsable()
     * @uses Payment_ClientCreditCardToken::setPaymentMethodId()
     * @uses Payment_ClientCreditCardToken::setProviderCreditCompanyCode()
     * @uses Payment_ClientCreditCardToken::setProviderCreditCompanyName()
     * @param string $cardHolderName
     * @param string $cardNumberMask
     * @param string $cardPrefix
     * @param string $cardSuffix
     * @param string $clientId
     * @param string $createdDate
     * @param string $creditCompanyId
     * @param \patest\StructType\GlobalString $creditCompanyName
     * @param string $customName
     * @param string $expirationDate
     * @param string $expiryMonth
     * @param string $expiryYear
     * @param bool $isActive
     * @param bool $isUsable
     * @param string $paymentMethodId
     * @param string $providerCreditCompanyCode
     * @param string $providerCreditCompanyName
     */
    public function __construct($cardHolderName = null, $cardNumberMask = null, $cardPrefix = null, $cardSuffix = null, $clientId = null, $createdDate = null, $creditCompanyId = null, \patest\StructType\GlobalString $creditCompanyName = null, $customName = null, $expirationDate = null, $expiryMonth = null, $expiryYear = null, $isActive = null, $isUsable = null, $paymentMethodId = null, $providerCreditCompanyCode = null, $providerCreditCompanyName = null)
    {
        $this
            ->setCardHolderName($cardHolderName)
            ->setCardNumberMask($cardNumberMask)
            ->setCardPrefix($cardPrefix)
            ->setCardSuffix($cardSuffix)
            ->setClientId($clientId)
            ->setCreatedDate($createdDate)
            ->setCreditCompanyId($creditCompanyId)
            ->setCreditCompanyName($creditCompanyName)
            ->setCustomName($customName)
            ->setExpirationDate($expirationDate)
            ->setExpiryMonth($expiryMonth)
            ->setExpiryYear($expiryYear)
            ->setIsActive($isActive)
            ->setIsUsable($isUsable)
            ->setPaymentMethodId($paymentMethodId)
            ->setProviderCreditCompanyCode($providerCreditCompanyCode)
            ->setProviderCreditCompanyName($providerCreditCompanyName);
    }
    /**
     * Get CardHolderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHolderName()
    {
        return isset($this->CardHolderName) ? $this->CardHolderName : null;
    }
    /**
     * Set CardHolderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHolderName
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        if (is_null($cardHolderName) || (is_array($cardHolderName) && empty($cardHolderName))) {
            unset($this->CardHolderName);
        } else {
            $this->CardHolderName = $cardHolderName;
        }
        return $this;
    }
    /**
     * Get CardNumberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumberMask()
    {
        return isset($this->CardNumberMask) ? $this->CardNumberMask : null;
    }
    /**
     * Set CardNumberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumberMask
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCardNumberMask($cardNumberMask = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberMask) && !is_string($cardNumberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberMask, true), gettype($cardNumberMask)), __LINE__);
        }
        if (is_null($cardNumberMask) || (is_array($cardNumberMask) && empty($cardNumberMask))) {
            unset($this->CardNumberMask);
        } else {
            $this->CardNumberMask = $cardNumberMask;
        }
        return $this;
    }
    /**
     * Get CardPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardPrefix()
    {
        return isset($this->CardPrefix) ? $this->CardPrefix : null;
    }
    /**
     * Set CardPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardPrefix
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCardPrefix($cardPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($cardPrefix) && !is_string($cardPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardPrefix, true), gettype($cardPrefix)), __LINE__);
        }
        if (is_null($cardPrefix) || (is_array($cardPrefix) && empty($cardPrefix))) {
            unset($this->CardPrefix);
        } else {
            $this->CardPrefix = $cardPrefix;
        }
        return $this;
    }
    /**
     * Get CardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardSuffix()
    {
        return isset($this->CardSuffix) ? $this->CardSuffix : null;
    }
    /**
     * Set CardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardSuffix
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCardSuffix($cardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($cardSuffix) && !is_string($cardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardSuffix, true), gettype($cardSuffix)), __LINE__);
        }
        if (is_null($cardSuffix) || (is_array($cardSuffix) && empty($cardSuffix))) {
            unset($this->CardSuffix);
        } else {
            $this->CardSuffix = $cardSuffix;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCompanyId()
    {
        return isset($this->CreditCompanyId) ? $this->CreditCompanyId : null;
    }
    /**
     * Set CreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCompanyId
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCreditCompanyId($creditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($creditCompanyId) && !is_string($creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCompanyId, true), gettype($creditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCompanyId, true)), __LINE__);
        }
        if (is_null($creditCompanyId) || (is_array($creditCompanyId) && empty($creditCompanyId))) {
            unset($this->CreditCompanyId);
        } else {
            $this->CreditCompanyId = $creditCompanyId;
        }
        return $this;
    }
    /**
     * Get CreditCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCreditCompanyName()
    {
        return isset($this->CreditCompanyName) ? $this->CreditCompanyName : null;
    }
    /**
     * Set CreditCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $creditCompanyName
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCreditCompanyName(\patest\StructType\GlobalString $creditCompanyName = null)
    {
        if (is_null($creditCompanyName) || (is_array($creditCompanyName) && empty($creditCompanyName))) {
            unset($this->CreditCompanyName);
        } else {
            $this->CreditCompanyName = $creditCompanyName;
        }
        return $this;
    }
    /**
     * Get CustomName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomName()
    {
        return isset($this->CustomName) ? $this->CustomName : null;
    }
    /**
     * Set CustomName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customName
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setCustomName($customName = null)
    {
        // validation for constraint: string
        if (!is_null($customName) && !is_string($customName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customName, true), gettype($customName)), __LINE__);
        }
        if (is_null($customName) || (is_array($customName) && empty($customName))) {
            unset($this->CustomName);
        } else {
            $this->CustomName = $customName;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDate
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get ExpiryMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryMonth()
    {
        return isset($this->ExpiryMonth) ? $this->ExpiryMonth : null;
    }
    /**
     * Set ExpiryMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryMonth
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setExpiryMonth($expiryMonth = null)
    {
        // validation for constraint: string
        if (!is_null($expiryMonth) && !is_string($expiryMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryMonth, true), gettype($expiryMonth)), __LINE__);
        }
        if (is_null($expiryMonth) || (is_array($expiryMonth) && empty($expiryMonth))) {
            unset($this->ExpiryMonth);
        } else {
            $this->ExpiryMonth = $expiryMonth;
        }
        return $this;
    }
    /**
     * Get ExpiryYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryYear()
    {
        return isset($this->ExpiryYear) ? $this->ExpiryYear : null;
    }
    /**
     * Set ExpiryYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryYear
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setExpiryYear($expiryYear = null)
    {
        // validation for constraint: string
        if (!is_null($expiryYear) && !is_string($expiryYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryYear, true), gettype($expiryYear)), __LINE__);
        }
        if (is_null($expiryYear) || (is_array($expiryYear) && empty($expiryYear))) {
            unset($this->ExpiryYear);
        } else {
            $this->ExpiryYear = $expiryYear;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsUsable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUsable()
    {
        return isset($this->IsUsable) ? $this->IsUsable : null;
    }
    /**
     * Set IsUsable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUsable
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setIsUsable($isUsable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsable) && !is_bool($isUsable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUsable, true), gettype($isUsable)), __LINE__);
        }
        if (is_null($isUsable) || (is_array($isUsable) && empty($isUsable))) {
            unset($this->IsUsable);
        } else {
            $this->IsUsable = $isUsable;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get ProviderCreditCompanyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderCreditCompanyCode()
    {
        return isset($this->ProviderCreditCompanyCode) ? $this->ProviderCreditCompanyCode : null;
    }
    /**
     * Set ProviderCreditCompanyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerCreditCompanyCode
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setProviderCreditCompanyCode($providerCreditCompanyCode = null)
    {
        // validation for constraint: string
        if (!is_null($providerCreditCompanyCode) && !is_string($providerCreditCompanyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerCreditCompanyCode, true), gettype($providerCreditCompanyCode)), __LINE__);
        }
        if (is_null($providerCreditCompanyCode) || (is_array($providerCreditCompanyCode) && empty($providerCreditCompanyCode))) {
            unset($this->ProviderCreditCompanyCode);
        } else {
            $this->ProviderCreditCompanyCode = $providerCreditCompanyCode;
        }
        return $this;
    }
    /**
     * Get ProviderCreditCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderCreditCompanyName()
    {
        return isset($this->ProviderCreditCompanyName) ? $this->ProviderCreditCompanyName : null;
    }
    /**
     * Set ProviderCreditCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerCreditCompanyName
     * @return \patest\StructType\Payment_ClientCreditCardToken
     */
    public function setProviderCreditCompanyName($providerCreditCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($providerCreditCompanyName) && !is_string($providerCreditCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerCreditCompanyName, true), gettype($providerCreditCompanyName)), __LINE__);
        }
        if (is_null($providerCreditCompanyName) || (is_array($providerCreditCompanyName) && empty($providerCreditCompanyName))) {
            unset($this->ProviderCreditCompanyName);
        } else {
            $this->ProviderCreditCompanyName = $providerCreditCompanyName;
        }
        return $this;
    }
}
