<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.ClientCreditCardPaymentTokenExtended StructType
 * @subpackage Structs
 */
class Payment_ClientCreditCardPaymentTokenExtended extends Payment_ClientCreditCardToken
{
    /**
     * The CardDisplayText
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardDisplayText;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * Constructor method for Payment.ClientCreditCardPaymentTokenExtended
     * @uses Payment_ClientCreditCardPaymentTokenExtended::setCardDisplayText()
     * @uses Payment_ClientCreditCardPaymentTokenExtended::setCardNumber()
     * @uses Payment_ClientCreditCardPaymentTokenExtended::setClientName()
     * @uses Payment_ClientCreditCardPaymentTokenExtended::setExpiryDate()
     * @param string $cardDisplayText
     * @param string $cardNumber
     * @param string $clientName
     * @param string $expiryDate
     */
    public function __construct($cardDisplayText = null, $cardNumber = null, $clientName = null, $expiryDate = null)
    {
        $this
            ->setCardDisplayText($cardDisplayText)
            ->setCardNumber($cardNumber)
            ->setClientName($clientName)
            ->setExpiryDate($expiryDate);
    }
    /**
     * Get CardDisplayText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardDisplayText()
    {
        return isset($this->CardDisplayText) ? $this->CardDisplayText : null;
    }
    /**
     * Set CardDisplayText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardDisplayText
     * @return \patest\StructType\Payment_ClientCreditCardPaymentTokenExtended
     */
    public function setCardDisplayText($cardDisplayText = null)
    {
        // validation for constraint: string
        if (!is_null($cardDisplayText) && !is_string($cardDisplayText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardDisplayText, true), gettype($cardDisplayText)), __LINE__);
        }
        if (is_null($cardDisplayText) || (is_array($cardDisplayText) && empty($cardDisplayText))) {
            unset($this->CardDisplayText);
        } else {
            $this->CardDisplayText = $cardDisplayText;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Payment_ClientCreditCardPaymentTokenExtended
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Payment_ClientCreditCardPaymentTokenExtended
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\Payment_ClientCreditCardPaymentTokenExtended
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
}
