<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.BankIdentifierCode StructType
 * @subpackage Structs
 */
class Payment_BankIdentifierCode extends DistributableEntity
{
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The BIC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BIC;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CountryId;
    /**
     * The Primary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Primary;
    /**
     * Constructor method for Payment.BankIdentifierCode
     * @uses Payment_BankIdentifierCode::setBankCode()
     * @uses Payment_BankIdentifierCode::setBankName()
     * @uses Payment_BankIdentifierCode::setBIC()
     * @uses Payment_BankIdentifierCode::setCountryId()
     * @uses Payment_BankIdentifierCode::setPrimary()
     * @param string $bankCode
     * @param string $bankName
     * @param string $bIC
     * @param string $countryId
     * @param int $primary
     */
    public function __construct($bankCode = null, $bankName = null, $bIC = null, $countryId = null, $primary = null)
    {
        $this
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBIC($bIC)
            ->setCountryId($countryId)
            ->setPrimary($primary);
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Payment_BankIdentifierCode
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \patest\StructType\Payment_BankIdentifierCode
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get BIC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBIC()
    {
        return isset($this->BIC) ? $this->BIC : null;
    }
    /**
     * Set BIC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bIC
     * @return \patest\StructType\Payment_BankIdentifierCode
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC, true), gettype($bIC)), __LINE__);
        }
        if (is_null($bIC) || (is_array($bIC) && empty($bIC))) {
            unset($this->BIC);
        } else {
            $this->BIC = $bIC;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryId()
    {
        return isset($this->CountryId) ? $this->CountryId : null;
    }
    /**
     * Set CountryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryId
     * @return \patest\StructType\Payment_BankIdentifierCode
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($countryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($countryId, true)), __LINE__);
        }
        if (is_null($countryId) || (is_array($countryId) && empty($countryId))) {
            unset($this->CountryId);
        } else {
            $this->CountryId = $countryId;
        }
        return $this;
    }
    /**
     * Get Primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrimary()
    {
        return isset($this->Primary) ? $this->Primary : null;
    }
    /**
     * Set Primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $primary
     * @return \patest\StructType\Payment_BankIdentifierCode
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: int
        if (!is_null($primary) && !(is_int($primary) || ctype_digit($primary))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($primary, true), gettype($primary)), __LINE__);
        }
        if (is_null($primary) || (is_array($primary) && empty($primary))) {
            unset($this->Primary);
        } else {
            $this->Primary = $primary;
        }
        return $this;
    }
}
