<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddPaymentPlanPaymentToBasketRequest StructType
 * @subpackage Structs
 */
class Payment_AddPaymentPlanPaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The AmountPerInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountPerInstallment;
    /**
     * The DateOfFirstInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfFirstInstallment;
    /**
     * The DownPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DownPayment;
    /**
     * The InstallmentSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentSchedule;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * The PaymentItemPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemPaymentMethodId;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentPlan
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlan;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RemainingAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * Constructor method for Payment.AddPaymentPlanPaymentToBasketRequest
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setAmountPerInstallment()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setDateOfFirstInstallment()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setDownPayment()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setInstallmentSchedule()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setNumberOfInstallments()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setPaymentDetails()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setPaymentItemPaymentMethodId()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setPaymentMethod()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setPaymentPlan()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setRemainingAmount()
     * @uses Payment_AddPaymentPlanPaymentToBasketRequest::setTotalAmount()
     * @param string $amountPerInstallment
     * @param string $dateOfFirstInstallment
     * @param \patest\StructType\Money $downPayment
     * @param string $installmentSchedule
     * @param int $numberOfInstallments
     * @param string $paymentDetails
     * @param string $paymentItemPaymentMethodId
     * @param string $paymentMethod
     * @param string $paymentPlan
     * @param string $remainingAmount
     * @param \patest\StructType\Money $totalAmount
     */
    public function __construct($amountPerInstallment = null, $dateOfFirstInstallment = null, \patest\StructType\Money $downPayment = null, $installmentSchedule = null, $numberOfInstallments = null, $paymentDetails = null, $paymentItemPaymentMethodId = null, $paymentMethod = null, $paymentPlan = null, $remainingAmount = null, \patest\StructType\Money $totalAmount = null)
    {
        $this
            ->setAmountPerInstallment($amountPerInstallment)
            ->setDateOfFirstInstallment($dateOfFirstInstallment)
            ->setDownPayment($downPayment)
            ->setInstallmentSchedule($installmentSchedule)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setPaymentDetails($paymentDetails)
            ->setPaymentItemPaymentMethodId($paymentItemPaymentMethodId)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentPlan($paymentPlan)
            ->setRemainingAmount($remainingAmount)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get AmountPerInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountPerInstallment()
    {
        return isset($this->AmountPerInstallment) ? $this->AmountPerInstallment : null;
    }
    /**
     * Set AmountPerInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amountPerInstallment
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setAmountPerInstallment($amountPerInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($amountPerInstallment) && !is_string($amountPerInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountPerInstallment, true), gettype($amountPerInstallment)), __LINE__);
        }
        if (is_null($amountPerInstallment) || (is_array($amountPerInstallment) && empty($amountPerInstallment))) {
            unset($this->AmountPerInstallment);
        } else {
            $this->AmountPerInstallment = $amountPerInstallment;
        }
        return $this;
    }
    /**
     * Get DateOfFirstInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfFirstInstallment()
    {
        return isset($this->DateOfFirstInstallment) ? $this->DateOfFirstInstallment : null;
    }
    /**
     * Set DateOfFirstInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfFirstInstallment
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setDateOfFirstInstallment($dateOfFirstInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfFirstInstallment) && !is_string($dateOfFirstInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfFirstInstallment, true), gettype($dateOfFirstInstallment)), __LINE__);
        }
        if (is_null($dateOfFirstInstallment) || (is_array($dateOfFirstInstallment) && empty($dateOfFirstInstallment))) {
            unset($this->DateOfFirstInstallment);
        } else {
            $this->DateOfFirstInstallment = $dateOfFirstInstallment;
        }
        return $this;
    }
    /**
     * Get DownPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDownPayment()
    {
        return isset($this->DownPayment) ? $this->DownPayment : null;
    }
    /**
     * Set DownPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $downPayment
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setDownPayment(\patest\StructType\Money $downPayment = null)
    {
        if (is_null($downPayment) || (is_array($downPayment) && empty($downPayment))) {
            unset($this->DownPayment);
        } else {
            $this->DownPayment = $downPayment;
        }
        return $this;
    }
    /**
     * Get InstallmentSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentSchedule()
    {
        return isset($this->InstallmentSchedule) ? $this->InstallmentSchedule : null;
    }
    /**
     * Set InstallmentSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentSchedule
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setInstallmentSchedule($installmentSchedule = null)
    {
        // validation for constraint: string
        if (!is_null($installmentSchedule) && !is_string($installmentSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentSchedule, true), gettype($installmentSchedule)), __LINE__);
        }
        if (is_null($installmentSchedule) || (is_array($installmentSchedule) && empty($installmentSchedule))) {
            unset($this->InstallmentSchedule);
        } else {
            $this->InstallmentSchedule = $installmentSchedule;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
    /**
     * Get PaymentItemPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemPaymentMethodId()
    {
        return isset($this->PaymentItemPaymentMethodId) ? $this->PaymentItemPaymentMethodId : null;
    }
    /**
     * Set PaymentItemPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemPaymentMethodId
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setPaymentItemPaymentMethodId($paymentItemPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemPaymentMethodId) && !is_string($paymentItemPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemPaymentMethodId, true), gettype($paymentItemPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemPaymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentItemPaymentMethodId) || (is_array($paymentItemPaymentMethodId) && empty($paymentItemPaymentMethodId))) {
            unset($this->PaymentItemPaymentMethodId);
        } else {
            $this->PaymentItemPaymentMethodId = $paymentItemPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentPlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlan()
    {
        return isset($this->PaymentPlan) ? $this->PaymentPlan : null;
    }
    /**
     * Set PaymentPlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlan
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setPaymentPlan($paymentPlan = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlan) && !is_string($paymentPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlan, true), gettype($paymentPlan)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlan) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlan, true)), __LINE__);
        }
        if (is_null($paymentPlan) || (is_array($paymentPlan) && empty($paymentPlan))) {
            unset($this->PaymentPlan);
        } else {
            $this->PaymentPlan = $paymentPlan;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remainingAmount
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setRemainingAmount($remainingAmount = null)
    {
        // validation for constraint: string
        if (!is_null($remainingAmount) && !is_string($remainingAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remainingAmount, true), gettype($remainingAmount)), __LINE__);
        }
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Payment_AddPaymentPlanPaymentToBasketRequest
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
}
