<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddExistingPaymentPlanPaymentToBasketRequest
 * StructType
 * @subpackage Structs
 */
class Payment_AddExistingPaymentPlanPaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The ExistingPaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExistingPaymentInstallmentsScheduleId;
    /**
     * The PaymentPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanId;
    /**
     * Constructor method for Payment.AddExistingPaymentPlanPaymentToBasketRequest
     * @uses Payment_AddExistingPaymentPlanPaymentToBasketRequest::setExistingPaymentInstallmentsScheduleId()
     * @uses Payment_AddExistingPaymentPlanPaymentToBasketRequest::setPaymentPlanId()
     * @param string $existingPaymentInstallmentsScheduleId
     * @param string $paymentPlanId
     */
    public function __construct($existingPaymentInstallmentsScheduleId = null, $paymentPlanId = null)
    {
        $this
            ->setExistingPaymentInstallmentsScheduleId($existingPaymentInstallmentsScheduleId)
            ->setPaymentPlanId($paymentPlanId);
    }
    /**
     * Get ExistingPaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExistingPaymentInstallmentsScheduleId()
    {
        return isset($this->ExistingPaymentInstallmentsScheduleId) ? $this->ExistingPaymentInstallmentsScheduleId : null;
    }
    /**
     * Set ExistingPaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $existingPaymentInstallmentsScheduleId
     * @return \patest\StructType\Payment_AddExistingPaymentPlanPaymentToBasketRequest
     */
    public function setExistingPaymentInstallmentsScheduleId($existingPaymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($existingPaymentInstallmentsScheduleId) && !is_string($existingPaymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existingPaymentInstallmentsScheduleId, true), gettype($existingPaymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($existingPaymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $existingPaymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($existingPaymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($existingPaymentInstallmentsScheduleId) || (is_array($existingPaymentInstallmentsScheduleId) && empty($existingPaymentInstallmentsScheduleId))) {
            unset($this->ExistingPaymentInstallmentsScheduleId);
        } else {
            $this->ExistingPaymentInstallmentsScheduleId = $existingPaymentInstallmentsScheduleId;
        }
        return $this;
    }
    /**
     * Get PaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanId()
    {
        return isset($this->PaymentPlanId) ? $this->PaymentPlanId : null;
    }
    /**
     * Set PaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanId
     * @return \patest\StructType\Payment_AddExistingPaymentPlanPaymentToBasketRequest
     */
    public function setPaymentPlanId($paymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanId) && !is_string($paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanId, true), gettype($paymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanId, true)), __LINE__);
        }
        if (is_null($paymentPlanId) || (is_array($paymentPlanId) && empty($paymentPlanId))) {
            unset($this->PaymentPlanId);
        } else {
            $this->PaymentPlanId = $paymentPlanId;
        }
        return $this;
    }
}
