<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AdHocRefundProductItem StructType
 * @subpackage Structs
 */
class Payment_AdHocRefundProductItem extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmount;
    /**
     * The CompanyCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencyCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReasonId;
    /**
     * The RelatedTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedTransactionGuid;
    /**
     * The RelatedTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RelatedTransactionNumber;
    /**
     * The SiteAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SiteAmount;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Payment.AdHocRefundProductItem
     * @uses Payment_AdHocRefundProductItem::setClientId()
     * @uses Payment_AdHocRefundProductItem::setCompanyAmount()
     * @uses Payment_AdHocRefundProductItem::setCompanyCurrencyCode()
     * @uses Payment_AdHocRefundProductItem::setDescription()
     * @uses Payment_AdHocRefundProductItem::setReasonId()
     * @uses Payment_AdHocRefundProductItem::setRelatedTransactionGuid()
     * @uses Payment_AdHocRefundProductItem::setRelatedTransactionNumber()
     * @uses Payment_AdHocRefundProductItem::setSiteAmount()
     * @uses Payment_AdHocRefundProductItem::setSiteCurrencyCode()
     * @uses Payment_AdHocRefundProductItem::setTransactionGuid()
     * @param string $clientId
     * @param \patest\StructType\Money $companyAmount
     * @param string $companyCurrencyCode
     * @param string $description
     * @param string $reasonId
     * @param string $relatedTransactionGuid
     * @param int $relatedTransactionNumber
     * @param \patest\StructType\Money $siteAmount
     * @param string $siteCurrencyCode
     * @param string $transactionGuid
     */
    public function __construct($clientId = null, \patest\StructType\Money $companyAmount = null, $companyCurrencyCode = null, $description = null, $reasonId = null, $relatedTransactionGuid = null, $relatedTransactionNumber = null, \patest\StructType\Money $siteAmount = null, $siteCurrencyCode = null, $transactionGuid = null)
    {
        $this
            ->setClientId($clientId)
            ->setCompanyAmount($companyAmount)
            ->setCompanyCurrencyCode($companyCurrencyCode)
            ->setDescription($description)
            ->setReasonId($reasonId)
            ->setRelatedTransactionGuid($relatedTransactionGuid)
            ->setRelatedTransactionNumber($relatedTransactionNumber)
            ->setSiteAmount($siteAmount)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CompanyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmount()
    {
        return isset($this->CompanyAmount) ? $this->CompanyAmount : null;
    }
    /**
     * Set CompanyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmount
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setCompanyAmount(\patest\StructType\Money $companyAmount = null)
    {
        if (is_null($companyAmount) || (is_array($companyAmount) && empty($companyAmount))) {
            unset($this->CompanyAmount);
        } else {
            $this->CompanyAmount = $companyAmount;
        }
        return $this;
    }
    /**
     * Get CompanyCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencyCode()
    {
        return isset($this->CompanyCurrencyCode) ? $this->CompanyCurrencyCode : null;
    }
    /**
     * Set CompanyCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencyCode
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setCompanyCurrencyCode($companyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencyCode) && !is_string($companyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencyCode, true), gettype($companyCurrencyCode)), __LINE__);
        }
        if (is_null($companyCurrencyCode) || (is_array($companyCurrencyCode) && empty($companyCurrencyCode))) {
            unset($this->CompanyCurrencyCode);
        } else {
            $this->CompanyCurrencyCode = $companyCurrencyCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonId()
    {
        return isset($this->ReasonId) ? $this->ReasonId : null;
    }
    /**
     * Set ReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonId
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: string
        if (!is_null($reasonId) && !is_string($reasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonId, true), gettype($reasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reasonId, true)), __LINE__);
        }
        if (is_null($reasonId) || (is_array($reasonId) && empty($reasonId))) {
            unset($this->ReasonId);
        } else {
            $this->ReasonId = $reasonId;
        }
        return $this;
    }
    /**
     * Get RelatedTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedTransactionGuid()
    {
        return isset($this->RelatedTransactionGuid) ? $this->RelatedTransactionGuid : null;
    }
    /**
     * Set RelatedTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedTransactionGuid
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setRelatedTransactionGuid($relatedTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($relatedTransactionGuid) && !is_string($relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedTransactionGuid, true), gettype($relatedTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedTransactionGuid, true)), __LINE__);
        }
        if (is_null($relatedTransactionGuid) || (is_array($relatedTransactionGuid) && empty($relatedTransactionGuid))) {
            unset($this->RelatedTransactionGuid);
        } else {
            $this->RelatedTransactionGuid = $relatedTransactionGuid;
        }
        return $this;
    }
    /**
     * Get RelatedTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatedTransactionNumber()
    {
        return isset($this->RelatedTransactionNumber) ? $this->RelatedTransactionNumber : null;
    }
    /**
     * Set RelatedTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatedTransactionNumber
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setRelatedTransactionNumber($relatedTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($relatedTransactionNumber) && !(is_int($relatedTransactionNumber) || ctype_digit($relatedTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatedTransactionNumber, true), gettype($relatedTransactionNumber)), __LINE__);
        }
        if (is_null($relatedTransactionNumber) || (is_array($relatedTransactionNumber) && empty($relatedTransactionNumber))) {
            unset($this->RelatedTransactionNumber);
        } else {
            $this->RelatedTransactionNumber = $relatedTransactionNumber;
        }
        return $this;
    }
    /**
     * Get SiteAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmount()
    {
        return isset($this->SiteAmount) ? $this->SiteAmount : null;
    }
    /**
     * Set SiteAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $siteAmount
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setSiteAmount(\patest\StructType\Money $siteAmount = null)
    {
        if (is_null($siteAmount) || (is_array($siteAmount) && empty($siteAmount))) {
            unset($this->SiteAmount);
        } else {
            $this->SiteAmount = $siteAmount;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_AdHocRefundProductItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
