<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.ActivePaymentInstallmentsSchedule StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment.ActivePaymentInstallmentsSchedule
 * @subpackage Structs
 */
class Payment_ActivePaymentInstallmentsSchedule extends Payment_PaymentInstallmentsSchedule
{
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The FromOriginalTransaction
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FromOriginalTransaction;
    /**
     * The NumberOfPaidInstallments
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfPaidInstallments;
    /**
     * The PaymentItemPaymentMethodId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemPaymentMethodId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentPlanName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentPlanName;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * Constructor method for Payment.ActivePaymentInstallmentsSchedule
     * @uses Payment_ActivePaymentInstallmentsSchedule::setCommitDate()
     * @uses Payment_ActivePaymentInstallmentsSchedule::setFromOriginalTransaction()
     * @uses Payment_ActivePaymentInstallmentsSchedule::setNumberOfPaidInstallments()
     * @uses Payment_ActivePaymentInstallmentsSchedule::setPaymentItemPaymentMethodId()
     * @uses Payment_ActivePaymentInstallmentsSchedule::setPaymentMethodName()
     * @uses Payment_ActivePaymentInstallmentsSchedule::setPaymentPlanName()
     * @uses Payment_ActivePaymentInstallmentsSchedule::setRemainingAmount()
     * @param string $commitDate
     * @param bool $fromOriginalTransaction
     * @param int $numberOfPaidInstallments
     * @param string $paymentItemPaymentMethodId
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param \patest\StructType\GlobalString $paymentPlanName
     * @param \patest\StructType\Money $remainingAmount
     */
    public function __construct($commitDate = null, $fromOriginalTransaction = null, $numberOfPaidInstallments = null, $paymentItemPaymentMethodId = null, \patest\StructType\GlobalString $paymentMethodName = null, \patest\StructType\GlobalString $paymentPlanName = null, \patest\StructType\Money $remainingAmount = null)
    {
        $this
            ->setCommitDate($commitDate)
            ->setFromOriginalTransaction($fromOriginalTransaction)
            ->setNumberOfPaidInstallments($numberOfPaidInstallments)
            ->setPaymentItemPaymentMethodId($paymentItemPaymentMethodId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentPlanName($paymentPlanName)
            ->setRemainingAmount($remainingAmount);
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Payment_ActivePaymentInstallmentsSchedule
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get FromOriginalTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFromOriginalTransaction()
    {
        return isset($this->FromOriginalTransaction) ? $this->FromOriginalTransaction : null;
    }
    /**
     * Set FromOriginalTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fromOriginalTransaction
     * @return \patest\StructType\Payment_ActivePaymentInstallmentsSchedule
     */
    public function setFromOriginalTransaction($fromOriginalTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($fromOriginalTransaction) && !is_bool($fromOriginalTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fromOriginalTransaction, true), gettype($fromOriginalTransaction)), __LINE__);
        }
        if (is_null($fromOriginalTransaction) || (is_array($fromOriginalTransaction) && empty($fromOriginalTransaction))) {
            unset($this->FromOriginalTransaction);
        } else {
            $this->FromOriginalTransaction = $fromOriginalTransaction;
        }
        return $this;
    }
    /**
     * Get NumberOfPaidInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfPaidInstallments()
    {
        return isset($this->NumberOfPaidInstallments) ? $this->NumberOfPaidInstallments : null;
    }
    /**
     * Set NumberOfPaidInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfPaidInstallments
     * @return \patest\StructType\Payment_ActivePaymentInstallmentsSchedule
     */
    public function setNumberOfPaidInstallments($numberOfPaidInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPaidInstallments) && !(is_int($numberOfPaidInstallments) || ctype_digit($numberOfPaidInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPaidInstallments, true), gettype($numberOfPaidInstallments)), __LINE__);
        }
        if (is_null($numberOfPaidInstallments) || (is_array($numberOfPaidInstallments) && empty($numberOfPaidInstallments))) {
            unset($this->NumberOfPaidInstallments);
        } else {
            $this->NumberOfPaidInstallments = $numberOfPaidInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentItemPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemPaymentMethodId()
    {
        return isset($this->PaymentItemPaymentMethodId) ? $this->PaymentItemPaymentMethodId : null;
    }
    /**
     * Set PaymentItemPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemPaymentMethodId
     * @return \patest\StructType\Payment_ActivePaymentInstallmentsSchedule
     */
    public function setPaymentItemPaymentMethodId($paymentItemPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemPaymentMethodId) && !is_string($paymentItemPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemPaymentMethodId, true), gettype($paymentItemPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemPaymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentItemPaymentMethodId) || (is_array($paymentItemPaymentMethodId) && empty($paymentItemPaymentMethodId))) {
            unset($this->PaymentItemPaymentMethodId);
        } else {
            $this->PaymentItemPaymentMethodId = $paymentItemPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Payment_ActivePaymentInstallmentsSchedule
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentPlanName()
    {
        return isset($this->PaymentPlanName) ? $this->PaymentPlanName : null;
    }
    /**
     * Set PaymentPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentPlanName
     * @return \patest\StructType\Payment_ActivePaymentInstallmentsSchedule
     */
    public function setPaymentPlanName(\patest\StructType\GlobalString $paymentPlanName = null)
    {
        if (is_null($paymentPlanName) || (is_array($paymentPlanName) && empty($paymentPlanName))) {
            unset($this->PaymentPlanName);
        } else {
            $this->PaymentPlanName = $paymentPlanName;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\Payment_ActivePaymentInstallmentsSchedule
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
}
