<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentPlanDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentPlanDescription
 * @subpackage Structs
 */
class PaymentPlanDescription extends AbstractPaymentDescription
{
    /**
     * The DateOfFirstInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateOfFirstInstallment;
    /**
     * The DownPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $DownPayment;
    /**
     * The InstallmentPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentMethodId;
    /**
     * The InstallmentPaymentProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentProviderSpecificTokenId;
    /**
     * The InstallmentSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstallmentSchedule;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * Constructor method for PaymentPlanDescription
     * @uses PaymentPlanDescription::setDateOfFirstInstallment()
     * @uses PaymentPlanDescription::setDownPayment()
     * @uses PaymentPlanDescription::setInstallmentPaymentMethodId()
     * @uses PaymentPlanDescription::setInstallmentPaymentProviderSpecificTokenId()
     * @uses PaymentPlanDescription::setInstallmentSchedule()
     * @uses PaymentPlanDescription::setNumberOfInstallments()
     * @uses PaymentPlanDescription::setTotalAmount()
     * @param string $dateOfFirstInstallment
     * @param \patest\StructType\Money $downPayment
     * @param string $installmentPaymentMethodId
     * @param string $installmentPaymentProviderSpecificTokenId
     * @param string $installmentSchedule
     * @param int $numberOfInstallments
     * @param \patest\StructType\Money $totalAmount
     */
    public function __construct($dateOfFirstInstallment = null, \patest\StructType\Money $downPayment = null, $installmentPaymentMethodId = null, $installmentPaymentProviderSpecificTokenId = null, $installmentSchedule = null, $numberOfInstallments = null, \patest\StructType\Money $totalAmount = null)
    {
        $this
            ->setDateOfFirstInstallment($dateOfFirstInstallment)
            ->setDownPayment($downPayment)
            ->setInstallmentPaymentMethodId($installmentPaymentMethodId)
            ->setInstallmentPaymentProviderSpecificTokenId($installmentPaymentProviderSpecificTokenId)
            ->setInstallmentSchedule($installmentSchedule)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get DateOfFirstInstallment value
     * @return string|null
     */
    public function getDateOfFirstInstallment()
    {
        return $this->DateOfFirstInstallment;
    }
    /**
     * Set DateOfFirstInstallment value
     * @param string $dateOfFirstInstallment
     * @return \patest\StructType\PaymentPlanDescription
     */
    public function setDateOfFirstInstallment($dateOfFirstInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfFirstInstallment) && !is_string($dateOfFirstInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfFirstInstallment, true), gettype($dateOfFirstInstallment)), __LINE__);
        }
        $this->DateOfFirstInstallment = $dateOfFirstInstallment;
        return $this;
    }
    /**
     * Get DownPayment value
     * @return \patest\StructType\Money|null
     */
    public function getDownPayment()
    {
        return $this->DownPayment;
    }
    /**
     * Set DownPayment value
     * @param \patest\StructType\Money $downPayment
     * @return \patest\StructType\PaymentPlanDescription
     */
    public function setDownPayment(\patest\StructType\Money $downPayment = null)
    {
        $this->DownPayment = $downPayment;
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodId value
     * @return string|null
     */
    public function getInstallmentPaymentMethodId()
    {
        return $this->InstallmentPaymentMethodId;
    }
    /**
     * Set InstallmentPaymentMethodId value
     * @param string $installmentPaymentMethodId
     * @return \patest\StructType\PaymentPlanDescription
     */
    public function setInstallmentPaymentMethodId($installmentPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentMethodId) && !is_string($installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentMethodId, true), gettype($installmentPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentMethodId, true)), __LINE__);
        }
        $this->InstallmentPaymentMethodId = $installmentPaymentMethodId;
        return $this;
    }
    /**
     * Get InstallmentPaymentProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentProviderSpecificTokenId()
    {
        return isset($this->InstallmentPaymentProviderSpecificTokenId) ? $this->InstallmentPaymentProviderSpecificTokenId : null;
    }
    /**
     * Set InstallmentPaymentProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentProviderSpecificTokenId
     * @return \patest\StructType\PaymentPlanDescription
     */
    public function setInstallmentPaymentProviderSpecificTokenId($installmentPaymentProviderSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentProviderSpecificTokenId) && !is_string($installmentPaymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentProviderSpecificTokenId, true), gettype($installmentPaymentProviderSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentProviderSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentProviderSpecificTokenId, true)), __LINE__);
        }
        if (is_null($installmentPaymentProviderSpecificTokenId) || (is_array($installmentPaymentProviderSpecificTokenId) && empty($installmentPaymentProviderSpecificTokenId))) {
            unset($this->InstallmentPaymentProviderSpecificTokenId);
        } else {
            $this->InstallmentPaymentProviderSpecificTokenId = $installmentPaymentProviderSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get InstallmentSchedule value
     * @return string|null
     */
    public function getInstallmentSchedule()
    {
        return $this->InstallmentSchedule;
    }
    /**
     * Set InstallmentSchedule value
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentSchedule
     * @return \patest\StructType\PaymentPlanDescription
     */
    public function setInstallmentSchedule($installmentSchedule = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($installmentSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($installmentSchedule) ? implode(', ', $installmentSchedule) : var_export($installmentSchedule, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        $this->InstallmentSchedule = $installmentSchedule;
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return $this->NumberOfInstallments;
    }
    /**
     * Set NumberOfInstallments value
     * @param int $numberOfInstallments
     * @return \patest\StructType\PaymentPlanDescription
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        $this->NumberOfInstallments = $numberOfInstallments;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\PaymentPlanDescription
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
