<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentMethodDescription
 * @subpackage Structs
 */
class PaymentMethodDescription extends AbstractStructBase
{
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Available;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Balance;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The InputFormId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InputFormId;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The Explanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Explanation;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The ExtraInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExtraInformation
     */
    public $ExtraInformation;
    /**
     * The IsEarlyDataCollectionSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsEarlyDataCollectionSupported;
    /**
     * The PrimaryImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrimaryImageId;
    /**
     * The AlternativeImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlternativeImageId;
    /**
     * The IsTokenCollectionWithPaymentSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTokenCollectionWithPaymentSupported;
    /**
     * The IsUnboundRefundSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsUnboundRefundSupported;
    /**
     * The UseDifferentClientDeposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseDifferentClientDeposit;
    /**
     * Constructor method for PaymentMethodDescription
     * @uses PaymentMethodDescription::setAvailable()
     * @uses PaymentMethodDescription::setBalance()
     * @uses PaymentMethodDescription::setDescription()
     * @uses PaymentMethodDescription::setId()
     * @uses PaymentMethodDescription::setInputFormId()
     * @uses PaymentMethodDescription::setLocalId()
     * @uses PaymentMethodDescription::setOrdinal()
     * @uses PaymentMethodDescription::setPaymentMethodType()
     * @uses PaymentMethodDescription::setExplanation()
     * @uses PaymentMethodDescription::setSystemName()
     * @uses PaymentMethodDescription::setExtraInformation()
     * @uses PaymentMethodDescription::setIsEarlyDataCollectionSupported()
     * @uses PaymentMethodDescription::setPrimaryImageId()
     * @uses PaymentMethodDescription::setAlternativeImageId()
     * @uses PaymentMethodDescription::setIsTokenCollectionWithPaymentSupported()
     * @uses PaymentMethodDescription::setIsUnboundRefundSupported()
     * @uses PaymentMethodDescription::setUseDifferentClientDeposit()
     * @param bool $available
     * @param \patest\StructType\Money $balance
     * @param string $description
     * @param string $id
     * @param int $inputFormId
     * @param int $localId
     * @param int $ordinal
     * @param string $paymentMethodType
     * @param string $explanation
     * @param string $systemName
     * @param \patest\StructType\ExtraInformation $extraInformation
     * @param bool $isEarlyDataCollectionSupported
     * @param int $primaryImageId
     * @param int $alternativeImageId
     * @param bool $isTokenCollectionWithPaymentSupported
     * @param bool $isUnboundRefundSupported
     * @param bool $useDifferentClientDeposit
     */
    public function __construct($available = null, \patest\StructType\Money $balance = null, $description = null, $id = null, $inputFormId = null, $localId = null, $ordinal = null, $paymentMethodType = null, $explanation = null, $systemName = null, \patest\StructType\ExtraInformation $extraInformation = null, $isEarlyDataCollectionSupported = null, $primaryImageId = null, $alternativeImageId = null, $isTokenCollectionWithPaymentSupported = null, $isUnboundRefundSupported = null, $useDifferentClientDeposit = null)
    {
        $this
            ->setAvailable($available)
            ->setBalance($balance)
            ->setDescription($description)
            ->setId($id)
            ->setInputFormId($inputFormId)
            ->setLocalId($localId)
            ->setOrdinal($ordinal)
            ->setPaymentMethodType($paymentMethodType)
            ->setExplanation($explanation)
            ->setSystemName($systemName)
            ->setExtraInformation($extraInformation)
            ->setIsEarlyDataCollectionSupported($isEarlyDataCollectionSupported)
            ->setPrimaryImageId($primaryImageId)
            ->setAlternativeImageId($alternativeImageId)
            ->setIsTokenCollectionWithPaymentSupported($isTokenCollectionWithPaymentSupported)
            ->setIsUnboundRefundSupported($isUnboundRefundSupported)
            ->setUseDifferentClientDeposit($useDifferentClientDeposit);
    }
    /**
     * Get Available value
     * @return bool|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param bool $available
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: boolean
        if (!is_null($available) && !is_bool($available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $balance
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setBalance(\patest\StructType\Money $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get InputFormId value
     * @return int|null
     */
    public function getInputFormId()
    {
        return $this->InputFormId;
    }
    /**
     * Set InputFormId value
     * @param int $inputFormId
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setInputFormId($inputFormId = null)
    {
        // validation for constraint: int
        if (!is_null($inputFormId) && !(is_int($inputFormId) || ctype_digit($inputFormId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inputFormId, true), gettype($inputFormId)), __LINE__);
        }
        $this->InputFormId = $inputFormId;
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return $this->PaymentMethodType;
    }
    /**
     * Set PaymentMethodType value
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->PaymentMethodType = $paymentMethodType;
        return $this;
    }
    /**
     * Get Explanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExplanation()
    {
        return isset($this->Explanation) ? $this->Explanation : null;
    }
    /**
     * Set Explanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $explanation
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setExplanation($explanation = null)
    {
        // validation for constraint: string
        if (!is_null($explanation) && !is_string($explanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanation, true), gettype($explanation)), __LINE__);
        }
        if (is_null($explanation) || (is_array($explanation) && empty($explanation))) {
            unset($this->Explanation);
        } else {
            $this->Explanation = $explanation;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get ExtraInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExtraInformation|null
     */
    public function getExtraInformation()
    {
        return isset($this->ExtraInformation) ? $this->ExtraInformation : null;
    }
    /**
     * Set ExtraInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExtraInformation $extraInformation
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setExtraInformation(\patest\StructType\ExtraInformation $extraInformation = null)
    {
        if (is_null($extraInformation) || (is_array($extraInformation) && empty($extraInformation))) {
            unset($this->ExtraInformation);
        } else {
            $this->ExtraInformation = $extraInformation;
        }
        return $this;
    }
    /**
     * Get IsEarlyDataCollectionSupported value
     * @return bool|null
     */
    public function getIsEarlyDataCollectionSupported()
    {
        return $this->IsEarlyDataCollectionSupported;
    }
    /**
     * Set IsEarlyDataCollectionSupported value
     * @param bool $isEarlyDataCollectionSupported
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setIsEarlyDataCollectionSupported($isEarlyDataCollectionSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEarlyDataCollectionSupported) && !is_bool($isEarlyDataCollectionSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEarlyDataCollectionSupported, true), gettype($isEarlyDataCollectionSupported)), __LINE__);
        }
        $this->IsEarlyDataCollectionSupported = $isEarlyDataCollectionSupported;
        return $this;
    }
    /**
     * Get PrimaryImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrimaryImageId()
    {
        return isset($this->PrimaryImageId) ? $this->PrimaryImageId : null;
    }
    /**
     * Set PrimaryImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $primaryImageId
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setPrimaryImageId($primaryImageId = null)
    {
        // validation for constraint: int
        if (!is_null($primaryImageId) && !(is_int($primaryImageId) || ctype_digit($primaryImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($primaryImageId, true), gettype($primaryImageId)), __LINE__);
        }
        if (is_null($primaryImageId) || (is_array($primaryImageId) && empty($primaryImageId))) {
            unset($this->PrimaryImageId);
        } else {
            $this->PrimaryImageId = $primaryImageId;
        }
        return $this;
    }
    /**
     * Get AlternativeImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlternativeImageId()
    {
        return isset($this->AlternativeImageId) ? $this->AlternativeImageId : null;
    }
    /**
     * Set AlternativeImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alternativeImageId
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setAlternativeImageId($alternativeImageId = null)
    {
        // validation for constraint: int
        if (!is_null($alternativeImageId) && !(is_int($alternativeImageId) || ctype_digit($alternativeImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alternativeImageId, true), gettype($alternativeImageId)), __LINE__);
        }
        if (is_null($alternativeImageId) || (is_array($alternativeImageId) && empty($alternativeImageId))) {
            unset($this->AlternativeImageId);
        } else {
            $this->AlternativeImageId = $alternativeImageId;
        }
        return $this;
    }
    /**
     * Get IsTokenCollectionWithPaymentSupported value
     * @return bool|null
     */
    public function getIsTokenCollectionWithPaymentSupported()
    {
        return $this->IsTokenCollectionWithPaymentSupported;
    }
    /**
     * Set IsTokenCollectionWithPaymentSupported value
     * @param bool $isTokenCollectionWithPaymentSupported
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setIsTokenCollectionWithPaymentSupported($isTokenCollectionWithPaymentSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTokenCollectionWithPaymentSupported) && !is_bool($isTokenCollectionWithPaymentSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTokenCollectionWithPaymentSupported, true), gettype($isTokenCollectionWithPaymentSupported)), __LINE__);
        }
        $this->IsTokenCollectionWithPaymentSupported = $isTokenCollectionWithPaymentSupported;
        return $this;
    }
    /**
     * Get IsUnboundRefundSupported value
     * @return bool|null
     */
    public function getIsUnboundRefundSupported()
    {
        return $this->IsUnboundRefundSupported;
    }
    /**
     * Set IsUnboundRefundSupported value
     * @param bool $isUnboundRefundSupported
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setIsUnboundRefundSupported($isUnboundRefundSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUnboundRefundSupported) && !is_bool($isUnboundRefundSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUnboundRefundSupported, true), gettype($isUnboundRefundSupported)), __LINE__);
        }
        $this->IsUnboundRefundSupported = $isUnboundRefundSupported;
        return $this;
    }
    /**
     * Get UseDifferentClientDeposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseDifferentClientDeposit()
    {
        return isset($this->UseDifferentClientDeposit) ? $this->UseDifferentClientDeposit : null;
    }
    /**
     * Set UseDifferentClientDeposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useDifferentClientDeposit
     * @return \patest\StructType\PaymentMethodDescription
     */
    public function setUseDifferentClientDeposit($useDifferentClientDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($useDifferentClientDeposit) && !is_bool($useDifferentClientDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useDifferentClientDeposit, true), gettype($useDifferentClientDeposit)), __LINE__);
        }
        if (is_null($useDifferentClientDeposit) || (is_array($useDifferentClientDeposit) && empty($useDifferentClientDeposit))) {
            unset($this->UseDifferentClientDeposit);
        } else {
            $this->UseDifferentClientDeposit = $useDifferentClientDeposit;
        }
        return $this;
    }
}
