<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PasswordValidityParameters StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PasswordValidityParameters
 * @subpackage Structs
 */
class PasswordValidityParameters extends AbstractStructBase
{
    /**
     * The CheckPasswordDoesNotContainUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CheckPasswordDoesNotContainUserName;
    /**
     * The MinPasswordLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinPasswordLength;
    /**
     * The PasswordMustHaveAlphaNumericCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PasswordMustHaveAlphaNumericCharacters;
    /**
     * The PasswordMustHaveLowerAndUpperCaseCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PasswordMustHaveLowerAndUpperCaseCharacters;
    /**
     * The PasswordMustHaveSpecialCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PasswordMustHaveSpecialCharacters;
    /**
     * Constructor method for PasswordValidityParameters
     * @uses PasswordValidityParameters::setCheckPasswordDoesNotContainUserName()
     * @uses PasswordValidityParameters::setMinPasswordLength()
     * @uses PasswordValidityParameters::setPasswordMustHaveAlphaNumericCharacters()
     * @uses PasswordValidityParameters::setPasswordMustHaveLowerAndUpperCaseCharacters()
     * @uses PasswordValidityParameters::setPasswordMustHaveSpecialCharacters()
     * @param bool $checkPasswordDoesNotContainUserName
     * @param int $minPasswordLength
     * @param bool $passwordMustHaveAlphaNumericCharacters
     * @param bool $passwordMustHaveLowerAndUpperCaseCharacters
     * @param bool $passwordMustHaveSpecialCharacters
     */
    public function __construct($checkPasswordDoesNotContainUserName = null, $minPasswordLength = null, $passwordMustHaveAlphaNumericCharacters = null, $passwordMustHaveLowerAndUpperCaseCharacters = null, $passwordMustHaveSpecialCharacters = null)
    {
        $this
            ->setCheckPasswordDoesNotContainUserName($checkPasswordDoesNotContainUserName)
            ->setMinPasswordLength($minPasswordLength)
            ->setPasswordMustHaveAlphaNumericCharacters($passwordMustHaveAlphaNumericCharacters)
            ->setPasswordMustHaveLowerAndUpperCaseCharacters($passwordMustHaveLowerAndUpperCaseCharacters)
            ->setPasswordMustHaveSpecialCharacters($passwordMustHaveSpecialCharacters);
    }
    /**
     * Get CheckPasswordDoesNotContainUserName value
     * @return bool|null
     */
    public function getCheckPasswordDoesNotContainUserName()
    {
        return $this->CheckPasswordDoesNotContainUserName;
    }
    /**
     * Set CheckPasswordDoesNotContainUserName value
     * @param bool $checkPasswordDoesNotContainUserName
     * @return \patest\StructType\PasswordValidityParameters
     */
    public function setCheckPasswordDoesNotContainUserName($checkPasswordDoesNotContainUserName = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkPasswordDoesNotContainUserName) && !is_bool($checkPasswordDoesNotContainUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkPasswordDoesNotContainUserName, true), gettype($checkPasswordDoesNotContainUserName)), __LINE__);
        }
        $this->CheckPasswordDoesNotContainUserName = $checkPasswordDoesNotContainUserName;
        return $this;
    }
    /**
     * Get MinPasswordLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinPasswordLength()
    {
        return isset($this->MinPasswordLength) ? $this->MinPasswordLength : null;
    }
    /**
     * Set MinPasswordLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minPasswordLength
     * @return \patest\StructType\PasswordValidityParameters
     */
    public function setMinPasswordLength($minPasswordLength = null)
    {
        // validation for constraint: int
        if (!is_null($minPasswordLength) && !(is_int($minPasswordLength) || ctype_digit($minPasswordLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minPasswordLength, true), gettype($minPasswordLength)), __LINE__);
        }
        if (is_null($minPasswordLength) || (is_array($minPasswordLength) && empty($minPasswordLength))) {
            unset($this->MinPasswordLength);
        } else {
            $this->MinPasswordLength = $minPasswordLength;
        }
        return $this;
    }
    /**
     * Get PasswordMustHaveAlphaNumericCharacters value
     * @return bool|null
     */
    public function getPasswordMustHaveAlphaNumericCharacters()
    {
        return $this->PasswordMustHaveAlphaNumericCharacters;
    }
    /**
     * Set PasswordMustHaveAlphaNumericCharacters value
     * @param bool $passwordMustHaveAlphaNumericCharacters
     * @return \patest\StructType\PasswordValidityParameters
     */
    public function setPasswordMustHaveAlphaNumericCharacters($passwordMustHaveAlphaNumericCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($passwordMustHaveAlphaNumericCharacters) && !is_bool($passwordMustHaveAlphaNumericCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($passwordMustHaveAlphaNumericCharacters, true), gettype($passwordMustHaveAlphaNumericCharacters)), __LINE__);
        }
        $this->PasswordMustHaveAlphaNumericCharacters = $passwordMustHaveAlphaNumericCharacters;
        return $this;
    }
    /**
     * Get PasswordMustHaveLowerAndUpperCaseCharacters value
     * @return bool|null
     */
    public function getPasswordMustHaveLowerAndUpperCaseCharacters()
    {
        return $this->PasswordMustHaveLowerAndUpperCaseCharacters;
    }
    /**
     * Set PasswordMustHaveLowerAndUpperCaseCharacters value
     * @param bool $passwordMustHaveLowerAndUpperCaseCharacters
     * @return \patest\StructType\PasswordValidityParameters
     */
    public function setPasswordMustHaveLowerAndUpperCaseCharacters($passwordMustHaveLowerAndUpperCaseCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($passwordMustHaveLowerAndUpperCaseCharacters) && !is_bool($passwordMustHaveLowerAndUpperCaseCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($passwordMustHaveLowerAndUpperCaseCharacters, true), gettype($passwordMustHaveLowerAndUpperCaseCharacters)), __LINE__);
        }
        $this->PasswordMustHaveLowerAndUpperCaseCharacters = $passwordMustHaveLowerAndUpperCaseCharacters;
        return $this;
    }
    /**
     * Get PasswordMustHaveSpecialCharacters value
     * @return bool|null
     */
    public function getPasswordMustHaveSpecialCharacters()
    {
        return $this->PasswordMustHaveSpecialCharacters;
    }
    /**
     * Set PasswordMustHaveSpecialCharacters value
     * @param bool $passwordMustHaveSpecialCharacters
     * @return \patest\StructType\PasswordValidityParameters
     */
    public function setPasswordMustHaveSpecialCharacters($passwordMustHaveSpecialCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($passwordMustHaveSpecialCharacters) && !is_bool($passwordMustHaveSpecialCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($passwordMustHaveSpecialCharacters, true), gettype($passwordMustHaveSpecialCharacters)), __LINE__);
        }
        $this->PasswordMustHaveSpecialCharacters = $passwordMustHaveSpecialCharacters;
        return $this;
    }
}
