<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PackageItem
 * @subpackage Structs
 */
class PackageItem extends AbstractProductItem
{
    /**
     * The BeneficiaryItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $BeneficiaryItemIds;
    /**
     * The PackageDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageDefinitionId;
    /**
     * The PackageName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageName;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * Constructor method for PackageItem
     * @uses PackageItem::setBeneficiaryItemIds()
     * @uses PackageItem::setPackageDefinitionId()
     * @uses PackageItem::setPackageName()
     * @uses PackageItem::setCategory()
     * @param \patest\ArrayType\ArrayOfint $beneficiaryItemIds
     * @param string $packageDefinitionId
     * @param string $packageName
     * @param string $category
     */
    public function __construct(\patest\ArrayType\ArrayOfint $beneficiaryItemIds = null, $packageDefinitionId = null, $packageName = null, $category = null)
    {
        $this
            ->setBeneficiaryItemIds($beneficiaryItemIds)
            ->setPackageDefinitionId($packageDefinitionId)
            ->setPackageName($packageName)
            ->setCategory($category);
    }
    /**
     * Get BeneficiaryItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getBeneficiaryItemIds()
    {
        return isset($this->BeneficiaryItemIds) ? $this->BeneficiaryItemIds : null;
    }
    /**
     * Set BeneficiaryItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $beneficiaryItemIds
     * @return \patest\StructType\PackageItem
     */
    public function setBeneficiaryItemIds(\patest\ArrayType\ArrayOfint $beneficiaryItemIds = null)
    {
        if (is_null($beneficiaryItemIds) || (is_array($beneficiaryItemIds) && empty($beneficiaryItemIds))) {
            unset($this->BeneficiaryItemIds);
        } else {
            $this->BeneficiaryItemIds = $beneficiaryItemIds;
        }
        return $this;
    }
    /**
     * Get PackageDefinitionId value
     * @return string|null
     */
    public function getPackageDefinitionId()
    {
        return $this->PackageDefinitionId;
    }
    /**
     * Set PackageDefinitionId value
     * @param string $packageDefinitionId
     * @return \patest\StructType\PackageItem
     */
    public function setPackageDefinitionId($packageDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($packageDefinitionId) && !is_string($packageDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageDefinitionId, true), gettype($packageDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageDefinitionId, true)), __LINE__);
        }
        $this->PackageDefinitionId = $packageDefinitionId;
        return $this;
    }
    /**
     * Get PackageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageName()
    {
        return isset($this->PackageName) ? $this->PackageName : null;
    }
    /**
     * Set PackageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageName
     * @return \patest\StructType\PackageItem
     */
    public function setPackageName($packageName = null)
    {
        // validation for constraint: string
        if (!is_null($packageName) && !is_string($packageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageName, true), gettype($packageName)), __LINE__);
        }
        if (is_null($packageName) || (is_array($packageName) && empty($packageName))) {
            unset($this->PackageName);
        } else {
            $this->PackageName = $packageName;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \patest\StructType\PackageItem
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
}
