<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverridableMembershipItemProperties StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverridableMembershipItemProperties
 * @subpackage Structs
 */
class OverridableMembershipItemProperties extends AbstractStructBase
{
    /**
     * The Client
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Client;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGift;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The JointMembers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfJointMembershipMember
     */
    public $JointMembers;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The NameOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnCard;
    /**
     * The RequestedOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedOperation;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The SkipAutoRenewValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipAutoRenewValidation;
    /**
     * Constructor method for OverridableMembershipItemProperties
     * @uses OverridableMembershipItemProperties::setClient()
     * @uses OverridableMembershipItemProperties::setEndDate()
     * @uses OverridableMembershipItemProperties::setIsGift()
     * @uses OverridableMembershipItemProperties::setItemId()
     * @uses OverridableMembershipItemProperties::setJointMembers()
     * @uses OverridableMembershipItemProperties::setMembershipDefinitionId()
     * @uses OverridableMembershipItemProperties::setNameOnCard()
     * @uses OverridableMembershipItemProperties::setRequestedOperation()
     * @uses OverridableMembershipItemProperties::setStartDate()
     * @uses OverridableMembershipItemProperties::setIsAutoRenewRequested()
     * @uses OverridableMembershipItemProperties::setSkipAutoRenewValidation()
     * @param string $client
     * @param string $endDate
     * @param bool $isGift
     * @param int $itemId
     * @param \patest\ArrayType\ArrayOfJointMembershipMember $jointMembers
     * @param string $membershipDefinitionId
     * @param string $nameOnCard
     * @param string $requestedOperation
     * @param string $startDate
     * @param bool $isAutoRenewRequested
     * @param bool $skipAutoRenewValidation
     */
    public function __construct($client = null, $endDate = null, $isGift = null, $itemId = null, \patest\ArrayType\ArrayOfJointMembershipMember $jointMembers = null, $membershipDefinitionId = null, $nameOnCard = null, $requestedOperation = null, $startDate = null, $isAutoRenewRequested = null, $skipAutoRenewValidation = null)
    {
        $this
            ->setClient($client)
            ->setEndDate($endDate)
            ->setIsGift($isGift)
            ->setItemId($itemId)
            ->setJointMembers($jointMembers)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setNameOnCard($nameOnCard)
            ->setRequestedOperation($requestedOperation)
            ->setStartDate($startDate)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setSkipAutoRenewValidation($skipAutoRenewValidation);
    }
    /**
     * Get Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClient()
    {
        return isset($this->Client) ? $this->Client : null;
    }
    /**
     * Set Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $client
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setClient($client = null)
    {
        // validation for constraint: string
        if (!is_null($client) && !is_string($client)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client, true), gettype($client)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($client) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $client)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($client, true)), __LINE__);
        }
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->Client);
        } else {
            $this->Client = $client;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get IsGift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGift()
    {
        return isset($this->IsGift) ? $this->IsGift : null;
    }
    /**
     * Set IsGift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGift
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        if (is_null($isGift) || (is_array($isGift) && empty($isGift))) {
            unset($this->IsGift);
        } else {
            $this->IsGift = $isGift;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get JointMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfJointMembershipMember|null
     */
    public function getJointMembers()
    {
        return isset($this->JointMembers) ? $this->JointMembers : null;
    }
    /**
     * Set JointMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfJointMembershipMember $jointMembers
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setJointMembers(\patest\ArrayType\ArrayOfJointMembershipMember $jointMembers = null)
    {
        if (is_null($jointMembers) || (is_array($jointMembers) && empty($jointMembers))) {
            unset($this->JointMembers);
        } else {
            $this->JointMembers = $jointMembers;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get NameOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnCard()
    {
        return isset($this->NameOnCard) ? $this->NameOnCard : null;
    }
    /**
     * Set NameOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnCard
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        if (is_null($nameOnCard) || (is_array($nameOnCard) && empty($nameOnCard))) {
            unset($this->NameOnCard);
        } else {
            $this->NameOnCard = $nameOnCard;
        }
        return $this;
    }
    /**
     * Get RequestedOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedOperation()
    {
        return isset($this->RequestedOperation) ? $this->RequestedOperation : null;
    }
    /**
     * Set RequestedOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipRequestedOperation::valueIsValid()
     * @uses \patest\EnumType\MembershipRequestedOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedOperation
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setRequestedOperation($requestedOperation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipRequestedOperation::valueIsValid($requestedOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipRequestedOperation', is_array($requestedOperation) ? implode(', ', $requestedOperation) : var_export($requestedOperation, true), implode(', ', \patest\EnumType\MembershipRequestedOperation::getValidValues())), __LINE__);
        }
        if (is_null($requestedOperation) || (is_array($requestedOperation) && empty($requestedOperation))) {
            unset($this->RequestedOperation);
        } else {
            $this->RequestedOperation = $requestedOperation;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get SkipAutoRenewValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipAutoRenewValidation()
    {
        return isset($this->SkipAutoRenewValidation) ? $this->SkipAutoRenewValidation : null;
    }
    /**
     * Set SkipAutoRenewValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipAutoRenewValidation
     * @return \patest\StructType\OverridableMembershipItemProperties
     */
    public function setSkipAutoRenewValidation($skipAutoRenewValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipAutoRenewValidation) && !is_bool($skipAutoRenewValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipAutoRenewValidation, true), gettype($skipAutoRenewValidation)), __LINE__);
        }
        if (is_null($skipAutoRenewValidation) || (is_array($skipAutoRenewValidation) && empty($skipAutoRenewValidation))) {
            unset($this->SkipAutoRenewValidation);
        } else {
            $this->SkipAutoRenewValidation = $skipAutoRenewValidation;
        }
        return $this;
    }
}
