<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverridableDepositItemSpecificProperties StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverridableDepositItemSpecificProperties
 * @subpackage Structs
 */
class OverridableDepositItemSpecificProperties extends AbstractStructBase
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalAmount;
    /**
     * Constructor method for OverridableDepositItemSpecificProperties
     * @uses OverridableDepositItemSpecificProperties::setAffectProperties()
     * @uses OverridableDepositItemSpecificProperties::setCategoryId()
     * @uses OverridableDepositItemSpecificProperties::setItemId()
     * @uses OverridableDepositItemSpecificProperties::setOriginalAmount()
     * @param string[] $affectProperties
     * @param string $categoryId
     * @param int $itemId
     * @param \patest\StructType\Money $originalAmount
     */
    public function __construct(array $affectProperties = array(), $categoryId = null, $itemId = null, \patest\StructType\Money $originalAmount = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setCategoryId($categoryId)
            ->setItemId($itemId)
            ->setOriginalAmount($originalAmount);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $overridableDepositItemSpecificPropertiesAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableDepositItemProperties::valueIsValid($overridableDepositItemSpecificPropertiesAffectPropertiesItem)) {
                $invalidValues[] = is_object($overridableDepositItemSpecificPropertiesAffectPropertiesItem) ? get_class($overridableDepositItemSpecificPropertiesAffectPropertiesItem) : sprintf('%s(%s)', gettype($overridableDepositItemSpecificPropertiesAffectPropertiesItem), var_export($overridableDepositItemSpecificPropertiesAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableDepositItemProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableDepositItemProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableDepositItemProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableDepositItemProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\OverridableDepositItemSpecificProperties
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\OverridableDepositItemSpecificProperties
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\OverridableDepositItemSpecificProperties
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get OriginalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalAmount()
    {
        return isset($this->OriginalAmount) ? $this->OriginalAmount : null;
    }
    /**
     * Set OriginalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalAmount
     * @return \patest\StructType\OverridableDepositItemSpecificProperties
     */
    public function setOriginalAmount(\patest\StructType\Money $originalAmount = null)
    {
        if (is_null($originalAmount) || (is_array($originalAmount) && empty($originalAmount))) {
            unset($this->OriginalAmount);
        } else {
            $this->OriginalAmount = $originalAmount;
        }
        return $this;
    }
}
