<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderDetails
 * @subpackage Structs
 */
class OrderDetails extends AbstractStructBase
{
    /**
     * The OrderComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderComment;
    /**
     * The OrderContactEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactEmail;
    /**
     * The OrderContactFax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactFax;
    /**
     * The OrderContactHomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactHomePhone;
    /**
     * The OrderContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderContactId;
    /**
     * The OrderContactMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactMobile;
    /**
     * The OrderOrganizerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderOrganizerId;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OrderType;
    /**
     * Constructor method for OrderDetails
     * @uses OrderDetails::setOrderComment()
     * @uses OrderDetails::setOrderContactEmail()
     * @uses OrderDetails::setOrderContactFax()
     * @uses OrderDetails::setOrderContactHomePhone()
     * @uses OrderDetails::setOrderContactId()
     * @uses OrderDetails::setOrderContactMobile()
     * @uses OrderDetails::setOrderOrganizerId()
     * @uses OrderDetails::setOrderType()
     * @param string $orderComment
     * @param string $orderContactEmail
     * @param string $orderContactFax
     * @param string $orderContactHomePhone
     * @param string $orderContactId
     * @param string $orderContactMobile
     * @param string $orderOrganizerId
     * @param string $orderType
     */
    public function __construct($orderComment = null, $orderContactEmail = null, $orderContactFax = null, $orderContactHomePhone = null, $orderContactId = null, $orderContactMobile = null, $orderOrganizerId = null, $orderType = null)
    {
        $this
            ->setOrderComment($orderComment)
            ->setOrderContactEmail($orderContactEmail)
            ->setOrderContactFax($orderContactFax)
            ->setOrderContactHomePhone($orderContactHomePhone)
            ->setOrderContactId($orderContactId)
            ->setOrderContactMobile($orderContactMobile)
            ->setOrderOrganizerId($orderOrganizerId)
            ->setOrderType($orderType);
    }
    /**
     * Get OrderComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderComment()
    {
        return isset($this->OrderComment) ? $this->OrderComment : null;
    }
    /**
     * Set OrderComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderComment
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderComment($orderComment = null)
    {
        // validation for constraint: string
        if (!is_null($orderComment) && !is_string($orderComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderComment, true), gettype($orderComment)), __LINE__);
        }
        if (is_null($orderComment) || (is_array($orderComment) && empty($orderComment))) {
            unset($this->OrderComment);
        } else {
            $this->OrderComment = $orderComment;
        }
        return $this;
    }
    /**
     * Get OrderContactEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactEmail()
    {
        return isset($this->OrderContactEmail) ? $this->OrderContactEmail : null;
    }
    /**
     * Set OrderContactEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactEmail
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderContactEmail($orderContactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactEmail) && !is_string($orderContactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactEmail, true), gettype($orderContactEmail)), __LINE__);
        }
        if (is_null($orderContactEmail) || (is_array($orderContactEmail) && empty($orderContactEmail))) {
            unset($this->OrderContactEmail);
        } else {
            $this->OrderContactEmail = $orderContactEmail;
        }
        return $this;
    }
    /**
     * Get OrderContactFax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactFax()
    {
        return isset($this->OrderContactFax) ? $this->OrderContactFax : null;
    }
    /**
     * Set OrderContactFax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactFax
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderContactFax($orderContactFax = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactFax) && !is_string($orderContactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactFax, true), gettype($orderContactFax)), __LINE__);
        }
        if (is_null($orderContactFax) || (is_array($orderContactFax) && empty($orderContactFax))) {
            unset($this->OrderContactFax);
        } else {
            $this->OrderContactFax = $orderContactFax;
        }
        return $this;
    }
    /**
     * Get OrderContactHomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactHomePhone()
    {
        return isset($this->OrderContactHomePhone) ? $this->OrderContactHomePhone : null;
    }
    /**
     * Set OrderContactHomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactHomePhone
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderContactHomePhone($orderContactHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactHomePhone) && !is_string($orderContactHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactHomePhone, true), gettype($orderContactHomePhone)), __LINE__);
        }
        if (is_null($orderContactHomePhone) || (is_array($orderContactHomePhone) && empty($orderContactHomePhone))) {
            unset($this->OrderContactHomePhone);
        } else {
            $this->OrderContactHomePhone = $orderContactHomePhone;
        }
        return $this;
    }
    /**
     * Get OrderContactId value
     * @return string|null
     */
    public function getOrderContactId()
    {
        return $this->OrderContactId;
    }
    /**
     * Set OrderContactId value
     * @param string $orderContactId
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderContactId($orderContactId = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactId) && !is_string($orderContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactId, true), gettype($orderContactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderContactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderContactId, true)), __LINE__);
        }
        $this->OrderContactId = $orderContactId;
        return $this;
    }
    /**
     * Get OrderContactMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactMobile()
    {
        return isset($this->OrderContactMobile) ? $this->OrderContactMobile : null;
    }
    /**
     * Set OrderContactMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactMobile
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderContactMobile($orderContactMobile = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactMobile) && !is_string($orderContactMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactMobile, true), gettype($orderContactMobile)), __LINE__);
        }
        if (is_null($orderContactMobile) || (is_array($orderContactMobile) && empty($orderContactMobile))) {
            unset($this->OrderContactMobile);
        } else {
            $this->OrderContactMobile = $orderContactMobile;
        }
        return $this;
    }
    /**
     * Get OrderOrganizerId value
     * @return string|null
     */
    public function getOrderOrganizerId()
    {
        return $this->OrderOrganizerId;
    }
    /**
     * Set OrderOrganizerId value
     * @param string $orderOrganizerId
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderOrganizerId($orderOrganizerId = null)
    {
        // validation for constraint: string
        if (!is_null($orderOrganizerId) && !is_string($orderOrganizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderOrganizerId, true), gettype($orderOrganizerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderOrganizerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderOrganizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderOrganizerId, true)), __LINE__);
        }
        $this->OrderOrganizerId = $orderOrganizerId;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @uses \patest\EnumType\OrderType::valueIsValid()
     * @uses \patest\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \patest\StructType\OrderDetails
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \patest\EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
}
