<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenedShiftData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OpenedShiftData
 * @subpackage Structs
 */
class OpenedShiftData extends AbstractStructBase
{
    /**
     * The SaleDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SaleDate;
    /**
     * The ShiftLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShiftLocalId;
    /**
     * Constructor method for OpenedShiftData
     * @uses OpenedShiftData::setSaleDate()
     * @uses OpenedShiftData::setShiftLocalId()
     * @param string $saleDate
     * @param int $shiftLocalId
     */
    public function __construct($saleDate = null, $shiftLocalId = null)
    {
        $this
            ->setSaleDate($saleDate)
            ->setShiftLocalId($shiftLocalId);
    }
    /**
     * Get SaleDate value
     * @return string|null
     */
    public function getSaleDate()
    {
        return $this->SaleDate;
    }
    /**
     * Set SaleDate value
     * @param string $saleDate
     * @return \patest\StructType\OpenedShiftData
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleDate, true), gettype($saleDate)), __LINE__);
        }
        $this->SaleDate = $saleDate;
        return $this;
    }
    /**
     * Get ShiftLocalId value
     * @return int|null
     */
    public function getShiftLocalId()
    {
        return $this->ShiftLocalId;
    }
    /**
     * Set ShiftLocalId value
     * @param int $shiftLocalId
     * @return \patest\StructType\OpenedShiftData
     */
    public function setShiftLocalId($shiftLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($shiftLocalId) && !(is_int($shiftLocalId) || ctype_digit($shiftLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shiftLocalId, true), gettype($shiftLocalId)), __LINE__);
        }
        $this->ShiftLocalId = $shiftLocalId;
        return $this;
    }
}
