<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlineQuery StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OnlineQuery
 * @subpackage Structs
 */
class OnlineQuery extends AbstractStructBase
{
    /**
     * The DataColumns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOutputColumnSpecification
     */
    public $DataColumns;
    /**
     * The GroupByInstanceNameParts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $GroupByInstanceNameParts;
    /**
     * Constructor method for OnlineQuery
     * @uses OnlineQuery::setDataColumns()
     * @uses OnlineQuery::setGroupByInstanceNameParts()
     * @param \patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns
     * @param string[] $groupByInstanceNameParts
     */
    public function __construct(\patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns = null, array $groupByInstanceNameParts = array())
    {
        $this
            ->setDataColumns($dataColumns)
            ->setGroupByInstanceNameParts($groupByInstanceNameParts);
    }
    /**
     * Get DataColumns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOutputColumnSpecification|null
     */
    public function getDataColumns()
    {
        return isset($this->DataColumns) ? $this->DataColumns : null;
    }
    /**
     * Set DataColumns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns
     * @return \patest\StructType\OnlineQuery
     */
    public function setDataColumns(\patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns = null)
    {
        if (is_null($dataColumns) || (is_array($dataColumns) && empty($dataColumns))) {
            unset($this->DataColumns);
        } else {
            $this->DataColumns = $dataColumns;
        }
        return $this;
    }
    /**
     * Get GroupByInstanceNameParts value
     * @return string[]|null
     */
    public function getGroupByInstanceNameParts()
    {
        return $this->GroupByInstanceNameParts;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupByInstanceNameParts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupByInstanceNameParts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupByInstanceNamePartsForArrayConstraintsFromSetGroupByInstanceNameParts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlineQueryGroupByInstanceNamePartsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\InstanceNamePart::valueIsValid($onlineQueryGroupByInstanceNamePartsItem)) {
                $invalidValues[] = is_object($onlineQueryGroupByInstanceNamePartsItem) ? get_class($onlineQueryGroupByInstanceNamePartsItem) : sprintf('%s(%s)', gettype($onlineQueryGroupByInstanceNamePartsItem), var_export($onlineQueryGroupByInstanceNamePartsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstanceNamePart', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\InstanceNamePart::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupByInstanceNameParts value
     * @uses \patest\EnumType\InstanceNamePart::valueIsValid()
     * @uses \patest\EnumType\InstanceNamePart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $groupByInstanceNameParts
     * @return \patest\StructType\OnlineQuery
     */
    public function setGroupByInstanceNameParts(array $groupByInstanceNameParts = array())
    {
        // validation for constraint: list
        if ('' !== ($groupByInstanceNamePartsArrayErrorMessage = self::validateGroupByInstanceNamePartsForArrayConstraintsFromSetGroupByInstanceNameParts($groupByInstanceNameParts))) {
            throw new \InvalidArgumentException($groupByInstanceNamePartsArrayErrorMessage, __LINE__);
        }
        $this->GroupByInstanceNameParts = is_array($groupByInstanceNameParts) ? implode(' ', $groupByInstanceNameParts) : null;
        return $this;
    }
}
