<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlinePaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OnlinePaymentItem
 * @subpackage Structs
 */
class OnlinePaymentItem extends AbstractPaymentItem
{
    /**
     * The AcceptUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptUrl;
    /**
     * The BaseUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseUrl;
    /**
     * The CancelUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CancelUrl;
    /**
     * The CardNumberMask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumberMask;
    /**
     * The CardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardSuffix;
    /**
     * The CardToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardToken;
    /**
     * The DeclineUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclineUrl;
    /**
     * The ErrorUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorUrl;
    /**
     * The ExtraPaymentInstructions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraPaymentInstructions;
    /**
     * The FailAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FailAction;
    /**
     * The GatewayTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatewayTransactionId;
    /**
     * The IsForFutureUse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFutureUse;
    /**
     * The IsStartedAsUppSession
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStartedAsUppSession;
    /**
     * The LocalRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalRefNumber;
    /**
     * The OperationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $OperationMode;
    /**
     * Constructor method for OnlinePaymentItem
     * @uses OnlinePaymentItem::setAcceptUrl()
     * @uses OnlinePaymentItem::setBaseUrl()
     * @uses OnlinePaymentItem::setCancelUrl()
     * @uses OnlinePaymentItem::setCardNumberMask()
     * @uses OnlinePaymentItem::setCardSuffix()
     * @uses OnlinePaymentItem::setCardToken()
     * @uses OnlinePaymentItem::setDeclineUrl()
     * @uses OnlinePaymentItem::setErrorUrl()
     * @uses OnlinePaymentItem::setExtraPaymentInstructions()
     * @uses OnlinePaymentItem::setFailAction()
     * @uses OnlinePaymentItem::setGatewayTransactionId()
     * @uses OnlinePaymentItem::setIsForFutureUse()
     * @uses OnlinePaymentItem::setIsStartedAsUppSession()
     * @uses OnlinePaymentItem::setLocalRefNumber()
     * @uses OnlinePaymentItem::setOperationMode()
     * @param string $acceptUrl
     * @param string $baseUrl
     * @param string $cancelUrl
     * @param string $cardNumberMask
     * @param string $cardSuffix
     * @param string $cardToken
     * @param string $declineUrl
     * @param string $errorUrl
     * @param string $extraPaymentInstructions
     * @param string $failAction
     * @param string $gatewayTransactionId
     * @param bool $isForFutureUse
     * @param bool $isStartedAsUppSession
     * @param int $localRefNumber
     * @param string[] $operationMode
     */
    public function __construct($acceptUrl = null, $baseUrl = null, $cancelUrl = null, $cardNumberMask = null, $cardSuffix = null, $cardToken = null, $declineUrl = null, $errorUrl = null, $extraPaymentInstructions = null, $failAction = null, $gatewayTransactionId = null, $isForFutureUse = null, $isStartedAsUppSession = null, $localRefNumber = null, array $operationMode = array())
    {
        $this
            ->setAcceptUrl($acceptUrl)
            ->setBaseUrl($baseUrl)
            ->setCancelUrl($cancelUrl)
            ->setCardNumberMask($cardNumberMask)
            ->setCardSuffix($cardSuffix)
            ->setCardToken($cardToken)
            ->setDeclineUrl($declineUrl)
            ->setErrorUrl($errorUrl)
            ->setExtraPaymentInstructions($extraPaymentInstructions)
            ->setFailAction($failAction)
            ->setGatewayTransactionId($gatewayTransactionId)
            ->setIsForFutureUse($isForFutureUse)
            ->setIsStartedAsUppSession($isStartedAsUppSession)
            ->setLocalRefNumber($localRefNumber)
            ->setOperationMode($operationMode);
    }
    /**
     * Get AcceptUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptUrl()
    {
        return isset($this->AcceptUrl) ? $this->AcceptUrl : null;
    }
    /**
     * Set AcceptUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptUrl
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setAcceptUrl($acceptUrl = null)
    {
        // validation for constraint: string
        if (!is_null($acceptUrl) && !is_string($acceptUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptUrl, true), gettype($acceptUrl)), __LINE__);
        }
        if (is_null($acceptUrl) || (is_array($acceptUrl) && empty($acceptUrl))) {
            unset($this->AcceptUrl);
        } else {
            $this->AcceptUrl = $acceptUrl;
        }
        return $this;
    }
    /**
     * Get BaseUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseUrl()
    {
        return isset($this->BaseUrl) ? $this->BaseUrl : null;
    }
    /**
     * Set BaseUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseUrl
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setBaseUrl($baseUrl = null)
    {
        // validation for constraint: string
        if (!is_null($baseUrl) && !is_string($baseUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseUrl, true), gettype($baseUrl)), __LINE__);
        }
        if (is_null($baseUrl) || (is_array($baseUrl) && empty($baseUrl))) {
            unset($this->BaseUrl);
        } else {
            $this->BaseUrl = $baseUrl;
        }
        return $this;
    }
    /**
     * Get CancelUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancelUrl()
    {
        return isset($this->CancelUrl) ? $this->CancelUrl : null;
    }
    /**
     * Set CancelUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cancelUrl
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setCancelUrl($cancelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cancelUrl) && !is_string($cancelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelUrl, true), gettype($cancelUrl)), __LINE__);
        }
        if (is_null($cancelUrl) || (is_array($cancelUrl) && empty($cancelUrl))) {
            unset($this->CancelUrl);
        } else {
            $this->CancelUrl = $cancelUrl;
        }
        return $this;
    }
    /**
     * Get CardNumberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumberMask()
    {
        return isset($this->CardNumberMask) ? $this->CardNumberMask : null;
    }
    /**
     * Set CardNumberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumberMask
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setCardNumberMask($cardNumberMask = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberMask) && !is_string($cardNumberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberMask, true), gettype($cardNumberMask)), __LINE__);
        }
        if (is_null($cardNumberMask) || (is_array($cardNumberMask) && empty($cardNumberMask))) {
            unset($this->CardNumberMask);
        } else {
            $this->CardNumberMask = $cardNumberMask;
        }
        return $this;
    }
    /**
     * Get CardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardSuffix()
    {
        return isset($this->CardSuffix) ? $this->CardSuffix : null;
    }
    /**
     * Set CardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardSuffix
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setCardSuffix($cardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($cardSuffix) && !is_string($cardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardSuffix, true), gettype($cardSuffix)), __LINE__);
        }
        if (is_null($cardSuffix) || (is_array($cardSuffix) && empty($cardSuffix))) {
            unset($this->CardSuffix);
        } else {
            $this->CardSuffix = $cardSuffix;
        }
        return $this;
    }
    /**
     * Get CardToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardToken()
    {
        return isset($this->CardToken) ? $this->CardToken : null;
    }
    /**
     * Set CardToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardToken
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setCardToken($cardToken = null)
    {
        // validation for constraint: string
        if (!is_null($cardToken) && !is_string($cardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardToken, true), gettype($cardToken)), __LINE__);
        }
        if (is_null($cardToken) || (is_array($cardToken) && empty($cardToken))) {
            unset($this->CardToken);
        } else {
            $this->CardToken = $cardToken;
        }
        return $this;
    }
    /**
     * Get DeclineUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclineUrl()
    {
        return isset($this->DeclineUrl) ? $this->DeclineUrl : null;
    }
    /**
     * Set DeclineUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declineUrl
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setDeclineUrl($declineUrl = null)
    {
        // validation for constraint: string
        if (!is_null($declineUrl) && !is_string($declineUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declineUrl, true), gettype($declineUrl)), __LINE__);
        }
        if (is_null($declineUrl) || (is_array($declineUrl) && empty($declineUrl))) {
            unset($this->DeclineUrl);
        } else {
            $this->DeclineUrl = $declineUrl;
        }
        return $this;
    }
    /**
     * Get ErrorUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorUrl()
    {
        return isset($this->ErrorUrl) ? $this->ErrorUrl : null;
    }
    /**
     * Set ErrorUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorUrl
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setErrorUrl($errorUrl = null)
    {
        // validation for constraint: string
        if (!is_null($errorUrl) && !is_string($errorUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorUrl, true), gettype($errorUrl)), __LINE__);
        }
        if (is_null($errorUrl) || (is_array($errorUrl) && empty($errorUrl))) {
            unset($this->ErrorUrl);
        } else {
            $this->ErrorUrl = $errorUrl;
        }
        return $this;
    }
    /**
     * Get ExtraPaymentInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraPaymentInstructions()
    {
        return isset($this->ExtraPaymentInstructions) ? $this->ExtraPaymentInstructions : null;
    }
    /**
     * Set ExtraPaymentInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraPaymentInstructions
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setExtraPaymentInstructions($extraPaymentInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($extraPaymentInstructions) && !is_string($extraPaymentInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraPaymentInstructions, true), gettype($extraPaymentInstructions)), __LINE__);
        }
        if (is_null($extraPaymentInstructions) || (is_array($extraPaymentInstructions) && empty($extraPaymentInstructions))) {
            unset($this->ExtraPaymentInstructions);
        } else {
            $this->ExtraPaymentInstructions = $extraPaymentInstructions;
        }
        return $this;
    }
    /**
     * Get FailAction value
     * @return string|null
     */
    public function getFailAction()
    {
        return $this->FailAction;
    }
    /**
     * Set FailAction value
     * @uses \patest\EnumType\OnlinePaymentFailAction::valueIsValid()
     * @uses \patest\EnumType\OnlinePaymentFailAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failAction
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setFailAction($failAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OnlinePaymentFailAction::valueIsValid($failAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OnlinePaymentFailAction', is_array($failAction) ? implode(', ', $failAction) : var_export($failAction, true), implode(', ', \patest\EnumType\OnlinePaymentFailAction::getValidValues())), __LINE__);
        }
        $this->FailAction = $failAction;
        return $this;
    }
    /**
     * Get GatewayTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatewayTransactionId()
    {
        return isset($this->GatewayTransactionId) ? $this->GatewayTransactionId : null;
    }
    /**
     * Set GatewayTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatewayTransactionId
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setGatewayTransactionId($gatewayTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($gatewayTransactionId) && !is_string($gatewayTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatewayTransactionId, true), gettype($gatewayTransactionId)), __LINE__);
        }
        if (is_null($gatewayTransactionId) || (is_array($gatewayTransactionId) && empty($gatewayTransactionId))) {
            unset($this->GatewayTransactionId);
        } else {
            $this->GatewayTransactionId = $gatewayTransactionId;
        }
        return $this;
    }
    /**
     * Get IsForFutureUse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFutureUse()
    {
        return isset($this->IsForFutureUse) ? $this->IsForFutureUse : null;
    }
    /**
     * Set IsForFutureUse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFutureUse
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setIsForFutureUse($isForFutureUse = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFutureUse) && !is_bool($isForFutureUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFutureUse, true), gettype($isForFutureUse)), __LINE__);
        }
        if (is_null($isForFutureUse) || (is_array($isForFutureUse) && empty($isForFutureUse))) {
            unset($this->IsForFutureUse);
        } else {
            $this->IsForFutureUse = $isForFutureUse;
        }
        return $this;
    }
    /**
     * Get IsStartedAsUppSession value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStartedAsUppSession()
    {
        return isset($this->IsStartedAsUppSession) ? $this->IsStartedAsUppSession : null;
    }
    /**
     * Set IsStartedAsUppSession value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStartedAsUppSession
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setIsStartedAsUppSession($isStartedAsUppSession = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStartedAsUppSession) && !is_bool($isStartedAsUppSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStartedAsUppSession, true), gettype($isStartedAsUppSession)), __LINE__);
        }
        if (is_null($isStartedAsUppSession) || (is_array($isStartedAsUppSession) && empty($isStartedAsUppSession))) {
            unset($this->IsStartedAsUppSession);
        } else {
            $this->IsStartedAsUppSession = $isStartedAsUppSession;
        }
        return $this;
    }
    /**
     * Get LocalRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalRefNumber()
    {
        return isset($this->LocalRefNumber) ? $this->LocalRefNumber : null;
    }
    /**
     * Set LocalRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localRefNumber
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setLocalRefNumber($localRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($localRefNumber) && !(is_int($localRefNumber) || ctype_digit($localRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localRefNumber, true), gettype($localRefNumber)), __LINE__);
        }
        if (is_null($localRefNumber) || (is_array($localRefNumber) && empty($localRefNumber))) {
            unset($this->LocalRefNumber);
        } else {
            $this->LocalRefNumber = $localRefNumber;
        }
        return $this;
    }
    /**
     * Get OperationMode value
     * @return string[]|null
     */
    public function getOperationMode()
    {
        return $this->OperationMode;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationMode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationMode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationModeForArrayConstraintsFromSetOperationMode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinePaymentItemOperationModeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OnlinePaymentMode::valueIsValid($onlinePaymentItemOperationModeItem)) {
                $invalidValues[] = is_object($onlinePaymentItemOperationModeItem) ? get_class($onlinePaymentItemOperationModeItem) : sprintf('%s(%s)', gettype($onlinePaymentItemOperationModeItem), var_export($onlinePaymentItemOperationModeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OnlinePaymentMode', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OnlinePaymentMode::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationMode value
     * @uses \patest\EnumType\OnlinePaymentMode::valueIsValid()
     * @uses \patest\EnumType\OnlinePaymentMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $operationMode
     * @return \patest\StructType\OnlinePaymentItem
     */
    public function setOperationMode(array $operationMode = array())
    {
        // validation for constraint: list
        if ('' !== ($operationModeArrayErrorMessage = self::validateOperationModeForArrayConstraintsFromSetOperationMode($operationMode))) {
            throw new \InvalidArgumentException($operationModeArrayErrorMessage, __LINE__);
        }
        $this->OperationMode = is_array($operationMode) ? implode(' ', $operationMode) : null;
        return $this;
    }
}
