<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlinePaymentDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OnlinePaymentDescription
 * @subpackage Structs
 */
class OnlinePaymentDescription extends AbstractPaymentDescription
{
    /**
     * The AcceptUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptUrl;
    /**
     * The BaseUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseUrl;
    /**
     * The CancelUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CancelUrl;
    /**
     * The DataCollectionSessionCookie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataCollectionSessionCookie;
    /**
     * The DeclineUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclineUrl;
    /**
     * The ErrorUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorUrl;
    /**
     * The FailAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FailAction;
    /**
     * The IsForFutureUse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFutureUse;
    /**
     * The IsStartedAsUppSession
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStartedAsUppSession;
    /**
     * The IsForFuturePayByCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFuturePayByCustomer;
    /**
     * The PayUsingPaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayUsingPaymentTokenId;
    /**
     * The IsForFuturePayInternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFuturePayInternally;
    /**
     * Constructor method for OnlinePaymentDescription
     * @uses OnlinePaymentDescription::setAcceptUrl()
     * @uses OnlinePaymentDescription::setBaseUrl()
     * @uses OnlinePaymentDescription::setCancelUrl()
     * @uses OnlinePaymentDescription::setDataCollectionSessionCookie()
     * @uses OnlinePaymentDescription::setDeclineUrl()
     * @uses OnlinePaymentDescription::setErrorUrl()
     * @uses OnlinePaymentDescription::setFailAction()
     * @uses OnlinePaymentDescription::setIsForFutureUse()
     * @uses OnlinePaymentDescription::setIsStartedAsUppSession()
     * @uses OnlinePaymentDescription::setIsForFuturePayByCustomer()
     * @uses OnlinePaymentDescription::setPayUsingPaymentTokenId()
     * @uses OnlinePaymentDescription::setIsForFuturePayInternally()
     * @param string $acceptUrl
     * @param string $baseUrl
     * @param string $cancelUrl
     * @param string $dataCollectionSessionCookie
     * @param string $declineUrl
     * @param string $errorUrl
     * @param string $failAction
     * @param bool $isForFutureUse
     * @param bool $isStartedAsUppSession
     * @param bool $isForFuturePayByCustomer
     * @param string $payUsingPaymentTokenId
     * @param bool $isForFuturePayInternally
     */
    public function __construct($acceptUrl = null, $baseUrl = null, $cancelUrl = null, $dataCollectionSessionCookie = null, $declineUrl = null, $errorUrl = null, $failAction = null, $isForFutureUse = null, $isStartedAsUppSession = null, $isForFuturePayByCustomer = null, $payUsingPaymentTokenId = null, $isForFuturePayInternally = null)
    {
        $this
            ->setAcceptUrl($acceptUrl)
            ->setBaseUrl($baseUrl)
            ->setCancelUrl($cancelUrl)
            ->setDataCollectionSessionCookie($dataCollectionSessionCookie)
            ->setDeclineUrl($declineUrl)
            ->setErrorUrl($errorUrl)
            ->setFailAction($failAction)
            ->setIsForFutureUse($isForFutureUse)
            ->setIsStartedAsUppSession($isStartedAsUppSession)
            ->setIsForFuturePayByCustomer($isForFuturePayByCustomer)
            ->setPayUsingPaymentTokenId($payUsingPaymentTokenId)
            ->setIsForFuturePayInternally($isForFuturePayInternally);
    }
    /**
     * Get AcceptUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptUrl()
    {
        return isset($this->AcceptUrl) ? $this->AcceptUrl : null;
    }
    /**
     * Set AcceptUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptUrl
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setAcceptUrl($acceptUrl = null)
    {
        // validation for constraint: string
        if (!is_null($acceptUrl) && !is_string($acceptUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptUrl, true), gettype($acceptUrl)), __LINE__);
        }
        if (is_null($acceptUrl) || (is_array($acceptUrl) && empty($acceptUrl))) {
            unset($this->AcceptUrl);
        } else {
            $this->AcceptUrl = $acceptUrl;
        }
        return $this;
    }
    /**
     * Get BaseUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseUrl()
    {
        return isset($this->BaseUrl) ? $this->BaseUrl : null;
    }
    /**
     * Set BaseUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseUrl
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setBaseUrl($baseUrl = null)
    {
        // validation for constraint: string
        if (!is_null($baseUrl) && !is_string($baseUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseUrl, true), gettype($baseUrl)), __LINE__);
        }
        if (is_null($baseUrl) || (is_array($baseUrl) && empty($baseUrl))) {
            unset($this->BaseUrl);
        } else {
            $this->BaseUrl = $baseUrl;
        }
        return $this;
    }
    /**
     * Get CancelUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancelUrl()
    {
        return isset($this->CancelUrl) ? $this->CancelUrl : null;
    }
    /**
     * Set CancelUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cancelUrl
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setCancelUrl($cancelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cancelUrl) && !is_string($cancelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelUrl, true), gettype($cancelUrl)), __LINE__);
        }
        if (is_null($cancelUrl) || (is_array($cancelUrl) && empty($cancelUrl))) {
            unset($this->CancelUrl);
        } else {
            $this->CancelUrl = $cancelUrl;
        }
        return $this;
    }
    /**
     * Get DataCollectionSessionCookie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataCollectionSessionCookie()
    {
        return isset($this->DataCollectionSessionCookie) ? $this->DataCollectionSessionCookie : null;
    }
    /**
     * Set DataCollectionSessionCookie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataCollectionSessionCookie
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setDataCollectionSessionCookie($dataCollectionSessionCookie = null)
    {
        // validation for constraint: string
        if (!is_null($dataCollectionSessionCookie) && !is_string($dataCollectionSessionCookie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCollectionSessionCookie, true), gettype($dataCollectionSessionCookie)), __LINE__);
        }
        if (is_null($dataCollectionSessionCookie) || (is_array($dataCollectionSessionCookie) && empty($dataCollectionSessionCookie))) {
            unset($this->DataCollectionSessionCookie);
        } else {
            $this->DataCollectionSessionCookie = $dataCollectionSessionCookie;
        }
        return $this;
    }
    /**
     * Get DeclineUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclineUrl()
    {
        return isset($this->DeclineUrl) ? $this->DeclineUrl : null;
    }
    /**
     * Set DeclineUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declineUrl
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setDeclineUrl($declineUrl = null)
    {
        // validation for constraint: string
        if (!is_null($declineUrl) && !is_string($declineUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declineUrl, true), gettype($declineUrl)), __LINE__);
        }
        if (is_null($declineUrl) || (is_array($declineUrl) && empty($declineUrl))) {
            unset($this->DeclineUrl);
        } else {
            $this->DeclineUrl = $declineUrl;
        }
        return $this;
    }
    /**
     * Get ErrorUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorUrl()
    {
        return isset($this->ErrorUrl) ? $this->ErrorUrl : null;
    }
    /**
     * Set ErrorUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorUrl
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setErrorUrl($errorUrl = null)
    {
        // validation for constraint: string
        if (!is_null($errorUrl) && !is_string($errorUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorUrl, true), gettype($errorUrl)), __LINE__);
        }
        if (is_null($errorUrl) || (is_array($errorUrl) && empty($errorUrl))) {
            unset($this->ErrorUrl);
        } else {
            $this->ErrorUrl = $errorUrl;
        }
        return $this;
    }
    /**
     * Get FailAction value
     * @return string|null
     */
    public function getFailAction()
    {
        return $this->FailAction;
    }
    /**
     * Set FailAction value
     * @uses \patest\EnumType\OnlinePaymentFailAction::valueIsValid()
     * @uses \patest\EnumType\OnlinePaymentFailAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failAction
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setFailAction($failAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OnlinePaymentFailAction::valueIsValid($failAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OnlinePaymentFailAction', is_array($failAction) ? implode(', ', $failAction) : var_export($failAction, true), implode(', ', \patest\EnumType\OnlinePaymentFailAction::getValidValues())), __LINE__);
        }
        $this->FailAction = $failAction;
        return $this;
    }
    /**
     * Get IsForFutureUse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFutureUse()
    {
        return isset($this->IsForFutureUse) ? $this->IsForFutureUse : null;
    }
    /**
     * Set IsForFutureUse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFutureUse
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setIsForFutureUse($isForFutureUse = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFutureUse) && !is_bool($isForFutureUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFutureUse, true), gettype($isForFutureUse)), __LINE__);
        }
        if (is_null($isForFutureUse) || (is_array($isForFutureUse) && empty($isForFutureUse))) {
            unset($this->IsForFutureUse);
        } else {
            $this->IsForFutureUse = $isForFutureUse;
        }
        return $this;
    }
    /**
     * Get IsStartedAsUppSession value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStartedAsUppSession()
    {
        return isset($this->IsStartedAsUppSession) ? $this->IsStartedAsUppSession : null;
    }
    /**
     * Set IsStartedAsUppSession value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStartedAsUppSession
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setIsStartedAsUppSession($isStartedAsUppSession = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStartedAsUppSession) && !is_bool($isStartedAsUppSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStartedAsUppSession, true), gettype($isStartedAsUppSession)), __LINE__);
        }
        if (is_null($isStartedAsUppSession) || (is_array($isStartedAsUppSession) && empty($isStartedAsUppSession))) {
            unset($this->IsStartedAsUppSession);
        } else {
            $this->IsStartedAsUppSession = $isStartedAsUppSession;
        }
        return $this;
    }
    /**
     * Get IsForFuturePayByCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFuturePayByCustomer()
    {
        return isset($this->IsForFuturePayByCustomer) ? $this->IsForFuturePayByCustomer : null;
    }
    /**
     * Set IsForFuturePayByCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFuturePayByCustomer
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setIsForFuturePayByCustomer($isForFuturePayByCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayByCustomer) && !is_bool($isForFuturePayByCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayByCustomer, true), gettype($isForFuturePayByCustomer)), __LINE__);
        }
        if (is_null($isForFuturePayByCustomer) || (is_array($isForFuturePayByCustomer) && empty($isForFuturePayByCustomer))) {
            unset($this->IsForFuturePayByCustomer);
        } else {
            $this->IsForFuturePayByCustomer = $isForFuturePayByCustomer;
        }
        return $this;
    }
    /**
     * Get PayUsingPaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayUsingPaymentTokenId()
    {
        return isset($this->PayUsingPaymentTokenId) ? $this->PayUsingPaymentTokenId : null;
    }
    /**
     * Set PayUsingPaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payUsingPaymentTokenId
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setPayUsingPaymentTokenId($payUsingPaymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($payUsingPaymentTokenId) && !is_string($payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payUsingPaymentTokenId, true), gettype($payUsingPaymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payUsingPaymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payUsingPaymentTokenId, true)), __LINE__);
        }
        if (is_null($payUsingPaymentTokenId) || (is_array($payUsingPaymentTokenId) && empty($payUsingPaymentTokenId))) {
            unset($this->PayUsingPaymentTokenId);
        } else {
            $this->PayUsingPaymentTokenId = $payUsingPaymentTokenId;
        }
        return $this;
    }
    /**
     * Get IsForFuturePayInternally value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFuturePayInternally()
    {
        return isset($this->IsForFuturePayInternally) ? $this->IsForFuturePayInternally : null;
    }
    /**
     * Set IsForFuturePayInternally value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFuturePayInternally
     * @return \patest\StructType\OnlinePaymentDescription
     */
    public function setIsForFuturePayInternally($isForFuturePayInternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayInternally) && !is_bool($isForFuturePayInternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayInternally, true), gettype($isForFuturePayInternally)), __LINE__);
        }
        if (is_null($isForFuturePayInternally) || (is_array($isForFuturePayInternally) && empty($isForFuturePayInternally))) {
            unset($this->IsForFuturePayInternally);
        } else {
            $this->IsForFuturePayInternally = $isForFuturePayInternally;
        }
        return $this;
    }
}
