<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfflineScanBarcodeUsage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OfflineScanBarcodeUsage
 * @subpackage Structs
 */
class OfflineScanBarcodeUsage extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeId;
    /**
     * The BarcodeUsageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeUsageId;
    /**
     * The FailureReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureReasonCode;
    /**
     * The FailureReasonDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureReasonDescr;
    /**
     * The IsFirstScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFirstScan;
    /**
     * The ScanAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ScanAction;
    /**
     * The ScanDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScanDate;
    /**
     * The ScanSucceeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ScanSucceeded;
    /**
     * The ScannedRefEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScannedRefEntityId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * The VirtualBarcodeUsageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VirtualBarcodeUsageId;
    /**
     * Constructor method for OfflineScanBarcodeUsage
     * @uses OfflineScanBarcodeUsage::setBarcode()
     * @uses OfflineScanBarcodeUsage::setBarcodeId()
     * @uses OfflineScanBarcodeUsage::setBarcodeUsageId()
     * @uses OfflineScanBarcodeUsage::setFailureReasonCode()
     * @uses OfflineScanBarcodeUsage::setFailureReasonDescr()
     * @uses OfflineScanBarcodeUsage::setIsFirstScan()
     * @uses OfflineScanBarcodeUsage::setScanAction()
     * @uses OfflineScanBarcodeUsage::setScanDate()
     * @uses OfflineScanBarcodeUsage::setScanSucceeded()
     * @uses OfflineScanBarcodeUsage::setScannedRefEntityId()
     * @uses OfflineScanBarcodeUsage::setTicketId()
     * @uses OfflineScanBarcodeUsage::setVirtualBarcodeUsageId()
     * @param string $barcode
     * @param string $barcodeId
     * @param string $barcodeUsageId
     * @param string $failureReasonCode
     * @param string $failureReasonDescr
     * @param bool $isFirstScan
     * @param int $scanAction
     * @param string $scanDate
     * @param bool $scanSucceeded
     * @param string $scannedRefEntityId
     * @param string $ticketId
     * @param string $virtualBarcodeUsageId
     */
    public function __construct($barcode = null, $barcodeId = null, $barcodeUsageId = null, $failureReasonCode = null, $failureReasonDescr = null, $isFirstScan = null, $scanAction = null, $scanDate = null, $scanSucceeded = null, $scannedRefEntityId = null, $ticketId = null, $virtualBarcodeUsageId = null)
    {
        $this
            ->setBarcode($barcode)
            ->setBarcodeId($barcodeId)
            ->setBarcodeUsageId($barcodeUsageId)
            ->setFailureReasonCode($failureReasonCode)
            ->setFailureReasonDescr($failureReasonDescr)
            ->setIsFirstScan($isFirstScan)
            ->setScanAction($scanAction)
            ->setScanDate($scanDate)
            ->setScanSucceeded($scanSucceeded)
            ->setScannedRefEntityId($scannedRefEntityId)
            ->setTicketId($ticketId)
            ->setVirtualBarcodeUsageId($virtualBarcodeUsageId);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeId()
    {
        return isset($this->BarcodeId) ? $this->BarcodeId : null;
    }
    /**
     * Set BarcodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeId
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setBarcodeId($barcodeId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeId) && !is_string($barcodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeId, true), gettype($barcodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeId, true)), __LINE__);
        }
        if (is_null($barcodeId) || (is_array($barcodeId) && empty($barcodeId))) {
            unset($this->BarcodeId);
        } else {
            $this->BarcodeId = $barcodeId;
        }
        return $this;
    }
    /**
     * Get BarcodeUsageId value
     * @return string|null
     */
    public function getBarcodeUsageId()
    {
        return $this->BarcodeUsageId;
    }
    /**
     * Set BarcodeUsageId value
     * @param string $barcodeUsageId
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setBarcodeUsageId($barcodeUsageId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeUsageId) && !is_string($barcodeUsageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeUsageId, true), gettype($barcodeUsageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeUsageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeUsageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeUsageId, true)), __LINE__);
        }
        $this->BarcodeUsageId = $barcodeUsageId;
        return $this;
    }
    /**
     * Get FailureReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureReasonCode()
    {
        return isset($this->FailureReasonCode) ? $this->FailureReasonCode : null;
    }
    /**
     * Set FailureReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureReasonCode
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setFailureReasonCode($failureReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($failureReasonCode) && !is_string($failureReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureReasonCode, true), gettype($failureReasonCode)), __LINE__);
        }
        if (is_null($failureReasonCode) || (is_array($failureReasonCode) && empty($failureReasonCode))) {
            unset($this->FailureReasonCode);
        } else {
            $this->FailureReasonCode = $failureReasonCode;
        }
        return $this;
    }
    /**
     * Get FailureReasonDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureReasonDescr()
    {
        return isset($this->FailureReasonDescr) ? $this->FailureReasonDescr : null;
    }
    /**
     * Set FailureReasonDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureReasonDescr
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setFailureReasonDescr($failureReasonDescr = null)
    {
        // validation for constraint: string
        if (!is_null($failureReasonDescr) && !is_string($failureReasonDescr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureReasonDescr, true), gettype($failureReasonDescr)), __LINE__);
        }
        if (is_null($failureReasonDescr) || (is_array($failureReasonDescr) && empty($failureReasonDescr))) {
            unset($this->FailureReasonDescr);
        } else {
            $this->FailureReasonDescr = $failureReasonDescr;
        }
        return $this;
    }
    /**
     * Get IsFirstScan value
     * @return bool|null
     */
    public function getIsFirstScan()
    {
        return $this->IsFirstScan;
    }
    /**
     * Set IsFirstScan value
     * @param bool $isFirstScan
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setIsFirstScan($isFirstScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstScan) && !is_bool($isFirstScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstScan, true), gettype($isFirstScan)), __LINE__);
        }
        $this->IsFirstScan = $isFirstScan;
        return $this;
    }
    /**
     * Get ScanAction value
     * @return int|null
     */
    public function getScanAction()
    {
        return $this->ScanAction;
    }
    /**
     * Set ScanAction value
     * @param int $scanAction
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setScanAction($scanAction = null)
    {
        // validation for constraint: int
        if (!is_null($scanAction) && !(is_int($scanAction) || ctype_digit($scanAction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scanAction, true), gettype($scanAction)), __LINE__);
        }
        $this->ScanAction = $scanAction;
        return $this;
    }
    /**
     * Get ScanDate value
     * @return string|null
     */
    public function getScanDate()
    {
        return $this->ScanDate;
    }
    /**
     * Set ScanDate value
     * @param string $scanDate
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanDate, true), gettype($scanDate)), __LINE__);
        }
        $this->ScanDate = $scanDate;
        return $this;
    }
    /**
     * Get ScanSucceeded value
     * @return bool|null
     */
    public function getScanSucceeded()
    {
        return $this->ScanSucceeded;
    }
    /**
     * Set ScanSucceeded value
     * @param bool $scanSucceeded
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setScanSucceeded($scanSucceeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($scanSucceeded) && !is_bool($scanSucceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scanSucceeded, true), gettype($scanSucceeded)), __LINE__);
        }
        $this->ScanSucceeded = $scanSucceeded;
        return $this;
    }
    /**
     * Get ScannedRefEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannedRefEntityId()
    {
        return isset($this->ScannedRefEntityId) ? $this->ScannedRefEntityId : null;
    }
    /**
     * Set ScannedRefEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannedRefEntityId
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setScannedRefEntityId($scannedRefEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($scannedRefEntityId) && !is_string($scannedRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannedRefEntityId, true), gettype($scannedRefEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scannedRefEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scannedRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scannedRefEntityId, true)), __LINE__);
        }
        if (is_null($scannedRefEntityId) || (is_array($scannedRefEntityId) && empty($scannedRefEntityId))) {
            unset($this->ScannedRefEntityId);
        } else {
            $this->ScannedRefEntityId = $scannedRefEntityId;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
    /**
     * Get VirtualBarcodeUsageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVirtualBarcodeUsageId()
    {
        return isset($this->VirtualBarcodeUsageId) ? $this->VirtualBarcodeUsageId : null;
    }
    /**
     * Set VirtualBarcodeUsageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $virtualBarcodeUsageId
     * @return \patest\StructType\OfflineScanBarcodeUsage
     */
    public function setVirtualBarcodeUsageId($virtualBarcodeUsageId = null)
    {
        // validation for constraint: string
        if (!is_null($virtualBarcodeUsageId) && !is_string($virtualBarcodeUsageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualBarcodeUsageId, true), gettype($virtualBarcodeUsageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($virtualBarcodeUsageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $virtualBarcodeUsageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($virtualBarcodeUsageId, true)), __LINE__);
        }
        if (is_null($virtualBarcodeUsageId) || (is_array($virtualBarcodeUsageId) && empty($virtualBarcodeUsageId))) {
            unset($this->VirtualBarcodeUsageId);
        } else {
            $this->VirtualBarcodeUsageId = $virtualBarcodeUsageId;
        }
        return $this;
    }
}
